/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.diff.Chunk;
import org.assertj.core.util.diff.Delta;

public class ChangeDelta<T>
extends Delta<T> {
    public ChangeDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws IllegalStateException {
        int i2;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (i2 = 0; i2 < size; ++i2) {
            target.remove(position);
        }
        i2 = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i2, line);
            ++i2;
        }
    }

    @Override
    public void verify(List<T> target) throws IllegalStateException {
        this.getOriginal().verify(target);
        Preconditions.checkState(this.getOriginal().getPosition() <= target.size(), "Incorrect patch for delta: delta original position > target size", new Object[0]);
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

