/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractTestProxy
extends CompositePrintable {
    public static final DataKey<AbstractTestProxy> DATA_KEY = DataKey.create((String)"testProxy");
    public static final DataKey<AbstractTestProxy[]> DATA_KEYS = DataKey.create((String)"testProxies");
    protected Printer myPrinter = null;

    public abstract boolean isInProgress();

    public abstract boolean isDefect();

    public abstract boolean shouldRun();

    public abstract int getMagnitude();

    public abstract boolean isLeaf();

    public abstract boolean isInterrupted();

    public abstract boolean hasPassedTests();

    public abstract boolean isIgnored();

    public abstract boolean isPassed();

    public abstract String getName();

    public abstract boolean isConfig();

    public abstract Location getLocation(@NotNull Project var1, @NotNull GlobalSearchScope var2);

    public abstract Navigatable getDescriptor(@Nullable Location var1, @NotNull TestConsoleProperties var2);

    public abstract AbstractTestProxy getParent();

    public abstract List<? extends AbstractTestProxy> getChildren();

    public abstract List<? extends AbstractTestProxy> getAllTests();

    @Nullable
    public Long getDuration() {
        return null;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Long getCustomizedDuration(@NotNull TestConsoleProperties testConsoleProperties) {
        if (testConsoleProperties == null) {
            AbstractTestProxy.$$$reportNull$$$0(0);
        }
        return this.getDuration();
    }

    @Nls
    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        return null;
    }

    public abstract boolean shouldSkipRootNodeForExport();

    protected void fireOnNewPrintable(@NotNull Printable printable) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(1);
        }
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public void setPrinter(Printer printer) {
        this.myPrinter = printer;
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            abstractTestProxy.setPrinter(printer);
        }
    }

    @Override
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(2);
        }
        super.addLast(printable);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(3);
        }
        super.insert(printable, i);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            Disposer.dispose((Disposable)abstractTestProxy);
        }
    }

    @Override
    public int getExceptionMark() {
        if (this.myExceptionMark == 0 && !this.getChildren().isEmpty()) {
            return this.getChildren().get(0).getExceptionMark();
        }
        return this.myExceptionMark;
    }

    @NotNull
    public @Unmodifiable List<DiffHyperlink> getDiffViewerProviders() {
        DiffHyperlink provider = this.getDiffViewerProvider();
        List list2 = ContainerUtil.createMaybeSingletonList((Object)provider);
        if (list2 == null) {
            AbstractTestProxy.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    public String getStacktrace() {
        return null;
    }

    @Nullable
    public DiffHyperlink getLeafDiffViewerProvider() {
        DiffHyperlink provider = this.getDiffViewerProvider();
        if (provider != null) {
            return provider;
        }
        if (this.isDefect()) {
            for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
                provider = abstractTestProxy.getLeafDiffViewerProvider();
                if (provider == null) continue;
                return provider;
            }
        }
        return null;
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        return null;
    }

    @Override
    public DiffHyperlink createHyperlink(String expected, String actual, String filePath, String actualFilePath, boolean printOneLine) {
        DiffHyperlink hyperlink = super.createHyperlink(expected, actual, filePath, actualFilePath, printOneLine);
        hyperlink.setTestProxy(this);
        return hyperlink;
    }

    @Nullable
    public String getLocationUrl() {
        return null;
    }

    @Nullable
    public String getMetainfo() {
        return null;
    }

    @Nullable
    public String getErrorMessage() {
        return null;
    }

    @Nullable
    public static TestProxyRoot getTestRoot(@NotNull AbstractTestProxy proxy) {
        AbstractTestProxy parent;
        if (proxy == null) {
            AbstractTestProxy.$$$reportNull$$$0(5);
        }
        if (proxy instanceof TestProxyRoot) {
            return (TestProxyRoot)((Object)proxy);
        }
        for (parent = proxy.getParent(); parent != null && !(parent instanceof TestProxyRoot); parent = parent.getParent()) {
        }
        return parent != null ? (TestProxyRoot)((Object)parent) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsoleProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/AbstractTestProxy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/AbstractTestProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffViewerProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizedDuration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireOnNewPrintable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLast";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

