/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.autotest.AutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AdjustAutotestDelayActionGroup
extends ActionGroup {
    public static final int MAX_DELAY = 10;

    public AdjustAutotestDelayActionGroup() {
        super(TestRunnerBundle.message("action.AdjustAutotestDelayActionGroup.set.autotest.delay.text", new Object[0]), true);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AdjustAutotestDelayActionGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AdjustAutotestDelayActionGroup.$$$reportNull$$$0(1);
        }
        RunContentDescriptor descriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        boolean visible = false;
        if (descriptor != null) {
            for (AnAction action : descriptor.getRestartActions()) {
                if (!(action instanceof ToggleAutoTestAction)) continue;
                visible = ((ToggleAutoTestAction)((Object)action)).isDelayApplicable();
                break;
            }
        }
        e.getPresentation().setVisible(visible);
    }

    @Override
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] actions = new AnAction[10];
        for (int i = 0; i < 10; ++i) {
            actions[i] = new SetAutoTestDelayAction(i + 1);
        }
        if (actions == null) {
            AdjustAutotestDelayActionGroup.$$$reportNull$$$0(2);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class SetAutoTestDelayAction
    extends ToggleAction {
        private final int myDelay;

        SetAutoTestDelayAction(int delay) {
            super(TestRunnerBundle.message("action.seconds.text", delay));
            this.myDelay = delay * 1000;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                SetAutoTestDelayAction.$$$reportNull$$$0(0);
            }
            return (project = e.getProject()) != null && AutoTestManager.getInstance(project).getDelay() == this.myDelay;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SetAutoTestDelayAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Project project;
            if (e == null) {
                SetAutoTestDelayAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) != null) {
                AutoTestManager.getInstance(project).setDelay(this.myDelay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup$SetAutoTestDelayAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup$SetAutoTestDelayAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

