/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PromptingMacro
extends Macro {
    @Override
    @Nullable
    protected TextRange getRangeForSuffix(@NotNull CharSequence s, int start, int next) {
        if (s == null) {
            PromptingMacro.$$$reportNull$$$0(0);
        }
        return switch (s.charAt(next)) {
            case '$' -> TextRange.create((int)start, (int)(next + 1));
            case ':' -> {
                int end = Strings.indexOf((CharSequence)s, (char)'$', (int)next);
                if (end < 0) {
                    yield null;
                }
                yield TextRange.create((int)start, (int)(end + 1));
            }
            default -> null;
        };
    }

    @Override
    public String expandOccurence(@NotNull DataContext context, @NotNull String occurence) throws Macro.ExecutionCancelledException {
        String[] strings;
        if (context == null) {
            PromptingMacro.$$$reportNull$$$0(1);
        }
        if (occurence == null) {
            PromptingMacro.$$$reportNull$$$0(2);
        }
        String label = (strings = StringUtil.trimEnd((String)occurence, (String)"$").split(":")).length > 1 ? strings[1] : null;
        String defaultValue = strings.length > 2 ? strings[2] : null;
        return this.expand(context, label, defaultValue);
    }

    private String expand(@NotNull DataContext dataContext, @Nullable String label, @Nullable String defaultValue) throws Macro.ExecutionCancelledException {
        if (dataContext == null) {
            PromptingMacro.$$$reportNull$$$0(3);
        }
        Ref userInput = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> userInput.set((Object)this.promptUser(dataContext, label, defaultValue)));
        if (userInput.isNull()) {
            throw new Macro.ExecutionCancelledException();
        }
        return (String)userInput.get();
    }

    @Override
    public final String expand(@NotNull DataContext dataContext) throws Macro.ExecutionCancelledException {
        if (dataContext == null) {
            PromptingMacro.$$$reportNull$$$0(4);
        }
        return this.expand(dataContext, (String)null, (String)null);
    }

    @Override
    @Nullable
    public String preview(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PromptingMacro.$$$reportNull$$$0(5);
        }
        return "<params>";
    }

    @Nullable
    protected abstract String promptUser(@NotNull DataContext var1, @Nullable String var2, @Nullable String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurence";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/macro/PromptingMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeForSuffix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "expandOccurence";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "expand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "preview";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

