/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TreeUpdatePass {
    private final DefaultMutableTreeNode myNode;
    private long myUpdateStamp;
    private boolean myExpired;
    private DefaultMutableTreeNode myCurrentNode;
    private final long myAllocation;
    private boolean myUpdateChildren;
    private boolean myUpdateStructure;
    private final Set<NodeDescriptor> myUpdatedDescriptors;

    public TreeUpdatePass(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            TreeUpdatePass.$$$reportNull$$$0(0);
        }
        this.myUpdateChildren = true;
        this.myUpdateStructure = true;
        this.myUpdatedDescriptors = new HashSet<NodeDescriptor>();
        this.myNode = node;
        this.myAllocation = System.currentTimeMillis();
    }

    public TreeUpdatePass setUpdateChildren(boolean updateChildren) {
        this.myUpdateChildren = updateChildren;
        return this;
    }

    public boolean isUpdateChildren() {
        return this.myUpdateChildren;
    }

    @NotNull
    public DefaultMutableTreeNode getNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.myNode;
        if (defaultMutableTreeNode == null) {
            TreeUpdatePass.$$$reportNull$$$0(1);
        }
        return defaultMutableTreeNode;
    }

    public TreeUpdatePass setUpdateStamp(long updateCount) {
        this.myUpdateStamp = updateCount;
        return this;
    }

    public long getUpdateStamp() {
        return this.myUpdateStamp;
    }

    public void expire() {
        this.myExpired = true;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.myCurrentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.myCurrentNode = currentNode;
    }

    @NonNls
    public String toString() {
        return "TreeUpdatePass node=" + String.valueOf(this.myNode) + " structure=" + this.myUpdateStructure + " stamp=" + this.myUpdateStamp + " expired=" + this.myExpired + " currentNode=" + String.valueOf(this.myCurrentNode) + " allocation=" + this.myAllocation;
    }

    public boolean willUpdate(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            TreeUpdatePass.$$$reportNull$$$0(2);
        }
        @NotNull DefaultMutableTreeNode currentNode = this.myCurrentNode != null ? this.myCurrentNode : this.myNode;
        return node.isNodeAncestor(currentNode);
    }

    public TreeUpdatePass setUpdateStructure(boolean update) {
        this.myUpdateStructure = update;
        return this;
    }

    public boolean isUpdateStructure() {
        return this.myUpdateStructure;
    }

    public void addToUpdated(NodeDescriptor nodeDescriptor) {
        this.myUpdatedDescriptors.add(nodeDescriptor);
    }

    public boolean isUpdated(NodeDescriptor descriptor) {
        return this.myUpdatedDescriptors.contains(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeUpdatePass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeUpdatePass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "willUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

