/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.CompressingLayoutStrategyKt;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/actionSystem/toolbarLayout/CompressingLayoutStrategy;", "Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;", "<init>", "()V", "calculateBounds", "", "Ljava/awt/Rectangle;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "calcPreferredSize", "Ljava/awt/Dimension;", "calcMinimumSize", "distributeSize", "", "availableSize", "toolbars", "intellij.platform.editor.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCompressingLayoutStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressingLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/CompressingLayoutStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1#2:244\n1300#3,2:245\n1315#3,4:247\n1300#3,2:251\n1315#3,4:253\n1300#3,2:257\n1315#3,4:259\n*S KotlinDebug\n*F\n+ 1 CompressingLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/CompressingLayoutStrategy\n*L\n69#1:245,2\n69#1:247,4\n70#1:251,2\n70#1:253,4\n75#1:257,2\n75#1:259,4\n*E\n"})
public final class CompressingLayoutStrategy
implements ToolbarLayoutStrategy {
    @NotNull
    public static final CompressingLayoutStrategy INSTANCE = new CompressingLayoutStrategy();

    private CompressingLayoutStrategy() {
    }

    @Override
    @NotNull
    public List<Rectangle> calculateBounds(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent toolbarComponent = jComponent;
        int componentCount = toolbarComponent.getComponentCount();
        JComponent jComponent2 = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        int nonCompressibleWidth = CompressingLayoutStrategyKt.access$getNonCompressibleWidth(jComponent2);
        int availableWidth = toolbar2.getComponent().getWidth() - nonCompressibleWidth;
        List resizableComponents = CompressingLayoutStrategyKt.access$collectResizableComponents(toolbar2);
        Map resizableComponentWidths = CompressingLayoutStrategyKt.access$calculateResizableComponentWidths(availableWidth, resizableComponents);
        Map componentWidths = CompressingLayoutStrategyKt.access$calculateComponentWidths(toolbar2, resizableComponentWidths);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(componentCount);
        int n = 0;
        while (n < componentCount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Rectangle> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new Rectangle());
        }
        List bounds = arrayList;
        Component[] componentArray = toolbarComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        CompressingLayoutStrategyKt.access$calculateComponentSizes(componentArray, componentWidths, bounds);
        CompressingLayoutStrategyKt.access$layoutComponents(toolbarComponent, bounds);
        CompressingLayoutStrategyKt.access$rightAlignComponents(toolbarComponent, bounds);
        return bounds;
    }

    @Override
    @NotNull
    public Dimension calcPreferredSize(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        Dimension res = new Dimension();
        res.height = ActionToolbar.experimentalToolbarMinimumButtonSize().height;
        Component[] componentArray = toolbar2.getComponent().getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            res.width += size.width;
            res.height = Math.max(res.height, size.height);
        }
        JBInsets.addTo((Dimension)res, (Insets)toolbar2.getComponent().getInsets());
        return res;
    }

    @Override
    @NotNull
    public Dimension calcMinimumSize(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        JBDimension jBDimension = JBUI.emptySize();
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
        return (Dimension)jBDimension;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ActionToolbar, Dimension> distributeSize(@NotNull Dimension availableSize, @NotNull List<? extends ActionToolbar> toolbars) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWithTo$iv$iv2;
        Object object;
        Map map;
        Object object2;
        void $this$associateWithTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)availableSize, (String)"availableSize");
        Intrinsics.checkNotNullParameter(toolbars, (String)"toolbars");
        if (toolbars.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$associateWith$iv = toolbars;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv3) {
            void toolbar2;
            ActionToolbar actionToolbar = (ActionToolbar)element$iv$iv;
            object2 = element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            object = CompressingLayoutStrategyKt.access$collectResizableComponents((ActionToolbar)toolbar2);
            map.put(object2, object);
        }
        Map resizableComponents = destination$iv$iv;
        Iterable $this$associateWith$iv2 = toolbars;
        boolean $i$f$associateWith2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv2;
        Iterator destination$iv$iv2 = result$iv2;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void toolbar3;
            ActionToolbar bl = (ActionToolbar)element$iv$iv;
            object2 = element$iv$iv;
            map = destination$iv$iv2;
            boolean bl2 = false;
            JComponent jComponent = toolbar3.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            object = CompressingLayoutStrategyKt.access$getNonCompressibleWidth(jComponent);
            map.put(object2, object);
        }
        Map nonCompressibleWidths = destination$iv$iv2;
        int availableWidth = availableSize.width - CollectionsKt.sumOfInt((Iterable)nonCompressibleWidths.values());
        Map resizableComponentWidths = CompressingLayoutStrategyKt.access$calculateResizableComponentWidths(availableWidth, CollectionsKt.flatten((Iterable)resizableComponents.values()));
        destination$iv$iv2 = ((Iterable)toolbars).iterator();
        if (!destination$iv$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        ActionToolbar toolbar22 = (ActionToolbar)destination$iv$iv2.next();
        boolean bl = false;
        int toolbar22 = toolbar22.getComponent().getPreferredSize().height;
        while (destination$iv$iv2.hasNext()) {
            ActionToolbar toolbar32 = (ActionToolbar)destination$iv$iv2.next();
            $i$a$-maxOf-CompressingLayoutStrategy$distributeSize$height$1 = false;
            int toolbar32 = toolbar32.getComponent().getPreferredSize().height;
            if (toolbar22 >= toolbar32) continue;
            toolbar22 = toolbar32;
        }
        int height = RangesKt.coerceAtLeast((int)toolbar22, (int)ActionToolbar.experimentalToolbarMinimumButtonSize().height);
        Iterable $this$associateWith$iv3 = toolbars;
        boolean $i$f$associateWith3 = false;
        LinkedHashMap result$iv3 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv3, (int)10)), (int)16));
        Iterable toolbar32 = $this$associateWith$iv3;
        Map destination$iv$iv3 = result$iv3;
        boolean $i$f$associateWithTo3 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void toolbar4;
            ActionToolbar actionToolbar = (ActionToolbar)element$iv$iv;
            object2 = element$iv$iv;
            map = destination$iv$iv3;
            boolean bl3 = false;
            int width = toolbar4.getComponent().isVisible() ? ((Number)MapsKt.getValue((Map)CompressingLayoutStrategyKt.access$calculateComponentWidths((ActionToolbar)toolbar4, resizableComponentWidths), (Object)toolbar4.getComponent())).intValue() : 0;
            object = new Dimension(width, height);
            map.put(object2, object);
        }
        return destination$iv$iv3;
    }
}

