/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J%\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u0012\b\u0001\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001J%\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u0012\b\u0001\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/actionSystem/toolbarLayout/RightActionsAdjusterStrategyWrapper;", "Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;", "delegate", "<init>", "(Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;)V", "calculateBounds", "", "Ljava/awt/Rectangle;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "calcMinimumSize", "Ljava/awt/Dimension;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "calcPreferredSize", "intellij.platform.editor.ui"})
public final class RightActionsAdjusterStrategyWrapper
implements ToolbarLayoutStrategy {
    @NotNull
    private final ToolbarLayoutStrategy delegate;

    public RightActionsAdjusterStrategyWrapper(@NotNull ToolbarLayoutStrategy delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public List<Rectangle> calculateBounds(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        List<Rectangle> bounds = this.delegate.calculateBounds(toolbar2);
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        int componentCount = component.getComponentCount();
        int componentWidth = component.getWidth();
        if (componentCount > 0) {
            Insets insets = component.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            Insets insets2 = insets;
            int rightOffset = insets2.right;
            int i = componentCount - 1;
            int j = 1;
            while (i > 0) {
                Component child;
                Intrinsics.checkNotNullExpressionValue((Object)component.getComponent(i), (String)"getComponent(...)");
                if (child instanceof JComponent && Intrinsics.areEqual((Object)((JComponent)child).getClientProperty("RIGHT_ALIGN"), (Object)true)) {
                    Intrinsics.checkNotNullExpressionValue((Object)bounds.get(bounds.size() - j), (String)"get(...)");
                    r.x = componentWidth - (rightOffset += bounds.get((int)i).width);
                }
                --i;
                ++j;
            }
        }
        Intrinsics.checkNotNull(bounds);
        return bounds;
    }

    @Override
    public Dimension calcPreferredSize(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        return this.delegate.calcPreferredSize(toolbar2);
    }

    @Override
    public Dimension calcMinimumSize(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        return this.delegate.calcMinimumSize(toolbar2);
    }
}

