/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml;

import com.intellij.platform.ml.MLApiPlatform;
import com.intellij.platform.ml.MLTask;
import com.intellij.platform.ml.MLTaskApproachBuilder;
import com.intellij.platform.ml.ScopeEnvironment;
import com.intellij.platform.ml.Session;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.environment.Environment;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u0000 \u0011*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0011J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u00a6@\u00a2\u0006\u0002\u0010\u0010R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/MLTaskApproach;", "P", "", "task", "Lcom/intellij/platform/ml/MLTask;", "getTask", "()Lcom/intellij/platform/ml/MLTask;", "apiPlatform", "Lcom/intellij/platform/ml/MLApiPlatform;", "getApiPlatform", "()Lcom/intellij/platform/ml/MLApiPlatform;", "startSession", "Lcom/intellij/platform/ml/Session$StartOutcome;", "callParameters", "Lcom/intellij/platform/ml/environment/Environment;", "permanentSessionEnvironment", "(Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/environment/Environment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.ml"})
@ApiStatus.Internal
public interface MLTaskApproach<P> {
    @NotNull
    public static final Companion Companion = com.intellij.platform.ml.MLTaskApproach$Companion.$$INSTANCE;

    @NotNull
    public MLTask<P> getTask();

    @NotNull
    public MLApiPlatform getApiPlatform();

    @Nullable
    public Object startSession(@NotNull Environment var1, @NotNull Environment var2, @NotNull Continuation<? super Session.StartOutcome<P>> var3);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\nJD\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\b\b\u0001\u0010\u0006*\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0010J@\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\b\b\u0001\u0010\u0006*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0011J<\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/ml/MLTaskApproach$Companion;", "", "<init>", "()V", "findMlTaskApproach", "Lcom/intellij/platform/ml/MLTaskApproachBuilder;", "P", "task", "Lcom/intellij/platform/ml/MLTask;", "apiPlatform", "Lcom/intellij/platform/ml/MLApiPlatform;", "startMLSession", "Lcom/intellij/platform/ml/Session$StartOutcome;", "callParameters", "Lcom/intellij/platform/ml/environment/Environment;", "permanentSessionEnvironment", "(Lcom/intellij/platform/ml/MLTask;Lcom/intellij/platform/ml/MLApiPlatform;Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/environment/Environment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/intellij/platform/ml/MLTask;Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/MLApiPlatform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateEnvironment", "", "expectedCallParameters", "", "Lcom/intellij/platform/ml/Tier;", "expectedPermanentTiers", "intellij.platform.ml"})
    @SourceDebugExtension(value={"SMAP\nMLTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLTask.kt\ncom/intellij/platform/ml/MLTaskApproach$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final <P> MLTaskApproachBuilder<P> findMlTaskApproach(@NotNull MLTask<P> task2, @NotNull MLApiPlatform apiPlatform) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter(task2, (String)"task");
                Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
                Iterable iterable = apiPlatform.getTaskApproaches();
                for (Object t : iterable) {
                    MLTaskApproachBuilder it = (MLTaskApproachBuilder)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getTask(), task2)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if (v0 == null) {
                boolean bl = false;
                String string = StringsKt.trimIndent((String)("\n        No approach for task " + task2 + " was registered in " + apiPlatform + ".\n        Available approaches: " + apiPlatform.getTaskApproaches() + "\n        "));
                throw new IllegalArgumentException(string.toString());
            }
            MLTaskApproachBuilder taskApproachBuilder = v0;
            Intrinsics.checkNotNull((Object)taskApproachBuilder, (String)"null cannot be cast to non-null type com.intellij.platform.ml.MLTaskApproachBuilder<P of com.intellij.platform.ml.MLTaskApproach.Companion.findMlTaskApproach>");
            return taskApproachBuilder;
        }

        @Nullable
        public final <P> Object startMLSession(@NotNull MLTask<P> task2, @NotNull MLApiPlatform apiPlatform, @NotNull Environment callParameters, @NotNull Environment permanentSessionEnvironment, @NotNull Continuation<? super Session.StartOutcome<P>> $completion) {
            this.validateEnvironment(callParameters, (Set)CollectionsKt.first(task2.getCallParameters()), permanentSessionEnvironment, (Set)CollectionsKt.first(task2.getLevels()));
            MLTaskApproach<P> approach = this.findMlTaskApproach(task2, apiPlatform).buildApproach(apiPlatform);
            ScopeEnvironment safelyAccessibleCallParameters = ScopeEnvironment.Companion.restrictedBy(callParameters, (Set)CollectionsKt.first(task2.getCallParameters()));
            return approach.startSession(safelyAccessibleCallParameters, permanentSessionEnvironment, $completion);
        }

        @Nullable
        public final <P> Object startMLSession(@NotNull MLTask<P> $this$startMLSession, @NotNull Environment callParameters, @NotNull Environment permanentSessionEnvironment, @NotNull MLApiPlatform apiPlatform, @NotNull Continuation<? super Session.StartOutcome<P>> $completion) {
            return this.startMLSession($this$startMLSession, apiPlatform, callParameters, permanentSessionEnvironment, $completion);
        }

        private final void validateEnvironment(Environment callParameters, Set<? extends Tier<?>> expectedCallParameters, Environment permanentSessionEnvironment, Set<? extends Tier<?>> expectedPermanentTiers) {
            if (!Intrinsics.areEqual(callParameters.getTiers(), expectedCallParameters)) {
                boolean $i$a$-require-MLTaskApproach$Companion$validateEnvironment$32 = false;
                String $i$a$-require-MLTaskApproach$Companion$validateEnvironment$32 = StringsKt.trimIndent((String)("\n        Invalid call parameters passed.\n          Missing: " + SetsKt.minus(expectedCallParameters, (Iterable)callParameters.getTiers()) + "\n          Redundant: " + SetsKt.minus(callParameters.getTiers(), (Iterable)expectedCallParameters) + "\n        "));
                throw new IllegalArgumentException($i$a$-require-MLTaskApproach$Companion$validateEnvironment$32.toString());
            }
            if (!Intrinsics.areEqual(permanentSessionEnvironment.getTiers(), expectedPermanentTiers)) {
                boolean bl = false;
                String string = StringsKt.trimIndent((String)("\n        Invalid main environment passed.\n          Missing: " + SetsKt.minus(expectedPermanentTiers, (Iterable)permanentSessionEnvironment.getTiers()) + "\n          Redundant: " + SetsKt.minus(permanentSessionEnvironment.getTiers(), (Iterable)expectedPermanentTiers) + "\n        "));
                throw new IllegalArgumentException(string.toString());
            }
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

