/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.IoKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ*\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0018J*\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0018J*\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0018R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ManifestFileName", "", "HashSeed", "isSymlink", "", "file", "Ljava/nio/file/Path;", "getFileFirstBytes", "", "length", "", "decompressWithManifest", "", "archiveFile", "targetDir", "includeModifiedDate", "includeInManifest", "Lkotlin/Function1;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "generateDirectoryManifest", "root", "isUpToDate", "getExtractDirectory", "Lcom/intellij/remoteDev/util/FileManifestUtil$ExtractDirectory;", "path", "filterPaths", "ManifestGenerator", "ExtractDirectory", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFileManifestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManifestUtil.kt\ncom/intellij/remoteDev/util/FileManifestUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1#2:307\n1915#3,2:308\n*S KotlinDebug\n*F\n+ 1 FileManifestUtil.kt\ncom/intellij/remoteDev/util/FileManifestUtil\n*L\n267#1:308,2\n*E\n"})
public final class FileManifestUtil {
    @NotNull
    public static final FileManifestUtil INSTANCE = new FileManifestUtil();
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String ManifestFileName = ".manifest.txt";
    @NotNull
    public static final String HashSeed = "e69b0a64-b91a-4da6-bc80-35828c9a97d1";

    private FileManifestUtil() {
    }

    private final boolean isSymlink(Path file) {
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)file.toFile());
        return fileAttributes != null ? fileAttributes.isSymLink() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getFileFirstBytes(Path file, int length) {
        ByteBuffer start = ByteBuffer.allocate(length);
        Closeable closeable = FileChannel.open(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)closeable;
            boolean bl = false;
            int n = channel.read(start, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        start.flip();
        if (!(start.remaining() == length)) {
            boolean bl = false;
            String string = "File " + file + " is smaller than " + length + " bytes";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)start);
        return IoKt.toByteArray$default((ByteBuffer)start, (boolean)false, (int)1, null);
    }

    public final void decompressWithManifest(@NotNull Path archiveFile, @NotNull Path targetDir, boolean includeModifiedDate, @NotNull Function1<? super Path, Boolean> includeInManifest, @Nullable ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(targetDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException((targetDir + " already exists, refusing to extract to it").toString());
        }
        byte[] start = this.getFileFirstBytes(archiveFile, 2);
        ManifestGenerator manifestor = new ManifestGenerator(targetDir, includeInManifest, includeModifiedDate, progress, Files.size(archiveFile));
        if (start[0] == 80 && start[1] == 75) {
            new Decompressor.Zip(archiveFile).withZipExtensions().escapingSymlinkPolicy(Decompressor.EscapingSymlinkPolicy.DISALLOW).postProcessor((BiConsumer)manifestor).extract(targetDir);
        } else if (start[0] == 31 && start[1] == -117) {
            new Decompressor.Tar(archiveFile).escapingSymlinkPolicy(Decompressor.EscapingSymlinkPolicy.DISALLOW).postProcessor((BiConsumer)manifestor).extract(targetDir);
        } else {
            throw new IllegalStateException(("Unsupported archive: file:" + PathsKt.getName((Path)archiveFile) + " magic:" + ArraysKt.joinToString$default((byte[])start, (CharSequence)" ", null, null, (int)0, null, FileManifestUtil::decompressWithManifest$lambda$0, (int)30, null)).toString());
        }
        manifestor.writeToDisk(targetDir);
    }

    public static /* synthetic */ void decompressWithManifest$default(FileManifestUtil fileManifestUtil, Path path, Path path2, boolean bl, Function1 function1, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        fileManifestUtil.decompressWithManifest(path, path2, bl, (Function1<? super Path, Boolean>)function1, progressIndicator);
    }

    @NotNull
    public final String generateDirectoryManifest(@NotNull Path root, boolean includeModifiedDate, @NotNull Function1<? super Path, Boolean> includeInManifest) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        ManifestGenerator manifestor = new ManifestGenerator(root, includeInManifest, includeModifiedDate, null, null, 24, null);
        manifestor.calculateForExistingDirectory();
        return manifestor.generate();
    }

    public final boolean isUpToDate(@NotNull Path root, boolean includeModifiedDate, @NotNull Function1<? super Path, Boolean> includeInManifest) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        Path manifestFile = root.resolve(ManifestFileName);
        Intrinsics.checkNotNull((Object)manifestFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(manifestFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("isUpToDate false for '" + root + "': manifest file " + manifestFile + " does not exist");
            return false;
        }
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        String manifestFileContent = PathsKt.readText((Path)manifestFile, (Charset)charset);
        String actualOnDiskContent = this.generateDirectoryManifest(root, includeModifiedDate, includeInManifest);
        if (Intrinsics.areEqual((Object)manifestFileContent, (Object)actualOnDiskContent)) {
            logger.info("isUpToDate true for '" + root + "': manifest file " + manifestFile + " contains actual information");
            return true;
        }
        logger.info("isUpToDate false for '" + root + "': manifest file " + manifestFile + " differs from on disk content\non disk content:\n" + actualOnDiskContent + "\nsaved manifest in " + manifestFile + " content:\n" + manifestFileContent);
        HashSet onDiskLines = CollectionsKt.toHashSet((Iterable)StringsKt.lines((CharSequence)actualOnDiskContent));
        HashSet manifestLines = CollectionsKt.toHashSet((Iterable)StringsKt.lines((CharSequence)manifestFileContent));
        Set commonLines = CollectionsKt.intersect((Iterable)onDiskLines, (Iterable)manifestLines);
        Set onDiskOnly = SetsKt.minus((Set)onDiskLines, (Iterable)commonLines);
        Set manifestOnly = SetsKt.minus((Set)manifestLines, (Iterable)commonLines);
        logger.info(onDiskOnly.size() + " elements are present only on disk and not found in the manifest: " + CollectionsKt.joinToString$default((Iterable)onDiskOnly, null, null, null, (int)0, null, FileManifestUtil::isUpToDate$lambda$0, (int)31, null));
        logger.info(manifestOnly.size() + " elements are present only in the manifest and not found on disk: " + CollectionsKt.joinToString$default((Iterable)manifestOnly, null, null, null, (int)0, null, FileManifestUtil::isUpToDate$lambda$1, (int)31, null));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExtractDirectory getExtractDirectory(@NotNull Path path, boolean includeModifiedDate, @NotNull Function1<? super Path, Boolean> filterPaths) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filterPaths, (String)"filterPaths");
        String suffix = "." + ProcessHandle.current().pid() + "." + System.currentTimeMillis();
        int retriesCount = 100;
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, retriesCount);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int attempt = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Path destinationPath = attempt <= 1 ? path : Path.of(path + "-" + attempt, new String[0]);
            Intrinsics.checkNotNull((Object)destinationPath);
            boolean isUpToDate = INSTANCE.isUpToDate(destinationPath, includeModifiedDate, filterPaths);
            if (isUpToDate) {
                logger.info("All files inside extract directory '" + destinationPath + "' are up-to-date");
                return new ExtractDirectory(destinationPath, true);
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(destinationPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("Destination extract directory path does not exist: '" + destinationPath + "'. Use this path.");
                return new ExtractDirectory(destinationPath, false);
            }
            Path renamedPath = new File(destinationPath + suffix).toPath();
            try {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Files.move(destinationPath, renamedPath, copyOptionArray);
            }
            catch (Throwable t) {
                logger.debug("Rename '" + destinationPath + "' to '" + renamedPath + "' has failed. Probably file is locked by another process. Trying the next one.");
                continue;
            }
            finally {
                try {
                    FileUtil.delete((Path)renamedPath);
                }
                catch (Throwable t) {
                    logger.warn("Unable to delete renamed destination (generally should not happen): " + renamedPath, t);
                }
                continue;
            }
            logger.info("Destination was deleted, returning path '" + destinationPath + "'");
            return new ExtractDirectory(destinationPath, false);
        }
        throw new IllegalStateException("Exceeded " + retriesCount + " retries to get safe destination based on '" + path + "'.");
    }

    private static final CharSequence decompressWithManifest$lambda$0(byte it) {
        return "0x" + Integer.toHexString(it);
    }

    private static final CharSequence isUpToDate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final CharSequence isUpToDate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileManifestUtil.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ExtractDirectory;", "", "path", "Ljava/nio/file/Path;", "isUpToDate", "", "<init>", "(Ljava/nio/file/Path;Z)V", "getPath", "()Ljava/nio/file/Path;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.remoteDev.util"})
    public static final class ExtractDirectory {
        @NotNull
        private final Path path;
        private final boolean isUpToDate;

        public ExtractDirectory(@NotNull Path path, boolean isUpToDate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.isUpToDate = isUpToDate;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean isUpToDate() {
            return this.isUpToDate;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.isUpToDate;
        }

        @NotNull
        public final ExtractDirectory copy(@NotNull Path path, boolean isUpToDate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ExtractDirectory(path, isUpToDate);
        }

        public static /* synthetic */ ExtractDirectory copy$default(ExtractDirectory extractDirectory, Path path, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path = extractDirectory.path;
            }
            if ((n & 2) != 0) {
                bl = extractDirectory.isUpToDate;
            }
            return extractDirectory.copy(path, bl);
        }

        @NotNull
        public String toString() {
            return "ExtractDirectory(path=" + this.path + ", isUpToDate=" + this.isUpToDate + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.path).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isUpToDate);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtractDirectory)) {
                return false;
            }
            ExtractDirectory extractDirectory = (ExtractDirectory)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)extractDirectory.path)) {
                return false;
            }
            return this.isUpToDate == extractDirectory.isUpToDate;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002%&BE\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J0\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0012J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/util/io/Decompressor$Entry;", "Ljava/nio/file/Path;", "targetDir", "includeInManifest", "Lkotlin/Function1;", "", "includeModifiedDate", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "archiveSize", "", "<init>", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;ZLcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Long;)V", "Ljava/lang/Long;", "list", "", "", "accept", "", "entry", "path", "addManifestEntry", "name", "type", "Lcom/intellij/util/io/Decompressor$Entry$Type;", "mode", "", "size", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "readAttributesNoFollowLinks", "Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$FileAttributes;", "calculateForExistingDirectory", "generate", "writeToDisk", "FileAttributes", "ManifestFileVisitor", "intellij.remoteDev.util"})
    @SourceDebugExtension(value={"SMAP\nFileManifestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManifestUtil.kt\ncom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1#2:307\n*E\n"})
    public static final class ManifestGenerator
    implements BiConsumer<Decompressor.Entry, Path> {
        @NotNull
        private final Path targetDir;
        @NotNull
        private final Function1<Path, Boolean> includeInManifest;
        private final boolean includeModifiedDate;
        @Nullable
        private final ProgressIndicator progress;
        @Nullable
        private final Long archiveSize;
        @NotNull
        private final List<String> list;

        public ManifestGenerator(@NotNull Path targetDir, @NotNull Function1<? super Path, Boolean> includeInManifest, boolean includeModifiedDate, @Nullable ProgressIndicator progress, @Nullable Long archiveSize) {
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
            this.targetDir = targetDir;
            this.includeInManifest = includeInManifest;
            this.includeModifiedDate = includeModifiedDate;
            this.progress = progress;
            this.archiveSize = archiveSize;
            this.list = new ArrayList();
        }

        public /* synthetic */ ManifestGenerator(Path path, Function1 function1, boolean bl, ProgressIndicator progressIndicator, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                progressIndicator = null;
            }
            if ((n & 0x10) != 0) {
                l = null;
            }
            this(path, (Function1<? super Path, Boolean>)function1, bl, progressIndicator, l);
        }

        @Override
        public void accept(@NotNull Decompressor.Entry entry, @NotNull Path path) {
            int n;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (this.progress != null && this.archiveSize != null) {
                Long l = this.archiveSize;
                long l2 = 0L;
                if (l == null || l != l2) {
                    ProgressIndicator progressIndicator = this.progress;
                    progressIndicator.setFraction(progressIndicator.getFraction() + (double)entry.size / (double)this.archiveSize.longValue());
                }
            }
            if (!((Boolean)this.includeInManifest.invoke((Object)path)).booleanValue()) {
                return;
            }
            if (!(!Intrinsics.areEqual((Object)entry.name, (Object)FileManifestUtil.ManifestFileName))) {
                boolean $i$a$-require-FileManifestUtil$ManifestGenerator$accept$32 = false;
                String $i$a$-require-FileManifestUtil$ManifestGenerator$accept$32 = "There already is a manifest file in archive.";
                throw new IllegalArgumentException($i$a$-require-FileManifestUtil$ManifestGenerator$accept$32.toString());
            }
            Path path2 = PathsKt.relativeToOrNull((Path)path, (Path)this.targetDir);
            Comparable comparable = path2 != null ? (Comparable)path2 : (Comparable)((Object)("Extraction path " + ((Object)path.toAbsolutePath()).toString() + " is not relative to " + this.targetDir + ": " + ((Object)path.toAbsolutePath()).toString()));
            String it = entry.name;
            boolean bl = false;
            Object name = entry.type == Decompressor.Entry.Type.DIR ? it + "/" : it;
            if (SystemInfo.isWindows) {
                n = 0;
            } else {
                Decompressor.Entry.Type type = entry.type;
                int normalizedMode = switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1 -> {
                        boolean isOriginallyExecutable;
                        boolean v5 = isOriginallyExecutable = (entry.mode & 0x49) > 0;
                        if (isOriginallyExecutable) {
                            yield 33261;
                        }
                        yield 33188;
                    }
                    case 2 -> -1;
                    case 3 -> 16877;
                    default -> throw new IllegalStateException(("Unknown entry type for " + entry.name).toString());
                };
                if (entry.type != Decompressor.Entry.Type.SYMLINK) {
                    Path path3 = path;
                    String string = "unix:mode";
                    Integer n2 = normalizedMode;
                    LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.setAttribute(path3, string, n2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), (String)"setAttribute(...)");
                }
                n = normalizedMode;
            }
            int mode = n;
            FileAttributes attributes = this.readAttributesNoFollowLinks(path);
            if (entry.type != Decompressor.Entry.Type.SYMLINK && !(attributes.getMode() == mode)) {
                boolean bl2 = false;
                String string = (String)name + ": expected mode: " + mode + ", on disk: " + attributes.getMode();
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)name);
            Decompressor.Entry.Type type = entry.type;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            this.addManifestEntry((String)name, type, mode, attributes.getSize(), attributes.getLastModifiedTime());
        }

        private final void addManifestEntry(String name, Decompressor.Entry.Type type, int mode, long size, FileTime lastModifiedTime) {
            String modifiedDateValue = this.includeModifiedDate ? String.valueOf(lastModifiedTime.toMillis() / (long)1000) : "N/A";
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2: {
                    boolean bl = this.list.add(name + " L " + size + " " + modifiedDateValue);
                    break;
                }
                case 1: {
                    boolean bl = this.list.add(name + " F " + Integer.toOctalString(mode) + " " + size + " " + modifiedDateValue);
                    break;
                }
                case 3: {
                    boolean bl = this.list.add(name + " D " + Integer.toOctalString(mode));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final FileAttributes readAttributesNoFollowLinks(Path path) {
            Object[] objectArray = new String[]{"lastModifiedTime", "size"};
            List attributeList = CollectionsKt.mutableListOf((Object[])objectArray);
            if (!SystemInfo.isWindows) {
                attributeList.add(0, "unix:mode");
            }
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            Map<String, Object> attrs = Files.readAttributes(path, CollectionsKt.joinToString$default((Iterable)attributeList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), linkOptionArray);
            Object object = attrs.get("mode");
            Integer n = object instanceof Integer ? (Integer)object : null;
            int n2 = n != null ? n : 0;
            Object object2 = attrs.get("lastModifiedTime");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.nio.file.attribute.FileTime");
            FileTime fileTime = (FileTime)object2;
            Object object3 = attrs.get("size");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Long");
            return new FileAttributes(n2, fileTime, (Long)object3);
        }

        public final void calculateForExistingDirectory() {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(this.targetDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean bl = false;
                String string = this.targetDir + " is not a directory";
                throw new IllegalArgumentException(string.toString());
            }
            if (!this.list.isEmpty()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Files.walkFileTree(this.targetDir, new ManifestFileVisitor());
        }

        @NotNull
        public final String generate() {
            String contentPart = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.list), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            String string = FileManifestUtil.HashSeed + contentPart;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return DigestUtil.sha256Hex((byte[])byArray) + "\n" + contentPart;
        }

        public final void writeToDisk(@NotNull Path targetDir) {
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Path path = targetDir.resolve(FileManifestUtil.ManifestFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            CharSequence charSequence = this.generate();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            PathsKt.writeText((Path)path, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$FileAttributes;", "", "mode", "", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "size", "", "<init>", "(ILjava/nio/file/attribute/FileTime;J)V", "getMode", "()I", "getLastModifiedTime", "()Ljava/nio/file/attribute/FileTime;", "getSize", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.remoteDev.util"})
        private static final class FileAttributes {
            private final int mode;
            @NotNull
            private final FileTime lastModifiedTime;
            private final long size;

            public FileAttributes(int mode, @NotNull FileTime lastModifiedTime, long size) {
                Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
                this.mode = mode;
                this.lastModifiedTime = lastModifiedTime;
                this.size = size;
            }

            public final int getMode() {
                return this.mode;
            }

            @NotNull
            public final FileTime getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            public final long getSize() {
                return this.size;
            }

            public final int component1() {
                return this.mode;
            }

            @NotNull
            public final FileTime component2() {
                return this.lastModifiedTime;
            }

            public final long component3() {
                return this.size;
            }

            @NotNull
            public final FileAttributes copy(int mode, @NotNull FileTime lastModifiedTime, long size) {
                Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
                return new FileAttributes(mode, lastModifiedTime, size);
            }

            public static /* synthetic */ FileAttributes copy$default(FileAttributes fileAttributes, int n, FileTime fileTime, long l, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = fileAttributes.mode;
                }
                if ((n2 & 2) != 0) {
                    fileTime = fileAttributes.lastModifiedTime;
                }
                if ((n2 & 4) != 0) {
                    l = fileAttributes.size;
                }
                return fileAttributes.copy(n, fileTime, l);
            }

            @NotNull
            public String toString() {
                return "FileAttributes(mode=" + this.mode + ", lastModifiedTime=" + this.lastModifiedTime + ", size=" + this.size + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.mode);
                result2 = result2 * 31 + this.lastModifiedTime.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.size);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileAttributes)) {
                    return false;
                }
                FileAttributes fileAttributes = (FileAttributes)other;
                if (this.mode != fileAttributes.mode) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.lastModifiedTime, (Object)fileAttributes.lastModifiedTime)) {
                    return false;
                }
                return this.size == fileAttributes.size;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$ManifestFileVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator;)V", "visitFile", "Ljava/nio/file/FileVisitResult;", "file", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFileFailed", "exc", "Ljava/io/IOException;", "preVisitDirectory", "dir", "intellij.remoteDev.util"})
        public final class ManifestFileVisitor
        extends SimpleFileVisitor<Path> {
            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Decompressor.Entry.Type type;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!((Boolean)ManifestGenerator.this.includeInManifest.invoke((Object)file)).booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                if (Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)FileManifestUtil.ManifestFileName)) {
                    return FileVisitResult.CONTINUE;
                }
                String name = StringsKt.replace$default((String)((Object)PathsKt.relativeTo((Path)file, (Path)ManifestGenerator.this.targetDir)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                if (Files.isSymbolicLink(file)) {
                    type = Decompressor.Entry.Type.SYMLINK;
                } else {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        type = Decompressor.Entry.Type.FILE;
                    } else {
                        throw new IllegalStateException(("Unknown file for " + ((Object)file.toAbsolutePath()).toString()).toString());
                    }
                }
                Decompressor.Entry.Type type2 = type;
                FileAttributes attributes = ManifestGenerator.this.readAttributesNoFollowLinks(file);
                ManifestGenerator.this.addManifestEntry(name, type2, attributes.getMode(), attributes.getSize(), attributes.getLastModifiedTime());
                return FileVisitResult.CONTINUE;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            @NotNull
            public FileVisitResult visitFileFailed(@Nullable Path file, @Nullable IOException exc) {
                block6: {
                    if (!(exc instanceof NoSuchFileException) || file == null) break block6;
                    try {
                        if (!FileManifestUtil.access$isSymlink(FileManifestUtil.INSTANCE, file)) ** GOTO lbl-1000
                        v0 = new LinkOption[]{};
                        if (!Files.exists(file, Arrays.copyOf(v0, v0.length))) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = isBrokenSymlink = false;
                        }
                        if (isBrokenSymlink) {
                            var4_5 = file;
                            var5_6 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                            if (Files.isDirectory(var4_5, Arrays.copyOf(var5_6, var5_6.length))) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                    }
                    catch (Throwable var3_4) {
                        // empty catch block
                    }
                }
                v2 = super.visitFileFailed(file, exc);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"visitFileFailed(...)");
                return v2;
            }

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @Nullable BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (Intrinsics.areEqual((Object)dir, (Object)ManifestGenerator.this.targetDir)) {
                    return FileVisitResult.CONTINUE;
                }
                if (((Boolean)ManifestGenerator.this.includeInManifest.invoke((Object)dir)).booleanValue()) {
                    String name = StringsKt.replace$default((String)((Object)PathsKt.relativeTo((Path)dir, (Path)ManifestGenerator.this.targetDir)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null) + "/";
                    Decompressor.Entry.Type type = Decompressor.Entry.Type.DIR;
                    FileAttributes attributes = ManifestGenerator.this.readAttributesNoFollowLinks(dir);
                    ManifestGenerator.this.addManifestEntry(name, type, attributes.getMode(), attributes.getSize(), attributes.getLastModifiedTime());
                }
                return INSTANCE.isSymlink(dir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Decompressor.Entry.Type.values().length];
                try {
                    nArray[Decompressor.Entry.Type.FILE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Decompressor.Entry.Type.SYMLINK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Decompressor.Entry.Type.DIR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

