/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Cursor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeErrorsIcon
extends JLabel {
    private static final int TIMEOUT = (int)TimeUnit.SECONDS.toMillis(Registry.intValue((String)"ea.indicator.blinking.timeout", (int)-1));
    private final boolean myEnableBlink;
    @Nullable
    private final MergingUpdateQueue myBlinkTimeoutQueue;

    IdeErrorsIcon(boolean canBlink) {
        this.myEnableBlink = canBlink && TIMEOUT != 0;
        this.myBlinkTimeoutQueue = this.myEnableBlink && TIMEOUT > 0 ? new MergingUpdateQueue("ide-error-icon-blink-timeout", TIMEOUT, true, null).setRestartTimerOnAdd(true) : null;
    }

    @NotNull
    private static Icon getUnreadIcon() {
        Icon icon2 = ApplicationInfo.getInstance().isEAP() ? AllIcons.Ide.FatalError : AllIcons.Ide.FatalErrorRead;
        if (icon2 == null) {
            IdeErrorsIcon.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    void setState(@NotNull MessagePool.State state2) {
        Icon myUnreadIcon;
        if (state2 == null) {
            IdeErrorsIcon.$$$reportNull$$$0(1);
        }
        Icon icon2 = myUnreadIcon = this.myEnableBlink ? new AnimatedIcon.Blinking(AllIcons.Ide.FatalError) : IdeErrorsIcon.getUnreadIcon();
        if (state2 != MessagePool.State.NoErrors) {
            this.setIcon(state2 == MessagePool.State.ReadErrors ? AllIcons.Ide.FatalErrorRead : myUnreadIcon);
            this.setToolTipText(DiagnosticBundle.message("error.notification.tooltip", new Object[0]));
            this.getAccessibleContext().setAccessibleDescription(StringUtil.removeHtmlTags((String)DiagnosticBundle.message("error.notification.tooltip", new Object[0])));
            if (!this.myEnableBlink) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            this.setIcon(EmptyIcon.ICON_16);
            this.setToolTipText(null);
            if (!this.myEnableBlink) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.myBlinkTimeoutQueue != null) {
            if (state2 == MessagePool.State.UnreadErrors) {
                this.myBlinkTimeoutQueue.queue(new Update(this.myBlinkTimeoutQueue){

                    public void run() {
                        IdeErrorsIcon.this.setIcon(AllIcons.Ide.FatalError);
                    }
                });
            } else {
                this.myBlinkTimeoutQueue.cancelAllUpdates();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeErrorsIcon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnreadIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeErrorsIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

