/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.AboutPopupDescriptionProvider;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.platform.buildData.productInfo.CustomProperty;
import com.intellij.platform.ide.productInfo.IdeProductInfo;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.JBR;
import com.jetbrains.Vulkan;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AboutDialog
extends DialogWrapper {
    private static final ExtensionPointName<AboutPopupDescriptionProvider> EP_NAME = new ExtensionPointName("com.intellij.aboutPopupDescriptionProvider");
    private static final String THIRD_PARTY_LIBRARIES_FILE = "license/third-party-libraries.html";
    private final List<String> myInfo = new ArrayList<String>();

    public AboutDialog(@Nullable Project project2) {
        super(project2, false);
        String appName = AboutDialog.getFullNameForAboutDialog();
        this.setResizable(false);
        this.setTitle(IdeBundle.message((String)"about.popup.about.app", (Object[])new Object[]{appName}));
        this.setShouldUseWriteIntentReadAction(false);
        this.init();
    }

    protected JComponent createSouthPanel() {
        JComponent result2 = super.createSouthPanel();
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AboutDialog.this.copyAboutInfoToClipboard();
                AboutDialog.this.close(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/AboutDialog$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"meta C", "control C"}), result2, this.getDisposable());
        return result2;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Icon appIcon = AppUIUtil.loadApplicationIcon(ScaleContext.create(), 60);
        Box box = this.getText();
        JLabel icon2 = new JLabel(appIcon);
        icon2.setVerticalAlignment(1);
        icon2.setBorder((Border)JBUI.Borders.empty((int)20, (int)12, (int)0, (int)24));
        box.setBorder((Border)JBUI.Borders.empty((int)20, (int)0, (int)0, (int)20));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToLeft((Component)icon2).addToCenter((Component)box);
        if (borderLayoutPanel == null) {
            AboutDialog.$$$reportNull$$$0(0);
        }
        return borderLayoutPanel;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DialogWrapper.OkAction(){
            {
                this.putValue("Name", IdeBundle.message((String)"button.copy.and.close", (Object[])new Object[0]));
                this.putValue("ShortDescription", IdeBundle.message((String)"description.copy.text.to.clipboard", (Object[])new Object[0]));
            }

            protected void doAction(ActionEvent e) {
                AboutDialog.this.copyAboutInfoToClipboard();
                AboutDialog.this.close(0);
            }
        };
        this.myCancelAction.putValue("Name", IdeBundle.message((String)"action.close", (Object[])new Object[0]));
    }

    private void copyAboutInfoToClipboard() {
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.getExtendedAboutText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private Box getText() {
        CustomProperty revision;
        final JBBox box = JBBox.createVerticalBox();
        ArrayList<Object> lines = new ArrayList<Object>();
        final ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        @NlsSafe Object appName = appInfo.getFullApplicationName();
        String edition = ApplicationNamesInfo.getInstance().getEditionName();
        if (edition != null) {
            appName = (String)appName + " (" + edition + ")";
        }
        box.add((Component)AboutDialog.label((String)appName, JBFont.h3().asBold()));
        box.add(Box.createVerticalStrut(10));
        this.myInfo.add((String)appName);
        @NotNull Pair<String, String> result2 = AboutDialog.getBuildInfo((ApplicationInfo)appInfo);
        lines.add((String)result2.first);
        this.myInfo.add((String)result2.second);
        @Nullable Pair<String, String> branchInfo = AboutDialog.getBuildBranchInfo((ApplicationInfo)appInfo);
        if (branchInfo != null) {
            lines.add((String)branchInfo.first);
            this.myInfo.add((String)branchInfo.second);
        }
        if ((revision = (CustomProperty)ContainerUtil.find(IdeProductInfo.getInstance().getCurrentProductInfo().getCustomProperties(), o -> "source.git.revision".equals(o.getKey()))) != null) {
            if (branchInfo != null) {
                lines.add(IdeBundle.message((String)"about.box.build.revision", (Object[])new Object[]{revision.getValue()}));
            }
            this.myInfo.add("Source revision: " + revision.getValue());
        }
        lines.add("");
        LicensingFacade la = LicensingFacade.getInstance();
        if (la != null) {
            String licensedTo = la.getLicensedToMessage();
            if (licensedTo != null) {
                lines.add(licensedTo);
                this.myInfo.add(licensedTo);
            }
            lines.addAll(la.getLicenseRestrictionsMessages());
            this.myInfo.addAll(la.getLicenseRestrictionsMessages());
        }
        lines.add("");
        Properties properties = System.getProperties();
        String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        String arch = properties.getProperty("os.arch", "");
        Object jcefSuffix = AboutDialog.getJcefVersion();
        if (!((String)jcefSuffix).isEmpty()) {
            jcefSuffix = " (" + (String)jcefSuffix + ")";
        }
        String jreInfo = IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch}) + (String)jcefSuffix;
        lines.add(jreInfo);
        this.myInfo.add(MessageFormat.format("Runtime version: {0} {1}", javaVersion, arch) + (String)jcefSuffix);
        String vmVersion = properties.getProperty("java.vm.name", "unknown");
        String vmVendor = properties.getProperty("java.vendor", "unknown");
        String vmVendorInfo = IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor});
        lines.add(vmVendorInfo);
        lines.add("");
        this.myInfo.add(MessageFormat.format("VM: {0} by {1}", vmVersion, vmVendor));
        for (AboutPopupDescriptionProvider aboutInfoProvider : EP_NAME.getExtensionList()) {
            String description = aboutInfoProvider.getDescription();
            if (description == null) continue;
            lines.add(description);
            lines.add("");
        }
        @NlsSafe String text2 = String.join((CharSequence)"<p>", lines);
        box.add((Component)AboutDialog.label(text2, AboutDialog.getDefaultTextFont()));
        AboutDialog.addEmptyLine((Box)box);
        HyperlinkLabel openSourceSoftware = AboutDialog.hyperlinkLabel(IdeBundle.message((String)"about.box.powered.by", (Object[])new Object[0]));
        openSourceSoftware.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(this){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                AboutDialog.showOssInfo((JComponent)box);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/AboutDialog$3", "hyperlinkActivated"));
            }
        });
        box.add((Component)openSourceSoftware);
        String year = Integer.toString(LocalDate.now().getYear());
        HyperlinkLabel copyright = AboutDialog.hyperlinkLabel(IdeBundle.message((String)"about.box.copyright", (Object[])new Object[]{appInfo.getCopyrightStart(), year, appInfo.getCompanyName()}));
        copyright.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(this){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BrowserUtil.browse((String)appInfo.getCompanyURL());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/AboutDialog$4", "hyperlinkActivated"));
            }
        });
        box.add((Component)copyright);
        AboutDialog.addEmptyLine((Box)box);
        JBBox jBBox = box;
        if (jBBox == null) {
            AboutDialog.$$$reportNull$$$0(1);
        }
        return jBBox;
    }

    @NotNull
    public static Pair<String, String> getBuildInfo(@NotNull ApplicationInfo appInfo) {
        if (appInfo == null) {
            AboutDialog.$$$reportNull$$$0(2);
        }
        Object buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
        Object buildInfoNonLocalized = MessageFormat.format("Build #{0}", appInfo.getBuild().asString());
        Date buildDate = appInfo.getBuildDate().getTime();
        String formattedBuildDate = DateFormat.getDateInstance(1, Locale.US).format(buildDate);
        if (AppMode.isRunningFromDevBuild()) {
            buildInfo = (String)buildInfo + IdeBundle.message((String)"about.box.build.date.omitted.in.dev.build.mode", (Object[])new Object[0]);
            buildInfoNonLocalized = (String)buildInfoNonLocalized + ", build date omitted in Dev build mode";
        } else if (appInfo.getBuild().isSnapshot()) {
            String buildTime = new SimpleDateFormat("HH:mm").format(buildDate);
            buildInfo = (String)buildInfo + IdeBundle.message((String)"about.box.build.date.time", (Object[])new Object[]{NlsMessages.formatDateLong((Date)buildDate), buildTime});
            buildInfoNonLocalized = (String)buildInfoNonLocalized + MessageFormat.format(", built on {0} at {1}", formattedBuildDate, buildTime);
        } else {
            buildInfo = (String)buildInfo + IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{NlsMessages.formatDateLong((Date)buildDate)});
            buildInfoNonLocalized = (String)buildInfoNonLocalized + MessageFormat.format(", built on {0}", formattedBuildDate);
        }
        Pair pair = Pair.create((Object)buildInfo, (Object)buildInfoNonLocalized);
        if (pair == null) {
            AboutDialog.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    private static Pair<String, String> getBuildBranchInfo(@NotNull ApplicationInfo appInfo) {
        String buildBranch;
        if (appInfo == null) {
            AboutDialog.$$$reportNull$$$0(4);
        }
        if ((buildBranch = appInfo.getBuildBranchName()) != null) {
            return Pair.create((Object)IdeBundle.message((String)"about.box.build.from.branch", (Object[])new Object[]{buildBranch}), (Object)("Built from the branch: " + buildBranch));
        }
        return null;
    }

    private static JBFont getDefaultTextFont() {
        return JBFont.medium();
    }

    private static void addEmptyLine(@NotNull Box box) {
        if (box == null) {
            AboutDialog.$$$reportNull$$$0(5);
        }
        box.add(Box.createVerticalStrut(18));
    }

    @NotNull
    private static JLabel label(@NlsContexts.Label @NotNull String text2, JBFont font) {
        if (text2 == null) {
            AboutDialog.$$$reportNull$$$0(6);
        }
        JBLabel label2 = new JBLabel(text2).withFont(font);
        label2.setCopyable(true);
        JBLabel jBLabel = label2;
        if (jBLabel == null) {
            AboutDialog.$$$reportNull$$$0(7);
        }
        return jBLabel;
    }

    @NotNull
    private static HyperlinkLabel hyperlinkLabel(@NlsContexts.LinkLabel @NotNull String textWithLink) {
        if (textWithLink == null) {
            AboutDialog.$$$reportNull$$$0(8);
        }
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setTextWithHyperlink(textWithLink);
        hyperlinkLabel.setFont((Font)AboutDialog.getDefaultTextFont());
        HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
        if (hyperlinkLabel2 == null) {
            AboutDialog.$$$reportNull$$$0(9);
        }
        return hyperlinkLabel2;
    }

    @NotNull
    public String getExtendedAboutText() {
        IdeaPluginDescriptor kotlinPlugin;
        List<IdeaPluginDescriptor> extraPlugins;
        List<RegistryValue> changedValues;
        StringBuilder text2 = new StringBuilder();
        this.myInfo.forEach(s -> text2.append((String)s).append('\n'));
        text2.append("Toolkit: ").append(Toolkit.getDefaultToolkit().getClass().getName()).append("\n");
        text2.append(OS.CURRENT.name()).append(' ').append(OS.CURRENT.version()).append('\n');
        for (Vulkan.Device[] aboutInfoProvider : EP_NAME.getExtensionList()) {
            String description = aboutInfoProvider.getExtendedDescription();
            if (description == null) continue;
            text2.append(description).append('\n');
        }
        String garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).collect(Collectors.joining(", "));
        text2.append("GC: ").append(garbageCollectors).append('\n');
        text2.append("Memory: ").append(Runtime.getRuntime().maxMemory() / 0x100000L).append("M\n");
        text2.append("Cores: ").append(Runtime.getRuntime().availableProcessors()).append('\n');
        if (UIUtil.isMetalRendering()) {
            text2.append("Metal Rendering is ON\n");
        }
        if (JBR.isVulkanSupported()) {
            text2.append("Vulkan Rendering is ON:\n");
            text2.append("  Presentation is ").append(JBR.getVulkan().isPresentationEnabled() ? "ON" : "OFF").append("\n");
            for (Vulkan.Device device : JBR.getVulkan().getDevices()) {
                text2.append("  ").append(device.getName()).append(" (").append(device.getTypeString()).append("), caps=0x").append(Integer.toHexString(device.getCapabilities())).append("\n");
            }
        }
        if (!(changedValues = Registry.getAll().stream().filter(RegistryValue::isChangedFromDefault).toList()).isEmpty()) {
            text2.append("Registry:\n");
            changedValues.forEach(v -> text2.append("  ").append(v.getKey()).append('=').append(v.asString()).append('\n'));
        }
        if (!(extraPlugins = PluginManagerCore.getLoadedPlugins().stream().filter(p -> !p.isBundled()).toList()).isEmpty()) {
            text2.append("Non-Bundled Plugins:\n");
            extraPlugins.forEach(p -> text2.append("  ").append(p.getPluginId().getIdString()).append(" (").append(p.getVersion()).append(")\n"));
        }
        if (PlatformUtils.isIntelliJ() && (kotlinPlugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"))) != null) {
            text2.append("Kotlin: ").append(kotlinPlugin.getVersion()).append('\n');
        }
        if (SystemInfo.isUnix && !SystemInfo.isMac) {
            text2.append("Current Desktop: ").append(Objects.requireNonNullElse(System.getenv("XDG_CURRENT_DESKTOP"), "Undefined")).append('\n');
        }
        String string = text2.toString();
        if (string == null) {
            AboutDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void showOssInfo(JComponent component2) {
        String licenseText;
        try {
            String title2 = IdeBundle.message((String)"progress.third.party.software", (Object[])new Object[0]);
            licenseText = (String)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<String, IOException>(null, component2, title2, true){

                protected String compute(@NotNull ProgressIndicator indicator2) throws IOException {
                    if (indicator2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return (String)DiskQueryRelay.compute(() -> {
                        String content2 = Files.readString(Path.of(PathManager.getHomePath(), AboutDialog.THIRD_PARTY_LIBRARIES_FILE));
                        Matcher matcher = Pattern.compile("(\\d+)px").matcher(content2);
                        StringBuilder sb = new StringBuilder();
                        while (matcher.find()) {
                            matcher.appendReplacement(sb, JBUIScale.scale((int)Integer.parseInt(matcher.group(1))) + "px");
                        }
                        matcher.appendTail(sb);
                        content2 = sb.toString();
                        if (StartupUiUtil.INSTANCE.isDarkTheme()) {
                            content2 = content2.replace("779dbd", "5676a0");
                        }
                        return content2;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/AboutDialog$5", "compute"));
                }
            });
        }
        catch (IOException e) {
            Logger.getInstance(AboutDialog.class).error((Throwable)e);
            return;
        }
        DialogWrapper dialog2 = new DialogWrapper(true){
            {
                super(arg0);
                this.init();
                this.setAutoAdjustable(false);
                this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                viewer.setFocusable(true);
                viewer.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
                viewer.setText(licenseText);
                StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, \"Helvetica Neue\", Helvetica, Arial, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUIScale.scaleFontSize((float)14.0f) + "pt;}");
                viewer.setCaretPosition(0);
                viewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                JBScrollPane scrollPane = new JBScrollPane((Component)viewer, 20, 31);
                JPanel centerPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)5), JBUIScale.scale((int)5)));
                centerPanel.add((Component)scrollPane, "Center");
                JPanel jPanel = centerPanel;
                if (jPanel == null) {
                    6.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            protected Action @NotNull [] createActions() {
                Action[] actionArray = new Action[]{this.getOKAction()};
                if (actionArray == null) {
                    6.$$$reportNull$$$0(1);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/actions/AboutDialog$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCenterPanel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        dialog2.setTitle(IdeBundle.message((String)"dialog.title.third.party.software", (Object[])new Object[]{AboutDialog.getFullNameForAboutDialog(), ApplicationInfo.getInstance().getFullVersion()}));
        dialog2.setSize(JBUIScale.scale((int)750), JBUIScale.scale((int)650));
        dialog2.show();
    }

    @NotNull
    private static String getFullNameForAboutDialog() {
        if (!PlatformUtils.isJetBrainsClient()) {
            String string = ApplicationNamesInfo.getInstance().getFullProductName();
            if (string == null) {
                AboutDialog.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = IdeBundle.message((String)"dialog.message.jetbrains.client.for.ide", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (string == null) {
            AboutDialog.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getJcefVersion() {
        if (JBCefApp.isSupported()) {
            String string;
            try {
                JCefVersionDetails version = JCefAppConfig.getVersionDetails();
                string = IdeBundle.message((String)"about.box.jcef", (Object[])new Object[]{version.cefVersion.major, version.cefVersion.api, version.cefVersion.patch});
            }
            catch (JCefVersionDetails.VersionUnavailableException versionUnavailableException) {
                // empty catch block
            }
            if (string == null) {
                AboutDialog.$$$reportNull$$$0(13);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/AboutDialog";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "box";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/AboutDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "label";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "hyperlinkLabel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedAboutText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullNameForAboutDialog";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJcefVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuildInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildBranchInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "label";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hyperlinkLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

