/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="web-browsers.xml", roamingType=RoamingType.DISABLED)})
public final class WebBrowserManager
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WebBrowserManager.class);
    private static final UUID PREDEFINED_CHROME_ID = UUID.fromString("98CA6316-2F89-46D9-A9E5-FA9E2B0625B3");
    @ApiStatus.Internal
    public static final UUID PREDEFINED_FIREFOX_ID = UUID.fromString("A7BB68E0-33C0-4D6F-A81A-AAC1FDB870C8");
    private static final UUID PREDEFINED_SAFARI_ID = UUID.fromString("E5120D43-2C3F-47EF-9F26-65E539E05186");
    private static final UUID PREDEFINED_OPERA_ID = UUID.fromString("53E2F627-B1A7-4DFA-BFA7-5B83CC034776");
    private static final UUID PREDEFINED_EXPLORER_ID = UUID.fromString("16BF23D4-93E0-4FFC-BFD6-CB13575177B0");
    private static final UUID PREDEFINED_OLD_EDGE_ID = UUID.fromString("B2A9DCA7-9D0B-4E1E-98A8-AFB19C1328D2");
    private static final UUID PREDEFINED_EDGE_ID = UUID.fromString("37cae5b9-e8b2-4949-9172-aafa37fbc09c");
    private static final UUID[] PREDEFINED_BROWSER_IDS = new UUID[]{PREDEFINED_CHROME_ID, PREDEFINED_FIREFOX_ID, PREDEFINED_SAFARI_ID, PREDEFINED_OPERA_ID, PREDEFINED_EXPLORER_ID, PREDEFINED_EDGE_ID};
    public static final ReloadMode BROWSER_RELOAD_MODE_DEFAULT = ReloadMode.RELOAD_ON_SAVE;
    public static final ReloadMode PREVIEW_RELOAD_MODE_DEFAULT = ReloadMode.RELOAD_ON_SAVE;
    private List<ConfigurableWebBrowser> browsers;
    private boolean showBrowserHover = true;
    private boolean showBrowserHoverXml = false;
    DefaultBrowserPolicy defaultBrowserPolicy = DefaultBrowserPolicy.SYSTEM;
    ReloadMode webServerReloadMode = BROWSER_RELOAD_MODE_DEFAULT;
    ReloadMode webPreviewReloadMode = PREVIEW_RELOAD_MODE_DEFAULT;

    @NotNull
    private static String getEdgeExecutionPath() {
        if (SystemInfo.isWindows) {
            return "msedge";
        }
        if (SystemInfo.isMac) {
            return "Microsoft Edge";
        }
        return "microsoft-edge";
    }

    private static List<ConfigurableWebBrowser> getPredefinedBrowsers() {
        return List.of(new ConfigurableWebBrowser(PREDEFINED_CHROME_ID, BrowserFamily.CHROME), new ConfigurableWebBrowser(PREDEFINED_FIREFOX_ID, BrowserFamily.FIREFOX), new ConfigurableWebBrowser(PREDEFINED_SAFARI_ID, BrowserFamily.SAFARI, BrowserFamily.SAFARI.getName(), BrowserFamily.SAFARI.getExecutionPath(), SystemInfo.isMac, BrowserFamily.SAFARI.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_OPERA_ID, BrowserFamily.CHROME, "Opera", SystemInfo.isMac ? "Opera" : "opera", false, null), new ConfigurableWebBrowser(PREDEFINED_EXPLORER_ID, BrowserFamily.EXPLORER, BrowserFamily.EXPLORER.getName(), BrowserFamily.EXPLORER.getExecutionPath(), false, BrowserFamily.EXPLORER.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_EDGE_ID, BrowserFamily.CHROME, "Edge", WebBrowserManager.getEdgeExecutionPath(), SystemInfo.isWindows, BrowserFamily.CHROME.createBrowserSpecificSettings()));
    }

    public WebBrowserManager() {
        this.browsers = new ArrayList<ConfigurableWebBrowser>(WebBrowserManager.getPredefinedBrowsers());
    }

    public static WebBrowserManager getInstance() {
        return (WebBrowserManager)((Object)ApplicationManager.getApplication().getService(WebBrowserManager.class));
    }

    public static boolean isYandexBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(0);
        }
        return browser.getFamily().equals((Object)BrowserFamily.CHROME) && WebBrowserManager.checkNameAndPath("Yandex", browser);
    }

    public static boolean isEdge(@NotNull WebBrowser browser) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(1);
        }
        return browser.getFamily() == BrowserFamily.CHROME && (browser.getId().equals(PREDEFINED_EDGE_ID) || WebBrowserManager.checkNameAndPath(WebBrowserManager.getEdgeExecutionPath(), browser) || WebBrowserManager.checkNameAndPath("MicrosoftEdge", browser));
    }

    public static boolean isOpera(@NotNull WebBrowser browser) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(2);
        }
        return WebBrowserManager.checkNameAndPath("Opera", browser);
    }

    static boolean checkNameAndPath(@NotNull String what, @NotNull WebBrowser browser) {
        if (what == null) {
            WebBrowserManager.$$$reportNull$$$0(3);
        }
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(4);
        }
        if (StringUtil.containsIgnoreCase((String)browser.getName(), (String)what)) {
            return true;
        }
        String path = browser.getPath();
        if (path != null) {
            String fileName = PathUtil.getFileName((String)path);
            if (StringUtil.containsIgnoreCase((String)fileName, (String)what)) {
                return true;
            }
            String parentPath = PathUtil.getParentPath((String)path);
            String parentPathName = PathUtil.getFileName((String)parentPath);
            if ("bin".equals(parentPathName)) {
                parentPath = PathUtil.getParentPath((String)parentPath);
                parentPathName = PathUtil.getFileName((String)parentPath);
            }
            return StringUtil.containsIgnoreCase((String)parentPathName, (String)what);
        }
        return false;
    }

    boolean isPredefinedBrowser(@NotNull ConfigurableWebBrowser browser) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(5);
        }
        UUID id2 = browser.getId();
        return ArrayUtil.contains((Object)id2, (Object[])PREDEFINED_BROWSER_IDS);
    }

    @NotNull
    public DefaultBrowserPolicy getDefaultBrowserPolicy() {
        DefaultBrowserPolicy defaultBrowserPolicy = this.defaultBrowserPolicy;
        if (defaultBrowserPolicy == null) {
            WebBrowserManager.$$$reportNull$$$0(6);
        }
        return defaultBrowserPolicy;
    }

    @NotNull
    public ReloadMode getWebServerReloadMode() {
        ReloadMode reloadMode = this.webServerReloadMode;
        if (reloadMode == null) {
            WebBrowserManager.$$$reportNull$$$0(7);
        }
        return reloadMode;
    }

    @NotNull
    public ReloadMode getWebPreviewReloadMode() {
        ReloadMode reloadMode = this.webPreviewReloadMode;
        if (reloadMode == null) {
            WebBrowserManager.$$$reportNull$$$0(8);
        }
        return reloadMode;
    }

    public Element getState() {
        Element state2 = new Element("state");
        if (this.defaultBrowserPolicy != DefaultBrowserPolicy.SYSTEM) {
            state2.setAttribute("default", StringUtil.toLowerCase((String)this.defaultBrowserPolicy.name()));
        }
        if (this.webServerReloadMode != BROWSER_RELOAD_MODE_DEFAULT) {
            state2.setAttribute("serverReloadMode", StringUtil.toLowerCase((String)this.webServerReloadMode.name()));
        }
        if (this.webPreviewReloadMode != PREVIEW_RELOAD_MODE_DEFAULT) {
            state2.setAttribute("previewReloadMode", StringUtil.toLowerCase((String)this.webPreviewReloadMode.name()));
        }
        if (!this.showBrowserHover) {
            state2.setAttribute("showHover", "false");
        }
        if (this.showBrowserHoverXml) {
            state2.setAttribute("showHoverXml", "true");
        }
        if (!this.browsers.equals(WebBrowserManager.getPredefinedBrowsers())) {
            for (ConfigurableWebBrowser browser : this.browsers) {
                BrowserSpecificSettings specificSettings;
                Element entry = new Element("browser");
                entry.setAttribute("id", browser.getId().toString());
                entry.setAttribute("name", browser.getName());
                entry.setAttribute("family", browser.getFamily().name());
                String path = browser.getPath();
                if (path != null && !path.equals(browser.getFamily().getExecutionPath())) {
                    entry.setAttribute("path", path);
                }
                if (!browser.isActive()) {
                    entry.setAttribute("active", "false");
                }
                if ((specificSettings = browser.getSpecificSettings()) != null) {
                    Element settingsElement = new Element("settings");
                    XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                    if (!JDOMUtil.isEmpty((Element)settingsElement)) {
                        entry.addContent(settingsElement);
                    }
                }
                state2.addContent(entry);
            }
        }
        return state2;
    }

    @Nullable
    private static BrowserFamily readFamily(String value) {
        try {
            return "OPERA".equals(value) ? BrowserFamily.CHROME : BrowserFamily.valueOf((String)value);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            for (BrowserFamily family : BrowserFamily.values()) {
                if (!family.getName().equalsIgnoreCase(value)) continue;
                return family;
            }
            return null;
        }
    }

    @Nullable
    private static UUID readId(String value, @NotNull BrowserFamily family, @NotNull List<ConfigurableWebBrowser> existingBrowsers) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(9);
        }
        if (existingBrowsers == null) {
            WebBrowserManager.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)value)) {
            UUID id2;
            switch (family) {
                case CHROME: {
                    id2 = PREDEFINED_CHROME_ID;
                    break;
                }
                case EXPLORER: {
                    id2 = PREDEFINED_EXPLORER_ID;
                    break;
                }
                case FIREFOX: {
                    id2 = PREDEFINED_FIREFOX_ID;
                    break;
                }
                case SAFARI: {
                    id2 = PREDEFINED_SAFARI_ID;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (ConfigurableWebBrowser browser : existingBrowsers) {
                if (browser.getId() != id2) continue;
                return null;
            }
            return id2;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            WebBrowserManager.$$$reportNull$$$0(11);
        }
        try {
            String previewReload;
            Object serverReload;
            String defaultValue = element.getAttributeValue("default");
            if (!StringUtil.isEmpty((String)defaultValue)) {
                this.defaultBrowserPolicy = DefaultBrowserPolicy.valueOf(StringUtil.toUpperCase((String)defaultValue));
            }
            if (!StringUtil.isEmpty((String)(serverReload = element.getAttributeValue("serverReloadMode")))) {
                this.webServerReloadMode = ReloadMode.valueOf((String)StringUtil.toUpperCase((String)serverReload));
            }
            if (!StringUtil.isEmpty((String)(previewReload = element.getAttributeValue("previewReloadMode")))) {
                this.webPreviewReloadMode = ReloadMode.valueOf((String)StringUtil.toUpperCase((String)previewReload));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Throwable)e);
        }
        this.showBrowserHover = !"false".equals(element.getAttributeValue("showHover"));
        this.showBrowserHoverXml = "true".equals(element.getAttributeValue("showHoverXml"));
        ArrayList<ConfigurableWebBrowser> list2 = new ArrayList<ConfigurableWebBrowser>();
        for (Element child : element.getChildren("browser")) {
            UUID id2;
            BrowserFamily family = WebBrowserManager.readFamily(child.getAttributeValue("family"));
            if (family == null || (id2 = WebBrowserManager.readId(child.getAttributeValue("id"), family, list2)) == null || PREDEFINED_OLD_EDGE_ID.equals(id2)) continue;
            Element settingsElement = child.getChild("settings");
            BrowserSpecificSettings specificSettings = family.createBrowserSpecificSettings();
            if (specificSettings != null && settingsElement != null) {
                try {
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String activeValue = child.getAttributeValue("active");
            String path = StringUtil.nullize((String)child.getAttributeValue("path"), (boolean)true);
            if (path == null) {
                path = family.getExecutionPath();
            }
            list2.add(new ConfigurableWebBrowser(id2, family, StringUtil.notNullize((String)child.getAttributeValue("name"), (String)family.getName()), path, activeValue == null || Boolean.parseBoolean(activeValue), specificSettings));
        }
        Map idToBrowser = null;
        int n = list2.size();
        block5: for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            for (int i2 = 0; i2 < n; ++i2) {
                if (((ConfigurableWebBrowser)((Object)list2.get(i2))).getId().equals(predefinedBrowserId)) continue block5;
            }
            if (idToBrowser == null) {
                idToBrowser = ContainerUtil.newMapFromValues(WebBrowserManager.getPredefinedBrowsers().iterator(), it -> it.getId());
            }
            list2.add((ConfigurableWebBrowser)((Object)idToBrowser.get(predefinedBrowserId)));
        }
        this.setList(list2);
    }

    @NotNull
    public List<WebBrowser> getBrowsers() {
        List<WebBrowser> list2 = Collections.unmodifiableList(this.browsers);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    List<ConfigurableWebBrowser> getList() {
        List<ConfigurableWebBrowser> list2 = this.browsers;
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(13);
        }
        return list2;
    }

    void setList(@NotNull List<ConfigurableWebBrowser> value) {
        if (value == null) {
            WebBrowserManager.$$$reportNull$$$0(14);
        }
        this.browsers = value;
        this.incModificationCount();
    }

    @NotNull
    public List<WebBrowser> getActiveBrowsers() {
        List<WebBrowser> list2 = this.getBrowsers((Condition<? super WebBrowser>)Conditions.alwaysTrue(), true);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(16);
        }
        List<WebBrowser> list2 = this.getBrowsers(condition, true);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition, boolean onlyActive) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(18);
        }
        SmartList result2 = new SmartList();
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (onlyActive && !browser.isActive() || !condition.value((Object)browser)) continue;
            result2.add(browser);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            WebBrowserManager.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    public void setBrowserSpecificSettings(@NotNull WebBrowser browser, @NotNull BrowserSpecificSettings specificSettings) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(20);
        }
        if (specificSettings == null) {
            WebBrowserManager.$$$reportNull$$$0(21);
        }
        ((ConfigurableWebBrowser)browser).setSpecificSettings(specificSettings);
    }

    public void setBrowserPath(@NotNull WebBrowser browser, @Nullable String path, boolean isActive) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(22);
        }
        ((ConfigurableWebBrowser)browser).setPath(path);
        ((ConfigurableWebBrowser)browser).setActive(isActive);
        this.incModificationCount();
    }

    public WebBrowser addBrowser(@NotNull UUID id2, @NotNull BrowserFamily family, @NotNull String name2, @Nullable String path, boolean active, BrowserSpecificSettings specificSettings) {
        if (id2 == null) {
            WebBrowserManager.$$$reportNull$$$0(23);
        }
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(24);
        }
        if (name2 == null) {
            WebBrowserManager.$$$reportNull$$$0(25);
        }
        ConfigurableWebBrowser browser = new ConfigurableWebBrowser(id2, family, name2, path, active, specificSettings);
        this.browsers.add(browser);
        this.incModificationCount();
        return browser;
    }

    @Nullable
    private static UUID parseUuid(@NotNull String id2) {
        if (id2 == null) {
            WebBrowserManager.$$$reportNull$$$0(26);
        }
        if (id2.indexOf(45) == -1) {
            return null;
        }
        try {
            return UUID.fromString(id2);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public WebBrowser findBrowserById(@Nullable String idOrFamilyName) {
        if (Strings.isEmpty((String)idOrFamilyName)) {
            return null;
        }
        UUID id2 = WebBrowserManager.parseUuid(idOrFamilyName);
        if (id2 == null) {
            for (ConfigurableWebBrowser browser : this.browsers) {
                if (!browser.getFamily().name().equalsIgnoreCase(idOrFamilyName) && !browser.getFamily().getName().equalsIgnoreCase(idOrFamilyName)) continue;
                return browser;
            }
            return null;
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.getId().equals(id2)) continue;
            return browser;
        }
        return null;
    }

    @Nullable
    public WebBrowser getFirstBrowserOrNull(@NotNull BrowserFamily family) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(27);
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.isActive() || !family.equals((Object)browser.getFamily())) continue;
            return browser;
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!family.equals((Object)browser.getFamily())) continue;
            return browser;
        }
        return null;
    }

    @NotNull
    public WebBrowser getFirstBrowser(@NotNull BrowserFamily family) {
        WebBrowser result2;
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(28);
        }
        if ((result2 = this.getFirstBrowserOrNull(family)) == null) {
            throw new IllegalStateException("Must be at least one browser per family");
        }
        WebBrowser webBrowser = result2;
        if (webBrowser == null) {
            WebBrowserManager.$$$reportNull$$$0(29);
        }
        return webBrowser;
    }

    public boolean isActive(@NotNull WebBrowser browser) {
        if (browser == null) {
            WebBrowserManager.$$$reportNull$$$0(30);
        }
        return !(browser instanceof ConfigurableWebBrowser) || ((ConfigurableWebBrowser)browser).isActive();
    }

    @Nullable
    public WebBrowser getFirstActiveBrowser() {
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.isActive() || browser.getPath() == null) continue;
            return browser;
        }
        return null;
    }

    public void setShowBrowserHover(boolean showBrowserHover) {
        this.showBrowserHover = showBrowserHover;
    }

    public void setShowBrowserHoverXml(boolean showBrowserHover) {
        this.showBrowserHoverXml = showBrowserHover;
    }

    public boolean isShowBrowserHover() {
        return this.showBrowserHover;
    }

    public boolean isShowBrowserHoverXml() {
        return this.showBrowserHoverXml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 12, 13, 15, 17, 19, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 9: 
            case 24: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingBrowsers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificSettings";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBrowserPolicy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerReloadMode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebPreviewReloadMode";
                break;
            }
            case 12: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveBrowsers";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isYandexBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEdge";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOpera";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkNameAndPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedBrowser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 29: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setList";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBrowsers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserSpecificSettings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserPath";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addBrowser";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseUuid";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowserOrNull";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowser";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 12, 13, 15, 17, 19, 29 -> new IllegalStateException(string);
        };
    }
}

