/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;

final class AbstractButtonLayout {
    public final Rectangle iconRect;
    public final Rectangle textRect;
    private final AbstractButton button;
    private final Dimension size;
    private final boolean removeInsetsBeforeLayout;
    private final String text;
    private final FontMetrics fontMetrics;

    AbstractButtonLayout(@NotNull AbstractButton button2, @NotNull Dimension size2, boolean removeInsetsBeforeLayout, Icon defaultIcon) {
        if (button2 == null) {
            AbstractButtonLayout.$$$reportNull$$$0(0);
        }
        if (size2 == null) {
            AbstractButtonLayout.$$$reportNull$$$0(1);
        }
        this.iconRect = new Rectangle();
        this.textRect = new Rectangle();
        this.button = button2;
        this.size = size2;
        this.removeInsetsBeforeLayout = removeInsetsBeforeLayout;
        this.fontMetrics = button2.getFontMetrics(button2.getFont());
        Rectangle viewRect = new Rectangle(size2);
        if (removeInsetsBeforeLayout) {
            JBInsets.removeFrom((Rectangle)viewRect, (Insets)button2.getInsets());
        }
        this.text = SwingUtilities.layoutCompoundLabel(button2, this.fontMetrics, button2.getText(), defaultIcon, button2.getVerticalAlignment(), button2.getHorizontalAlignment(), button2.getVerticalTextPosition(), button2.getHorizontalTextPosition(), viewRect, this.iconRect, this.textRect, button2.getText() == null ? 0 : button2.getIconTextGap());
    }

    public void paint(Graphics g, Color disabledTextColor, int mnemonicIndex) {
        if (this.button.isOpaque()) {
            g.setColor(this.button.getBackground());
            g.fillRect(0, 0, this.size.width, this.size.height);
        }
        this.drawText(g, disabledTextColor, mnemonicIndex);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Rectangle iconRectResult;
        Insets insets = this.button.getInsets();
        if (this.removeInsetsBeforeLayout) {
            iconRectResult = this.iconRect.getBounds();
            JBInsets.addTo((Rectangle)iconRectResult, (Insets)insets);
        } else {
            iconRectResult = this.iconRect;
        }
        Rectangle textRectResult = this.textRect.getBounds();
        JBInsets.addTo((Rectangle)textRectResult, (Insets)insets);
        Rectangle rect = iconRectResult.union(textRectResult);
        return new Dimension(rect.width, rect.height);
    }

    public int getBaseline() {
        if (Strings.isEmpty((String)this.button.getText())) {
            return -1;
        }
        return this.getBaseline(this.textRect.y, this.textRect.width, this.textRect.height);
    }

    private int getBaseline(int y, int w, int h) {
        View view2 = (View)this.button.getClientProperty("html");
        if (view2 == null) {
            return y + this.fontMetrics.getAscent();
        }
        int baseline = BasicHTML.getHTMLBaseline(view2, w, h);
        return baseline < 0 ? baseline : y + baseline;
    }

    private void drawText(Graphics g, Color disabledTextColor, int mnemonicIndex) {
        if (this.text != null) {
            View v = (View)this.button.getClientProperty("html");
            if (v != null) {
                v.paint(g, this.textRect);
            } else {
                g.setColor(this.button.isEnabled() ? this.button.getForeground() : disabledTextColor);
                UIUtilities.drawStringUnderlineCharAt(this.button, g, this.text, mnemonicIndex, this.textRect.x, this.textRect.y + this.fontMetrics.getAscent());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "button";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "size";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/ui/laf/darcula/ui/AbstractButtonLayout";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

