/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaDisclosureButtonBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaDisclosureButtonListener;
import com.intellij.ui.components.DisclosureButton;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001c\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J,\u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0012\u0010$\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010&\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "uiComponent", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "getUiComponent", "()Ljavax/swing/JComponent;", "mouseHoverListener", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI$MouseHoverListener;", "componentHoverListener", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI$ComponentHoverListener;", "value", "", "isAdditionalActionsButtonHovered", "setAdditionalActionsButtonHovered", "(Z)V", "installDefaults", "", "b", "Ljavax/swing/AbstractButton;", "installListeners", "uninstallListeners", "createButtonListener", "Ljavax/swing/plaf/basic/BasicButtonListener;", "paint", "g", "Ljava/awt/Graphics;", "c", "paintIcon", "iconRect", "Ljava/awt/Rectangle;", "paintText", "textRect", "text", "", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "paintBackground", "Lcom/intellij/ui/components/DisclosureButton;", "getExtraIconsSize", "Companion", "MouseHoverListener", "ComponentHoverListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DarculaDisclosureButtonUI
extends BasicButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JComponent uiComponent;
    @NotNull
    private final MouseHoverListener mouseHoverListener;
    @NotNull
    private final ComponentHoverListener componentHoverListener;
    @ApiStatus.Internal
    private boolean isAdditionalActionsButtonHovered;

    public DarculaDisclosureButtonUI(@NotNull JComponent uiComponent) {
        Intrinsics.checkNotNullParameter((Object)uiComponent, (String)"uiComponent");
        this.uiComponent = uiComponent;
        this.mouseHoverListener = new MouseHoverListener();
        this.componentHoverListener = new ComponentHoverListener();
    }

    @NotNull
    public final JComponent getUiComponent() {
        return this.uiComponent;
    }

    private final void setAdditionalActionsButtonHovered(boolean value) {
        if (this.isAdditionalActionsButtonHovered != value) {
            this.isAdditionalActionsButtonHovered = value;
            this.uiComponent.repaint();
        }
    }

    @Override
    protected void installDefaults(@NotNull AbstractButton b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        super.installDefaults(b);
        b.setBorder(new DarculaDisclosureButtonBorder());
    }

    @Override
    protected void installListeners(@Nullable AbstractButton b) {
        super.installListeners(b);
        this.uiComponent.addComponentListener(this.componentHoverListener);
        this.uiComponent.addMouseListener(this.mouseHoverListener);
        this.uiComponent.addMouseMotionListener(this.mouseHoverListener);
    }

    @Override
    protected void uninstallListeners(@Nullable AbstractButton b) {
        super.uninstallListeners(b);
        this.uiComponent.removeComponentListener(this.componentHoverListener);
        this.uiComponent.removeMouseListener(this.mouseHoverListener);
        this.uiComponent.removeMouseMotionListener(this.mouseHoverListener);
    }

    @Override
    @NotNull
    protected BasicButtonListener createButtonListener(@NotNull AbstractButton b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new DarculaDisclosureButtonListener(b);
    }

    @Override
    public void paint(@Nullable Graphics g, @Nullable JComponent c) {
        block4: {
            Insets insets;
            block3: {
                if (!(c instanceof DisclosureButton) || g == null) {
                    super.paint(g, c);
                    return;
                }
                this.paintBackground(g, (DisclosureButton)c);
                super.paint(g, c);
                insets = ((DisclosureButton)c).getInsets();
                Rectangle actionBounds = Companion.getAdditionalActionsButtonBounds$intellij_platform_ide_impl((DisclosureButton)c);
                if (actionBounds == null) break block3;
                if (this.isAdditionalActionsButtonHovered) {
                    Graphics2D cfr_ignored_0 = (Graphics2D)g;
                    int arc = Companion.getAdditionalButtonArc$intellij_platform_ide_impl();
                    Color color = ((DisclosureButton)c).getPressedBackground();
                    if (color != null) {
                        ((Graphics2D)g).setColor(color);
                        ((Graphics2D)g).fillRoundRect(actionBounds.x, actionBounds.y, actionBounds.width, actionBounds.height, arc, arc);
                    }
                }
                Icon icon2 = Companion.additionalActionsIcon$intellij_platform_ide_impl(this.isAdditionalActionsButtonHovered);
                int iconX = actionBounds.x + (actionBounds.width - icon2.getIconWidth()) / 2;
                int iconY = actionBounds.y + (actionBounds.height - icon2.getIconHeight()) / 2;
                icon2.paintIcon(c, g, iconX, iconY);
                break block4;
            }
            Rectangle arrowIconRect = new Rectangle();
            Icon icon3 = ((DisclosureButton)c).getArrowIcon();
            if (icon3 == null) break block4;
            Icon it = icon3;
            boolean bl = false;
            arrowIconRect.x = ((DisclosureButton)c).getWidth() - insets.right - ((DisclosureButton)c).getRightMargin() - it.getIconWidth();
            arrowIconRect.y = (((DisclosureButton)c).getHeight() - it.getIconHeight()) / 2;
            arrowIconRect.width = it.getIconWidth();
            arrowIconRect.height = it.getIconHeight();
            it.paintIcon(c, g, arrowIconRect.x, arrowIconRect.y);
        }
    }

    @Override
    protected void paintIcon(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle iconRect) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)iconRect, (String)"iconRect");
        if (!(c instanceof DisclosureButton)) {
            super.paintIcon(g, c, iconRect);
            return;
        }
        iconRect.x += ((DisclosureButton)c).getLeftMargin();
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected void paintText(@NotNull Graphics g, @Nullable JComponent c, @NotNull Rectangle textRect, @Nullable String text2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)textRect, (String)"textRect");
            if (!(c instanceof DisclosureButton)) {
                super.paintText(g, c, textRect, text2);
                return;
            }
            textRect.x += ((DisclosureButton)c).getLeftMargin();
            textRect.width = ((DisclosureButton)c).getWidth() - textRect.x - this.getExtraIconsSize((DisclosureButton)((DisclosureButton)c)).width - ((DisclosureButton)c).getRightMargin();
            FontMetrics fm = ((DisclosureButton)c).getFontMetrics(((DisclosureButton)c).getFont());
            String clippedText = UIUtilities.clipStringIfNecessary(c, fm, text2, textRect.width);
            super.paintText(g, c, textRect, clippedText);
            Rectangle rightIconRect = new Rectangle();
            Icon icon2 = ((DisclosureButton)c).getRightIcon();
            if (icon2 == null) break block1;
            Icon it = icon2;
            boolean bl = false;
            int textWidth = fm.stringWidth(clippedText);
            Insets insets = ((DisclosureButton)c).getInsets();
            rightIconRect.x = textRect.x + Math.min(textRect.width, textWidth) + ((DisclosureButton)c).getTextRightIconGap();
            int n = insets.top;
            int n2 = ((DisclosureButton)c).getHeight();
            Intrinsics.checkNotNull((Object)insets);
            rightIconRect.y = n + (n2 - UiSizeUtilKt.getHeight(insets) - it.getIconHeight()) / 2;
            rightIconRect.width = it.getIconWidth();
            rightIconRect.height = it.getIconHeight();
            it.paintIcon(c, g, rightIconRect.x, rightIconRect.y);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable JComponent c) {
        Dimension result2 = super.getPreferredSize(c);
        if (c instanceof DisclosureButton) {
            Insets insets = ((DisclosureButton)c).getInsets();
            Dimension minimumSize = this.getMinimumSize(c);
            Dimension extraSize = this.getExtraIconsSize((DisclosureButton)c);
            result2.width += extraSize.width;
            result2.height = Math.max(result2.height, extraSize.height);
            int n = Math.max(result2.width + ((DisclosureButton)c).getLeftMargin() + ((DisclosureButton)c).getRightMargin(), minimumSize.width);
            Intrinsics.checkNotNull((Object)insets);
            result2.width = n + UiSizeUtilKt.getWidth(insets);
            result2.height = Math.max(result2.height, minimumSize.height) + UiSizeUtilKt.getHeight(insets);
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@Nullable JComponent c) {
        if (!(c instanceof DisclosureButton)) {
            Dimension dimension = super.getMinimumSize(c);
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
            return dimension;
        }
        return (Dimension)new JBDimension(72, ((DisclosureButton)c).getButtonHeight());
    }

    private final void paintBackground(Graphics g, DisclosureButton c) {
        Color color;
        Color defaultBg;
        Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        JBInsets.removeFrom((Rectangle)r, (Insets)c.getInsets());
        Color color2 = c.getButtonBackground();
        if (color2 == null) {
            color2 = c.getDefaultBackground();
        }
        if ((defaultBg = color2) != null) {
            DarculaNewUIUtil.INSTANCE.fillRoundedRectangle(g, r, defaultBg, c.getArc());
        }
        ButtonModel model2 = c.getModel();
        if (model2.isArmed() && model2.isPressed()) {
            color = c.getPressedBackground();
        } else if (model2.isRollover()) {
            color = c.getHoverBackground();
        } else {
            return;
        }
        Color overlay = color;
        if (overlay != null) {
            DarculaNewUIUtil.INSTANCE.fillRoundedRectangle(g, r, overlay, c.getArc());
        }
    }

    private final Dimension getExtraIconsSize(DisclosureButton b) {
        Dimension result2;
        block2: {
            block1: {
                result2 = new Dimension();
                Icon icon2 = b.getRightIcon();
                if (icon2 != null) {
                    Icon it = icon2;
                    boolean bl = false;
                    result2.width += b.getTextRightIconGap() + it.getIconWidth();
                    result2.height = Math.max(result2.height, it.getIconHeight());
                }
                Rectangle actionBounds = Companion.getAdditionalActionsButtonBounds$intellij_platform_ide_impl(b);
                if (actionBounds == null) break block1;
                result2.width += b.getIconTextGap() + actionBounds.width;
                result2.height = Math.max(result2.height, actionBounds.height);
                break block2;
            }
            Icon icon3 = b.getArrowIcon();
            if (icon3 == null) break block2;
            Icon it = icon3;
            boolean bl = false;
            result2.width += b.getIconTextGap() + it.getIconWidth();
            result2.height = Math.max(result2.height, it.getIconHeight());
        }
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final DarculaDisclosureButtonUI createUI(@NotNull JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI$Companion;", "", "<init>", "()V", "createUI", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI;", "c", "Ljavax/swing/JComponent;", "getAdditionalButtonArc", "", "getAdditionalButtonArc$intellij_platform_ide_impl", "getAdditionalButtonBorder", "getAdditionalButtonBorder$intellij_platform_ide_impl", "additionalActionsIcon", "Ljavax/swing/Icon;", "isHover", "", "additionalActionsIcon$intellij_platform_ide_impl", "intersectsWithAdditionalActionsButton", "Lcom/intellij/ui/components/DisclosureButton;", "e", "Ljava/awt/event/MouseEvent;", "intersectsWithAdditionalActionsButton$intellij_platform_ide_impl", "getAdditionalActionsButtonBounds", "Ljava/awt/Rectangle;", "getAdditionalActionsButtonBounds$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DarculaDisclosureButtonUI createUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return new DarculaDisclosureButtonUI(c);
        }

        public final int getAdditionalButtonArc$intellij_platform_ide_impl() {
            return JBUI.scale((int)6);
        }

        public final int getAdditionalButtonBorder$intellij_platform_ide_impl() {
            return JBUI.scale((int)2);
        }

        @NotNull
        public final Icon additionalActionsIcon$intellij_platform_ide_impl(boolean isHover) {
            Icon icon2;
            if (isHover) {
                Icon icon3 = AllIcons.Ide.Notification.GearHover;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"GearHover");
            } else {
                Icon icon4 = AllIcons.Ide.Notification.Gear;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Gear");
            }
            return icon2;
        }

        public final boolean intersectsWithAdditionalActionsButton$intellij_platform_ide_impl(@NotNull DisclosureButton c, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Rectangle rectangle = this.getAdditionalActionsButtonBounds$intellij_platform_ide_impl(c);
            if (rectangle == null) {
                return false;
            }
            Rectangle actionBounds = rectangle;
            return actionBounds.contains(e.getPoint());
        }

        @ApiStatus.Internal
        @Nullable
        public final Rectangle getAdditionalActionsButtonBounds$intellij_platform_ide_impl(@NotNull DisclosureButton c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (c.getAdditionalAction() == null) {
                return null;
            }
            Icon gearIcon = this.additionalActionsIcon$intellij_platform_ide_impl(false);
            int borderSize = this.getAdditionalButtonBorder$intellij_platform_ide_impl();
            Rectangle actionBounds = new Rectangle();
            actionBounds.width = gearIcon.getIconWidth() + borderSize * 2;
            actionBounds.height = gearIcon.getIconHeight() + borderSize * 2;
            actionBounds.x = c.getWidth() - c.getInsets().right - c.getRightMargin() - actionBounds.width;
            actionBounds.y = (c.getHeight() - actionBounds.height) / 2;
            return actionBounds;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI$ComponentHoverListener;", "Ljava/awt/event/ComponentAdapter;", "<init>", "(Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI;)V", "componentHidden", "", "e", "Ljava/awt/event/ComponentEvent;", "intellij.platform.ide.impl"})
    private final class ComponentHoverListener
    extends ComponentAdapter {
        @Override
        public void componentHidden(@Nullable ComponentEvent e) {
            DarculaDisclosureButtonUI.this.setAdditionalActionsButtonHovered(false);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI$MouseHoverListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/ide/ui/laf/darcula/ui/DarculaDisclosureButtonUI;)V", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "intellij.platform.ide.impl"})
    private final class MouseHoverListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JComponent jComponent = DarculaDisclosureButtonUI.this.getUiComponent();
            DisclosureButton disclosureButton = jComponent instanceof DisclosureButton ? (DisclosureButton)jComponent : null;
            if (disclosureButton == null) {
                return;
            }
            DisclosureButton button2 = disclosureButton;
            DarculaDisclosureButtonUI.this.setAdditionalActionsButtonHovered(Companion.intersectsWithAdditionalActionsButton$intellij_platform_ide_impl(button2, e));
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DarculaDisclosureButtonUI.this.setAdditionalActionsButtonHovered(false);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JComponent jComponent = DarculaDisclosureButtonUI.this.getUiComponent();
            DisclosureButton disclosureButton = jComponent instanceof DisclosureButton ? (DisclosureButton)jComponent : null;
            if (disclosureButton == null) {
                return;
            }
            DisclosureButton button2 = disclosureButton;
            DarculaDisclosureButtonUI.this.setAdditionalActionsButtonHovered(Companion.intersectsWithAdditionalActionsButton$intellij_platform_ide_impl(button2, e));
        }
    }
}

