/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.jetbrains.FontMetricsAccessor;
import com.jetbrains.JBR;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.util.Set;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class FontInfo {
    static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final Font DUMMY_FONT = new Font(null);
    private static final FontMetricsAccessor FONT_METRICS_ACCESSOR = JBR.getFontMetricsAccessor();
    private final Font myFont;
    private final float mySize;
    private final IntSet mySafeCharacters;
    private final FontRenderContext myContext;
    private FontMetrics myFontMetrics;

    public FontInfo(String familyName, int size2, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext fontRenderContext) {
        this.mySafeCharacters = new IntOpenHashSet();
        this.myFontMetrics = null;
        this.mySize = size2;
        this.myFont = EditorFontCacheImpl.deriveFontWithLigatures((Font)new Font(familyName, style, size2), (boolean)useLigatures);
        this.myContext = fontRenderContext;
    }

    public FontInfo(Font font, int size2, boolean useLigatures, FontRenderContext fontRenderContext) {
        this(font, (float)size2, useLigatures, fontRenderContext);
    }

    public FontInfo(Font font, float size2, boolean useLigatures, FontRenderContext fontRenderContext) {
        this.mySafeCharacters = new IntOpenHashSet();
        this.myFontMetrics = null;
        this.mySize = size2;
        this.myFont = EditorFontCacheImpl.deriveFontWithLigatures((Font)font.deriveFont(size2), (boolean)useLigatures);
        this.myContext = fontRenderContext;
    }

    public FontInfo(Font font, float size2, boolean useLigatures, @NotNull @Unmodifiable @NotNull Set<@NotNull String> variants, FontRenderContext fontRenderContext) {
        if (variants == null) {
            FontInfo.$$$reportNull$$$0(0);
        }
        this.mySafeCharacters = new IntOpenHashSet();
        this.myFontMetrics = null;
        this.mySize = size2;
        Font f = EditorFontCacheImpl.deriveFontWithLigatures((Font)font.deriveFont(size2), (boolean)useLigatures);
        if (variants.isEmpty()) {
            this.myFont = f;
        } else {
            String[] features = ArrayUtil.toStringArray(variants);
            this.myFont = JBR.getFontExtensions().deriveFontWithFeatures(f, features);
        }
        this.myContext = fontRenderContext;
    }

    public boolean canDisplay(int codePoint) {
        try {
            if (codePoint < 128) {
                return true;
            }
            if (this.mySafeCharacters.contains(codePoint)) {
                return true;
            }
            if (FontInfo.canDisplay(this.myFont, codePoint, false)) {
                this.mySafeCharacters.add(codePoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canDisplay(@NotNull Font font, int codePoint, boolean disableFontFallback) {
        if (font == null) {
            FontInfo.$$$reportNull$$$0(1);
        }
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (disableFontFallback && SystemInfo.isMac) {
            int glyphCode = font.createGlyphVector(DEFAULT_CONTEXT, new String(new int[]{codePoint}, 0, 1)).getGlyphCode(0);
            return (glyphCode & 0xFFFFFF) != 0 && (glyphCode & 0xFF000000) == 0;
        }
        return font.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth(metrics, codePoint);
    }

    public float charWidth2D(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth2D(metrics, codePoint);
    }

    public synchronized FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = FontInfo.getFontMetrics(this.myFont, this.myContext == null ? FontInfo.getFontRenderContext(null) : this.myContext);
        }
        return this.myFontMetrics;
    }

    @NotNull
    public static FontMetrics getFontMetrics(@NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        if (font == null) {
            FontInfo.$$$reportNull$$$0(2);
        }
        if (fontRenderContext == null) {
            FontInfo.$$$reportNull$$$0(3);
        }
        FontMetrics fontMetrics = FONT_METRICS_ACCESSOR.getMetrics(font, fontRenderContext);
        if (fontMetrics == null) {
            FontInfo.$$$reportNull$$$0(4);
        }
        return fontMetrics;
    }

    public static FontRenderContext getFontRenderContext(Component component2) {
        if (component2 == null) {
            return DEFAULT_CONTEXT;
        }
        return component2.getFontMetrics(DUMMY_FONT).getFontRenderContext();
    }

    public int getSize() {
        return (int)((double)this.mySize + 0.5);
    }

    public float getSize2D() {
        return this.mySize;
    }

    public FontRenderContext getFontRenderContext() {
        return this.myContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)o;
        return this.myFont.equals(fontInfo.myFont);
    }

    public int hashCode() {
        return this.myFont.hashCode();
    }

    public String toString() {
        return "FontInfo{myFont=" + String.valueOf(this.myFont) + ", mySize=" + this.mySize + ", mySafeCharacters=" + String.valueOf(this.mySafeCharacters) + ", myContext=" + String.valueOf(this.myContext) + ", myFontMetrics=" + String.valueOf(this.myFontMetrics) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontRenderContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDisplay";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFontMetrics";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

