/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ConfigurableCardPanel
extends CardLayoutPanel<Configurable, Configurable, JComponent> {
    private static final Logger LOG = Logger.getInstance(ConfigurableCardPanel.class);
    private final Map<Configurable, Disposable> myListeners = new ConcurrentHashMap<Configurable, Disposable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Configurable prepare(Configurable key) {
        long time = System.currentTimeMillis();
        try {
            ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)key);
        }
        catch (Exception unexpected) {
            LOG.error("cannot prepare configurable", (Throwable)unexpected);
        }
        finally {
            ConfigurableCardPanel.warn(key, "prepare", time);
        }
        return key;
    }

    @Override
    protected JComponent create(Configurable configurable) {
        if (configurable == null) {
            return null;
        }
        JComponent component2 = ConfigurableCardPanel.createConfigurableComponent(configurable);
        if (component2 == null) {
            return null;
        }
        if (configurable instanceof ConfigurableWrapper) {
            ReadAction.run(() -> this.addEPChangesListener((ConfigurableWrapper)configurable));
        }
        return new Wrapper(configurable, component2);
    }

    protected void addEPChangesListener(@NotNull ConfigurableWrapper wrapper2) {
        if (wrapper2 == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(0);
        }
        if (wrapper2.getExtensionPoint().dynamic) {
            return;
        }
        Configurable.WithEpDependencies configurable = ConfigurableWrapper.cast(Configurable.WithEpDependencies.class, (UnnamedConfigurable)wrapper2);
        if (configurable != null && !this.myListeners.containsKey(wrapper2)) {
            Disposable disposable = Disposer.newDisposable();
            Collection dependencies = configurable.getDependencies();
            Runnable listener2 = () -> ApplicationManager.getApplication().invokeLater(() -> {
                wrapper2.disposeUIResources();
                this.resetValue(wrapper2);
            }, ModalityState.stateForComponent((Component)this), __ -> this.isDisposed());
            for (BaseExtensionPointName dependency : dependencies) {
                if (dependency instanceof ExtensionPointName) {
                    ((ExtensionPointName)dependency).addChangeListener(listener2, disposable);
                    continue;
                }
                if (!(dependency instanceof ProjectExtensionPointName)) continue;
                Project project2 = wrapper2.getProject();
                assert (project2 != null);
                ((ProjectExtensionPointName)dependency).addChangeListener((AreaInstance)project2, listener2, disposable);
            }
            this.myListeners.put((Configurable)wrapper2, disposable);
        }
    }

    public static JComponent createConfigurableComponent(Configurable configurable) {
        return configurable == null ? null : (JComponent)ReadAction.compute(() -> {
            JComponent component2 = null;
            long time = System.currentTimeMillis();
            try {
                component2 = configurable.createComponent();
            }
            catch (Exception unexpected) {
                LOG.error("cannot create configurable component", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable, "create", time);
            }
            if (component2 != null) {
                ConfigurableCardPanel.reset(configurable);
                if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable) == null) {
                    if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable) == null) {
                        if (!component2.getClass().equals(JPanel.class) && !component2.getClass().equals(DialogPanel.class)) {
                            JPanel panel2 = new JPanel(new BorderLayout());
                            panel2.add("Center", component2);
                            component2 = panel2;
                        }
                        if (component2.getLayout() instanceof GridLayout) {
                            component2.setBorder((Border)JBUI.Borders.empty((int)5, (int)16, (int)10, (int)16));
                        } else {
                            component2.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)16, (int)16));
                        }
                    }
                    if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable) == null) {
                        JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                        scroll.setViewport((JViewport)((Object)new GradientViewport(component2, (Insets)JBUI.insetsTop((int)5), true)));
                        scroll.getVerticalScrollBar().setBackground(JBColor.PanelBackground);
                        scroll.getHorizontalScrollBar().setBackground(JBColor.PanelBackground);
                        component2 = scroll;
                    }
                }
            }
            return component2;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(Configurable configurable, JComponent component2) {
        if (configurable != null) {
            long time = System.currentTimeMillis();
            try {
                configurable.disposeUIResources();
                Disposable disposer = this.myListeners.remove(configurable);
                if (disposer != null) {
                    Disposer.dispose((Disposable)disposer);
                }
                if (component2 instanceof Disposable) {
                    Disposer.dispose((Disposable)((Disposable)component2));
                }
                ConfigurableCardPanel.autoDispose(configurable, component2);
            }
            catch (Exception unexpected) {
                LOG.error("cannot dispose configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable, "dispose", time);
            }
        }
    }

    private static void autoDispose(Configurable configurable, Component component2) {
        UIUtil.uiTraverser((Component)component2).traverse().filter(Disposable.class).filter(disposable -> !Disposer.isDisposed((Disposable)disposable)).forEach(disposable -> {
            LOG.warn(ConfigurableCardPanel.getString("auto-dispose", configurable));
            Disposer.dispose((Disposable)disposable);
            if (LOG.isDebugEnabled()) {
                UIUtil.uiParents((Component)((Component)disposable), (boolean)false).forEach(parent -> LOG.debug("  in ", new Object[]{parent.getClass()}));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Configurable configurable) {
        if (configurable != null) {
            long time = System.currentTimeMillis();
            try {
                configurable.reset();
            }
            catch (Exception unexpected) {
                LOG.error("cannot reset configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable, "reset", time);
            }
        }
    }

    @NotNull
    private static String getString(@NotNull String prefix, @NotNull Configurable configurable) {
        if (prefix == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(1);
        }
        if (configurable == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(2);
        }
        String name2 = configurable.getDisplayName();
        String id2 = ConfigurableVisitor.getId(configurable);
        String string = prefix + " '" + name2 + "' id=" + id2;
        if (string == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    static void warn(Configurable configurable, String action2, long time) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            time = System.currentTimeMillis() - time;
            int threshold = Registry.intValue((String)"ide.settings.configurable.loading.threshold", (int)0);
            if (0 < threshold && (long)threshold < time) {
                LOG.warn(time + " ms to " + ConfigurableCardPanel.getString(action2, configurable));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myListeners.values().forEach(Disposer::dispose);
        this.myListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableCardPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableCardPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEPChangesListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class Wrapper
    extends JPanel
    implements Disposable,
    UiDataProvider {
        private final Configurable myConfigurable;

        private Wrapper(@NotNull Configurable configurable, @NotNull JComponent component2) {
            if (configurable == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myConfigurable = configurable;
            this.add("Center", component2);
        }

        public void dispose() {
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            sink.set(PlatformDataKeys.UI_DISPOSABLE, (Object)this);
        }

        @Override
        public String toString() {
            return ConfigurableCardPanel.getString("configurable wrapper", this.myConfigurable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableCardPanel$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

