/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.FrameWrapperKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.RootPaneUtil;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.DisposableWindow;
import com.intellij.ui.FrameState;
import com.intellij.ui.mac.screenmenu.Menu;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000f\u0010\u001f\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\rH\u0016J\u001c\u0010%\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020\rH\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u0018H\u0002J\b\u0010,\u001a\u00020\u0018H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0016J(\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u000205H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/openapi/ui/MyJFrame;", "Ljavax/swing/JFrame;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/wm/IdeFrame$Child;", "Lcom/intellij/openapi/wm/ex/IdeFrameEx;", "Lcom/intellij/ui/DisposableWindow;", "owner", "Lcom/intellij/openapi/ui/FrameWrapper;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "<init>", "(Lcom/intellij/openapi/ui/FrameWrapper;Lcom/intellij/openapi/wm/IdeFrame;)V", "frameTitle", "", "fileTitle", "file", "Ljava/nio/file/Path;", "isWindowDisposed", "", "isInFullScreen", "toggleFullScreen", "Lkotlinx/coroutines/Job;", "state", "addNotify", "", "getComponent", "Ljavax/swing/JComponent;", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "getProject", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "notifyProjectActivation", "setFrameTitle", "title", "setFileTitle", "ioFile", "getNorthExtension", "key", "getBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "updateTitle", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "paint", "g", "Ljava/awt/Graphics;", "reshape", "x", "", "y", "width", "height", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFrameWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameWrapper.kt\ncom/intellij/openapi/ui/MyJFrame\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n42#2,3:488\n1#3:491\n*S KotlinDebug\n*F\n+ 1 FrameWrapper.kt\ncom/intellij/openapi/ui/MyJFrame\n*L\n319#1:488,3\n*E\n"})
final class MyJFrame
extends JFrame
implements UiDataProvider,
IdeFrame.Child,
IdeFrameEx,
DisposableWindow {
    @NotNull
    private FrameWrapper owner;
    @NotNull
    private final IdeFrame parent;
    @Nullable
    private String frameTitle;
    @Nullable
    private String fileTitle;
    @Nullable
    private Path file;

    public MyJFrame(@NotNull FrameWrapper owner, @NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.owner = owner;
        this.parent = parent;
        FrameState.setFrameStateListener(this);
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        this.setGlassPane(new IdeGlassPaneImpl(jRootPane, true));
        if (SystemInfoRt.isMac && !Menu.isJbScreenMenuEnabled()) {
            boolean $i$f$service = false;
            Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            this.setJMenuBar(RootPaneUtil.INSTANCE.createMenuBar(CoroutineScopeKt.childScope$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, (boolean)false, (int)3, null), this, null));
        }
        MouseGestureManager.getInstance().add(this);
        this.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
    }

    public boolean isWindowDisposed() {
        return this.owner.isDisposed();
    }

    public boolean isInFullScreen() {
        return false;
    }

    @Override
    @NotNull
    public Job toggleFullScreen(boolean state2) {
        return (Job)CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
    }

    @Override
    public void addNotify() {
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            CustomHeader.Companion.enableCustomHeader(this);
        }
        super.addNotify();
    }

    @NotNull
    public JComponent getComponent() {
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return jRootPane;
    }

    @Nullable
    public StatusBar getStatusBar() {
        StatusBar statusBar = this.owner.isDisposing ? null : this.owner.statusBar;
        if (statusBar == null) {
            statusBar = this.parent.getStatusBar();
        }
        return statusBar;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.parent.suggestChildFrameBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"suggestChildFrameBounds(...)");
        return rectangle;
    }

    @Nullable
    public Project getProject() {
        return this.parent.getProject();
    }

    public void notifyProjectActivation() {
        this.parent.notifyProjectActivation();
    }

    public void setFrameTitle(@NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.frameTitle = title2;
        this.updateTitle();
    }

    @Override
    public void setFileTitle(@Nullable String fileTitle, @Nullable Path ioFile) {
        this.fileTitle = fileTitle;
        this.file = ioFile;
        this.updateTitle();
    }

    @Override
    @Nullable
    public JComponent getNorthExtension(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.owner.getNorthExtension$intellij_platform_ide_impl(key);
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return null;
    }

    private final void updateTitle() {
        block2: {
            if (AdvancedSettings.Companion.getBoolean("ide.show.fileType.icon.in.titleBar")) {
                Path path = this.file;
                this.rootPane.putClientProperty("Window.documentFile", path != null ? path.toFile() : null);
            }
            StringBuilder builder = new StringBuilder();
            ProjectFrameHelper.Companion.appendTitlePart$intellij_platform_ide_impl(builder, this.frameTitle);
            ProjectFrameHelper.Companion.appendTitlePart$intellij_platform_ide_impl(builder, this.fileTitle);
            this.setTitle(builder.toString());
            CharSequence charSequence = this.getTitle();
            if (!(charSequence == null || charSequence.length() == 0)) break block2;
            Project project2 = this.getProject();
            if (project2 != null) {
                Project it = project2;
                boolean bl = false;
                this.setTitle(FrameTitleBuilder.Companion.getInstance().getProjectTitle(it));
            }
        }
    }

    @Override
    public void dispose() {
        FrameWrapper owner = this.owner;
        if (owner.isDisposing) {
            return;
        }
        owner.isDisposing = true;
        this.setVisible(false);
        Disposer.dispose((Disposable)owner);
        super.dispose();
        this.rootPane = null;
        this.setMenuBar(null);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = IdeFrame.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
        sink.set(dataKey, (Object)this);
        if (!this.owner.isDisposing) {
            DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.owner);
        }
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        sink.set(dataKey2, (Object)this.getProject());
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        UISettings.Companion.setupAntialiasing(g);
        super.paint(g);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (FrameWrapperKt.access$getLOG$p().isTraceEnabled()) {
            FrameWrapperKt.access$getLOG$p().trace(new Throwable("FrameWrapper frame bounds changed to " + x + ", " + y + ", " + width + ", " + height));
        }
        super.reshape(x, y, width, height);
    }
}

