/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseCardComponent;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseCardComponentKt;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseInfo;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CoursesModel;
import com.intellij.util.ui.JBUI;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u001a\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CoursesListPanel;", "Ljavax/swing/JPanel;", "courses", "", "Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CourseInfo;", "<init>", "(Ljava/util/List;)V", "coursesModel", "Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CoursesModel;", "updatePanel", "", "setClickListener", "onClick", "Lkotlin/Function1;", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CoursesListPanel
extends JPanel {
    @NotNull
    private final CoursesModel coursesModel;

    public CoursesListPanel(@NotNull List<? extends CourseInfo> courses) {
        Intrinsics.checkNotNullParameter(courses, (String)"courses");
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        this.coursesModel = new CoursesModel();
        this.setBackground(CourseCardComponentKt.getMainBackgroundColor());
        this.setBorder((Border)JBUI.Borders.empty());
        this.updatePanel(courses);
    }

    public final void updatePanel(@NotNull List<? extends CourseInfo> courses) {
        Intrinsics.checkNotNullParameter(courses, (String)"courses");
        this.removeAll();
        for (CourseInfo courseInfo : courses) {
            CourseCardComponent courseCardComponent = new CourseCardComponent(courseInfo);
            courseCardComponent.updateColors(CourseCardComponentKt.getMainBackgroundColor());
            this.coursesModel.addCourseCard(courseCardComponent);
            this.add(courseCardComponent);
        }
        this.revalidate();
        this.repaint();
    }

    public final void setClickListener(@NotNull Function1<? super CourseInfo, Boolean> onClick) {
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.coursesModel.setOnClick(onClick);
    }
}

