/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.SliderComponent;
import com.intellij.ui.colorpicker.SliderComponentKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0+H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u00020#2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#0\"J\b\u00101\u001a\u00020#H\u0002J\u0015\u00102\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\bH$\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\bH\u0002J\u0015\u00108\u001a\u00028\u00002\u0006\u00107\u001a\u00020\bH$\u00a2\u0006\u0002\u00103J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020:H\u0016J\b\u0010<\u001a\u00020:H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020DH\u0014J\u0010\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020GH$J\u0018\u0010H\u001a\u00020#2\u0006\u0010F\u001a\u00020G2\u0006\u0010I\u001a\u00020\bH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R$\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u0006R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010 \u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020# $*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0018\u00010\"0\" $*-\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020# $*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0018\u00010\"0\"0&\u00a2\u0006\u0002\b%0!\u00a2\u0006\u0002\b%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\n\u00a8\u0006J"}, d2={"Lcom/intellij/ui/colorpicker/SliderComponent;", "T", "", "Ljavax/swing/JComponent;", "initialValue", "<init>", "(Ljava/lang/Number;)V", "leftPadding", "", "getLeftPadding", "()I", "rightPadding", "getRightPadding", "topPadding", "getTopPadding", "bottomPadding", "getBottomPadding", "_knobPosition", "newPointerValue", "knobPosition", "getKnobPosition", "setKnobPosition", "(I)V", "_value", "Ljava/lang/Number;", "newValue", "value", "getValue", "()Ljava/lang/Number;", "setValue", "polygonToDraw", "Ljava/awt/Polygon;", "listeners", "", "Lkotlin/Function1;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "sliderWidth", "getSliderWidth", "runAndUpdateIfNeeded", "task", "Lkotlin/Function0;", "processMouse", "e", "Ljava/awt/event/MouseEvent;", "addListener", "listener", "fireValueChanged", "knobPositionToValue", "(I)Ljava/lang/Number;", "valueToKnobPosition", "(Ljava/lang/Number;)I", "doSlide", "shift", "slide", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "getMaximumSize", "isFocusable", "", "setToolTipText", "text", "", "paintComponent", "g", "Ljava/awt/Graphics;", "paintSlider", "g2d", "Ljava/awt/Graphics2D;", "drawKnob", "x", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSliderComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliderComponent.kt\ncom/intellij/ui/colorpicker/SliderComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1915#2,2:224\n*S KotlinDebug\n*F\n+ 1 SliderComponent.kt\ncom/intellij/ui/colorpicker/SliderComponent\n*L\n161#1:224,2\n*E\n"})
public abstract class SliderComponent<T extends Number>
extends JComponent {
    private final int leftPadding;
    private final int rightPadding;
    private final int topPadding;
    private final int bottomPadding;
    private int _knobPosition;
    @NotNull
    private T _value;
    @NotNull
    private final Polygon polygonToDraw;
    @NotNull
    private final List<Function1<T, Unit>> listeners;

    public SliderComponent(@NotNull T initialValue) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        this.leftPadding = SliderComponentKt.access$getDEFAULT_HORIZONTAL_PADDING$p();
        this.rightPadding = SliderComponentKt.access$getDEFAULT_HORIZONTAL_PADDING$p();
        this.topPadding = SliderComponentKt.access$getDEFAULT_VERTICAL_PADDING$p();
        this.bottomPadding = SliderComponentKt.access$getDEFAULT_VERTICAL_PADDING$p();
        this._value = initialValue;
        this.polygonToDraw = new Polygon();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseWheelListener(arg_0 -> SliderComponent._init_$lambda$0(this, arg_0));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.repaint();
            }
        });
        ActionMap $this$_init__u24lambda_u241 = this.getActionMap();
        boolean bl = false;
        $this$_init__u24lambda_u241.put("actionSlideLeft", new AbstractAction(this){
            final /* synthetic */ SliderComponent<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, () -> 6.1.actionPerformed$lambda$0(this.this$0));
            }

            private static final Unit actionPerformed$lambda$0(SliderComponent this$0) {
                SliderComponent.access$doSlide(this$0, -1);
                return Unit.INSTANCE;
            }
        });
        $this$_init__u24lambda_u241.put("actionSlideLeftStep", new AbstractAction(this){
            final /* synthetic */ SliderComponent<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, () -> 6.2.actionPerformed$lambda$0(this.this$0));
            }

            private static final Unit actionPerformed$lambda$0(SliderComponent this$0) {
                SliderComponent.access$doSlide(this$0, -10);
                return Unit.INSTANCE;
            }
        });
        $this$_init__u24lambda_u241.put("actionSlideRight", new AbstractAction(this){
            final /* synthetic */ SliderComponent<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, () -> 6.3.actionPerformed$lambda$0(this.this$0));
            }

            private static final Unit actionPerformed$lambda$0(SliderComponent this$0) {
                SliderComponent.access$doSlide(this$0, 1);
                return Unit.INSTANCE;
            }
        });
        $this$_init__u24lambda_u241.put("actionSlideRightStep", new AbstractAction(this){
            final /* synthetic */ SliderComponent<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SliderComponent.access$runAndUpdateIfNeeded(this.this$0, () -> 6.4.actionPerformed$lambda$0(this.this$0));
            }

            private static final Unit actionPerformed$lambda$0(SliderComponent this$0) {
                SliderComponent.access$doSlide(this$0, 10);
                return Unit.INSTANCE;
            }
        });
        InputMap $this$_init__u24lambda_u242 = this.getInputMap(0);
        boolean bl2 = false;
        $this$_init__u24lambda_u242.put(KeyStroke.getKeyStroke(37, 0), "actionSlideLeft");
        $this$_init__u24lambda_u242.put(KeyStroke.getKeyStroke(37, 64), "actionSlideLeftStep");
        $this$_init__u24lambda_u242.put(KeyStroke.getKeyStroke(39, 0), "actionSlideRight");
        $this$_init__u24lambda_u242.put(KeyStroke.getKeyStroke(39, 64), "actionSlideRightStep");
    }

    protected final int getLeftPadding() {
        return this.leftPadding;
    }

    protected final int getRightPadding() {
        return this.rightPadding;
    }

    protected final int getTopPadding() {
        return this.topPadding;
    }

    protected final int getBottomPadding() {
        return this.bottomPadding;
    }

    private final int getKnobPosition() {
        return this._knobPosition;
    }

    private final void setKnobPosition(int newPointerValue) {
        this._knobPosition = newPointerValue;
        this._value = this.knobPositionToValue(newPointerValue);
    }

    @NotNull
    public final T getValue() {
        return this._value;
    }

    public final void setValue(@NotNull T newValue) {
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        this._value = newValue;
        this._knobPosition = this.valueToKnobPosition(newValue);
    }

    public final int getSliderWidth() {
        return Math.max(0, this.getWidth() - this.leftPadding - this.rightPadding);
    }

    private final void runAndUpdateIfNeeded(Function0<Unit> task) {
        T oldValue = this.getValue();
        task.invoke();
        this.repaint();
        if (!Intrinsics.areEqual(oldValue, this.getValue())) {
            this.fireValueChanged();
        }
    }

    private final void processMouse(MouseEvent e) {
        this.runAndUpdateIfNeeded((Function0<Unit>)((Function0)() -> SliderComponent.processMouse$lambda$0(e, this)));
    }

    public final void addListener(@NotNull Function1<? super T, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    private final void fireValueChanged() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(this.getValue());
        }
    }

    @NotNull
    protected abstract T knobPositionToValue(int var1);

    protected abstract int valueToKnobPosition(@NotNull T var1);

    private final void doSlide(int shift) {
        this.setValue(this.slide(shift));
    }

    @NotNull
    protected abstract T slide(int var1);

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)100, (int)22);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)50, (int)22);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setToolTipText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        if (this.isFocusOwner()) {
            Color color = UIUtil.getFocusedFillColor();
            if (color == null) {
                color = Color.BLUE.brighter();
            }
            g2d.setColor(color);
            int left = this.leftPadding - 3;
            int top = this.topPadding - 3;
            int width = this.getWidth() - left - this.rightPadding + 3;
            int height = this.getHeight() - top - this.bottomPadding + 3;
            g2d.fillRoundRect(left, top, width, height, 5, 5);
        }
        this.paintSlider(g2d);
        this.drawKnob(g2d, this.leftPadding + this.valueToKnobPosition(this.getValue()));
    }

    protected abstract void paintSlider(@NotNull Graphics2D var1);

    private final void drawKnob(Graphics2D g2d, int x) {
        Object originalAntialiasing = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke originalStroke = g2d.getStroke();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int knobLeft = x - 2;
        int knobTop = this.topPadding / 2;
        int knobWidth = 5;
        int knobHeight = this.getHeight() - (this.topPadding + this.bottomPadding) / 2;
        g2d.setColor(SliderComponentKt.access$getKNOB_COLOR$p());
        g2d.fillRoundRect(knobLeft, knobTop, knobWidth, knobHeight, 5, 5);
        g2d.setColor((Color)SliderComponentKt.access$getKNOB_BORDER_COLOR$p());
        g2d.setStroke(SliderComponentKt.access$getKNOB_BORDER_STROKE$p());
        g2d.drawRoundRect(knobLeft, knobTop, knobWidth, knobHeight, 5, 5);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, originalAntialiasing);
        g2d.setStroke(originalStroke);
    }

    private static final Unit lambda$0$0(SliderComponent this$0, MouseWheelEvent $e) {
        this$0.setValue(this$0.slide(-((int)$e.getPreciseWheelRotation())));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(SliderComponent this$0, MouseWheelEvent e) {
        this$0.runAndUpdateIfNeeded((Function0<Unit>)((Function0)() -> SliderComponent.lambda$0$0(this$0, e)));
        e.consume();
    }

    private static final Unit processMouse$lambda$0(MouseEvent $e, SliderComponent this$0) {
        int newKnobPosition = Math.max(0, Math.min($e.getX() - this$0.leftPadding, this$0.getSliderWidth()));
        this$0.setKnobPosition(newKnobPosition);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$runAndUpdateIfNeeded(SliderComponent $this, Function0 task) {
        $this.runAndUpdateIfNeeded((Function0<Unit>)task);
    }

    public static final /* synthetic */ void access$doSlide(SliderComponent $this, int shift) {
        $this.doSlide(shift);
    }
}

