/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.impl;

import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JBHtmlPaneRenderableImage
implements RenderableImage {
    @NotNull
    private final URL myImageUrl;
    @NotNull
    private final Component myReferenceComponent;
    private Image myImage;
    private boolean myImageLoaded;

    JBHtmlPaneRenderableImage(@NotNull URL imageUrl, @NotNull Component referenceComponent) {
        if (imageUrl == null) {
            JBHtmlPaneRenderableImage.$$$reportNull$$$0(0);
        }
        if (referenceComponent == null) {
            JBHtmlPaneRenderableImage.$$$reportNull$$$0(1);
        }
        this.myImageUrl = imageUrl;
        this.myReferenceComponent = referenceComponent;
    }

    @Override
    public Vector<RenderableImage> getSources() {
        return null;
    }

    @Override
    public Object getProperty(String name2) {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public float getWidth() {
        return this.getImage().getWidth(null);
    }

    @Override
    public float getHeight() {
        return this.getImage().getHeight(null);
    }

    @Override
    public float getMinX() {
        return 0.0f;
    }

    @Override
    public float getMinY() {
        return 0.0f;
    }

    @Override
    public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        return this.createDefaultRendering();
    }

    @Override
    public RenderedImage createDefaultRendering() {
        return (RenderedImage)((Object)this.getImage());
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        return this.createDefaultRendering();
    }

    private Image getImage() {
        if (!this.myImageLoaded) {
            Image image2 = this.loadImageFromUrl();
            this.myImage = ImageUtil.toBufferedImage((Image)(image2 != null ? image2 : ((ImageIcon)UIManager.getLookAndFeelDefaults().get("html.missingImage")).getImage()), (boolean)false, (boolean)true);
            this.myImageLoaded = true;
        }
        return this.myImage;
    }

    @Nullable
    private Image loadImageFromUrl() {
        Image image2 = ImageLoader.loadFromUrl((URL)this.myImageUrl);
        if (image2 != null && image2.getWidth(null) > 0 && image2.getHeight(null) > 0) {
            return image2;
        }
        try {
            BufferedImage direct = ImageIO.read(this.myImageUrl);
            if (direct != null) {
                return ImageUtil.ensureHiDPI((Image)direct, (ScaleContext)ScaleContext.create((Component)this.myReferenceComponent));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "imageUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "referenceComponent";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/components/impl/JBHtmlPaneRenderableImage";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

