/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.filterField;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\b&\u0018\u0000 \u00152\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0004J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H$J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H$J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/filterField/SearchQueryParserBase;", "", "<init>", "()V", "words", "", "", "getWords", "addWords", "", "word", "handleAttribute", "name", "value", "getAttributes", "splitQuery", "", "query", "parse", "QueryCompletionParserState", "QueryCompletionPosition", "Companion", "intellij.platform.ide.impl"})
public abstract class SearchQueryParserBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<String> words = SetsKt.emptySet();

    @NotNull
    public final Set<String> getWords() {
        return this.words;
    }

    protected final void addWords(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        this.words = SetsKt.plus(this.words, (Object)word);
    }

    protected abstract void handleAttribute(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected abstract Set<String> getAttributes();

    private final List<String> splitQuery(String query) {
        List parts = new ArrayList();
        int length = query.length();
        int index = 0;
        block3: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == ',') {
                parts.add(",");
                continue;
            }
            if (startCh == '\"') {
                int end = StringsKt.indexOf$default((CharSequence)query, (char)'\"', (int)index, (boolean)false, (int)4, null);
                if (end == -1) break;
                String string = query.substring(index, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                parts.add(string);
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index <= length) {
                char nextCh;
                if (index == length) {
                    String string = query.substring(start2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    parts.add(string);
                    continue block3;
                }
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && nextCh != ',' && index != length) continue;
                String string = query.substring(start2, switch (nextCh) {
                    case ' ', ',' -> index - 1;
                    default -> index;
                });
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                parts.add(string);
                if (nextCh != ',') continue block3;
                parts.add(",");
                continue block3;
            }
        }
        return parts;
    }

    public final void parse(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List<String> parts = this.splitQuery(query);
        int size2 = parts.size();
        if (size2 == 0) {
            return;
        }
        int index = 0;
        while (index < size2) {
            int nameIndex = index;
            String name2 = parts.get(index++);
            if (this.getAttributes().contains(name2)) {
                if (index < size2) {
                    while (index < size2 && (Intrinsics.areEqual((Object)parts.get(index), (Object)",") || Intrinsics.areEqual((Object)parts.get(index - 1), (Object)",") || index - 1 == nameIndex)) {
                        if (!Intrinsics.areEqual((Object)parts.get(index), (Object)",") && (Intrinsics.areEqual((Object)parts.get(index - 1), (Object)",") || index - 1 == nameIndex)) {
                            this.handleAttribute(name2, parts.get(index));
                        }
                        ++index;
                    }
                    continue;
                }
                this.addWords(name2);
                break;
            }
            this.addWords(name2);
        }
    }

    @JvmStatic
    @NotNull
    public static final String wrapAttribute(@NotNull String value) {
        return Companion.wrapAttribute(value);
    }

    @JvmStatic
    @NotNull
    public static final QueryCompletionPosition parseAttributeInQuery(@NotNull String query, int completionPosition) {
        return Companion.parseAttributeInQuery(query, completionPosition);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/filterField/SearchQueryParserBase$Companion;", "", "<init>", "()V", "wrapAttribute", "", "value", "parseAttributeInQuery", "Lcom/intellij/ui/filterField/SearchQueryParserBase$QueryCompletionPosition;", "query", "completionPosition", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String wrapAttribute(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringUtil.containsAnyChar((String)value, (String)" ,:")) {
                String string2 = StringUtil.wrapWithDoubleQuote((String)value);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapWithDoubleQuote(...)");
            } else {
                string = value;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final QueryCompletionPosition parseAttributeInQuery(@NotNull String query, int completionPosition) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            int end = completionPosition;
            int index = end - 1;
            String value = null;
            QueryCompletionParserState state2 = QueryCompletionParserState.TEXT;
            Integer startPosition = null;
            block11: while (index >= 0) {
                char ch = query.charAt(index);
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                    case 1: {
                        end = index + 1;
                        --index;
                        while (index >= 0 && query.charAt(index) != ' ' && query.charAt(index) != ',' && query.charAt(index) != '\"') {
                            --index;
                        }
                        break block11;
                    }
                    case 2: {
                        if (ch != '\"') break;
                        state2 = QueryCompletionParserState.TEXT;
                        if (value != null) break;
                        Intrinsics.checkNotNullExpressionValue((Object)query.substring(index + 1, end), (String)"substring(...)");
                        startPosition = index + 1;
                        break;
                    }
                    case 3: {
                        if (ch == ',') {
                            state2 = QueryCompletionParserState.TEXT;
                            break;
                        }
                        if (ch == ':') {
                            state2 = QueryCompletionParserState.ATTRIBUTE_NAME;
                            if (value != null) continue block11;
                            Intrinsics.checkNotNullExpressionValue((Object)query.substring(index + 1, end), (String)"substring(...)");
                            startPosition = index + 1;
                            continue block11;
                        }
                        if (ch == '\"' || ch == ' ') break;
                        if (startPosition == null) {
                            startPosition = index + 1;
                        }
                        String string = StringUtil.trim((String)Strings.notNullize((String)value));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
                        return new QueryCompletionPosition(string, null, startPosition);
                    }
                    default: {
                        switch (ch) {
                            case ',': {
                                if (value != null) break block0;
                                Intrinsics.checkNotNullExpressionValue((Object)query.substring(index + 1, end), (String)"substring(...)");
                                startPosition = index + 1;
                                break block0;
                            }
                            case ':': {
                                state2 = QueryCompletionParserState.ATTRIBUTE_NAME;
                                if (value != null) continue block11;
                                Intrinsics.checkNotNullExpressionValue((Object)query.substring(index + 1, end), (String)"substring(...)");
                                startPosition = index + 1;
                                continue block11;
                            }
                            case '\"': {
                                state2 = QueryCompletionParserState.ESCAPED_VALUE;
                                break block0;
                            }
                            case ' ': {
                                state2 = QueryCompletionParserState.EMPTY_SPACE;
                                if (value != null) break block0;
                                Intrinsics.checkNotNullExpressionValue((Object)query.substring(index + 1, end), (String)"substring(...)");
                                startPosition = index + 1;
                            }
                        }
                    }
                }
                --index;
            }
            if (startPosition == null) {
                startPosition = index + 1;
            }
            String string = query.substring(index + 1, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String attributeName = StringUtil.trim((String)string);
            if (state2 == QueryCompletionParserState.ATTRIBUTE_NAME) {
                Intrinsics.checkNotNull((Object)attributeName);
                return new QueryCompletionPosition(attributeName, StringUtil.trim(value), startPosition);
            }
            Intrinsics.checkNotNull((Object)attributeName);
            return new QueryCompletionPosition(attributeName, null, startPosition);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QueryCompletionParserState.values().length];
                try {
                    nArray[QueryCompletionParserState.ATTRIBUTE_NAME.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QueryCompletionParserState.ESCAPED_VALUE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QueryCompletionParserState.EMPTY_SPACE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/filterField/SearchQueryParserBase$QueryCompletionParserState;", "", "<init>", "(Ljava/lang/String;I)V", "TEXT", "EMPTY_SPACE", "ESCAPED_VALUE", "ATTRIBUTE_NAME", "intellij.platform.ide.impl"})
    private static final class QueryCompletionParserState
    extends Enum<QueryCompletionParserState> {
        public static final /* enum */ QueryCompletionParserState TEXT = new QueryCompletionParserState();
        public static final /* enum */ QueryCompletionParserState EMPTY_SPACE = new QueryCompletionParserState();
        public static final /* enum */ QueryCompletionParserState ESCAPED_VALUE = new QueryCompletionParserState();
        public static final /* enum */ QueryCompletionParserState ATTRIBUTE_NAME = new QueryCompletionParserState();
        private static final /* synthetic */ QueryCompletionParserState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QueryCompletionParserState[] values() {
            return (QueryCompletionParserState[])$VALUES.clone();
        }

        public static QueryCompletionParserState valueOf(String value) {
            return Enum.valueOf(QueryCompletionParserState.class, value);
        }

        @NotNull
        public static EnumEntries<QueryCompletionParserState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = queryCompletionParserStateArray = new QueryCompletionParserState[]{QueryCompletionParserState.TEXT, QueryCompletionParserState.EMPTY_SPACE, QueryCompletionParserState.ESCAPED_VALUE, QueryCompletionParserState.ATTRIBUTE_NAME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/filterField/SearchQueryParserBase$QueryCompletionPosition;", "", "attributeName", "", "attributeValue", "startPosition", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "getAttributeName", "()Ljava/lang/String;", "getAttributeValue", "getStartPosition", "()I", "intellij.platform.ide.impl"})
    public static final class QueryCompletionPosition {
        @NotNull
        private final String attributeName;
        @Nullable
        private final String attributeValue;
        private final int startPosition;

        public QueryCompletionPosition(@NotNull String attributeName, @Nullable String attributeValue, int startPosition) {
            Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
            this.startPosition = startPosition;
        }

        @NotNull
        public final String getAttributeName() {
            return this.attributeName;
        }

        @Nullable
        public final String getAttributeValue() {
            return this.attributeValue;
        }

        public final int getStartPosition() {
            return this.startPosition;
        }
    }
}

