/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.DependsSubDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.KotlinK2ModeCompatibilityCheckerKt;
import com.intellij.ide.plugins.MainPluginDescriptorClassPathInfo;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0005H\u0002J#\u0010+\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020!0$H\u0002\u00a2\u0006\u0002\u0010-J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J9\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020!0$2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001107H\u0002\u00a2\u0006\u0002\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "coreLoaderOverride", "Ljava/lang/ClassLoader;", "<init>", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "coreLoader", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lcom/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/MainPluginDescriptorClassPathInfo;", "configureDescriptorDynamic", "", "subDescriptor", "Lcom/intellij/ide/plugins/ContentModuleDescriptor;", "configure", "", "configureModule", "module", "Lcom/intellij/ide/plugins/PluginModuleDescriptor;", "configureContentModule", "getSortedDependencies", "", "(Lcom/intellij/ide/plugins/PluginModuleDescriptor;)[Lcom/intellij/ide/plugins/PluginModuleDescriptor;", "configureMainPluginModule", "mainDescriptor", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "setClassLoaderForModuleAndDependsSubDescriptors", "mainClassLoader", "configureCorePluginContentModuleClassLoader", "deps", "(Lcom/intellij/ide/plugins/ContentModuleDescriptor;[Lcom/intellij/ide/plugins/PluginModuleDescriptor;)V", "getCoreUrlClassLoaderIfPossible", "Lcom/intellij/util/lang/UrlClassLoader;", "checkPackagePrefixUniqueness", "createPluginClassLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "classPath", "Lcom/intellij/util/lang/ClassPath;", "libDirectories", "", "(Lcom/intellij/ide/plugins/PluginMainDescriptor;[Lcom/intellij/ide/plugins/PluginModuleDescriptor;Lcom/intellij/util/lang/ClassPath;Ljava/util/List;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassLoaderConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,495:1\n1#2:496\n37#3,2:497\n*S KotlinDebug\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n*L\n178#1:497,2\n*E\n"})
public final class ClassLoaderConfigurator {
    @NotNull
    private final PluginSet pluginSet;
    @NotNull
    private final ClassLoader coreLoader;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    @NotNull
    private final IdentityHashMap<PluginId, MainPluginDescriptorClassPathInfo> mainToClassPath;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @Nullable ClassLoader coreLoaderOverride) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        this.pluginSet = pluginSet;
        ClassLoader classLoader = coreLoaderOverride;
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
        }
        this.coreLoader = classLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLOG().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            classLoader = null;
        }
        this(pluginSet, classLoader);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final boolean configureDescriptorDynamic(@NotNull ContentModuleDescriptor subDescriptor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)subDescriptor, (String)"subDescriptor");
            PluginMainDescriptor mainDescriptor = IdeaPluginDescriptorImplKt.getMainDescriptor(subDescriptor);
            PluginId pluginId = mainDescriptor.getPluginId();
            boolean bl = Intrinsics.areEqual((Object)pluginId, (Object)subDescriptor.getPluginId());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "pluginId '" + pluginId + "' != moduleDescriptor.pluginId '" + subDescriptor.getPluginId() + '\'';
                throw new AssertionError((Object)string);
            }
            ClassLoader classLoader = mainDescriptor.getPluginClassLoader();
            PluginClassLoader pluginClassLoader = classLoader instanceof PluginClassLoader ? (PluginClassLoader)((Object)classLoader) : null;
            if (pluginClassLoader == null) break block1;
            PluginClassLoader it = pluginClassLoader;
            boolean bl3 = false;
            this.mainToClassPath.put(pluginId, new MainPluginDescriptorClassPathInfo(it));
        }
        return this.configureModule(subDescriptor);
    }

    public final void configure() {
        for (PluginModuleDescriptor module : this.pluginSet.getEnabledModules()) {
            this.configureModule(module);
        }
    }

    public final boolean configureModule(@NotNull PluginModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.checkPackagePrefixUniqueness(module);
        PluginModuleDescriptor pluginModuleDescriptor = module;
        if (pluginModuleDescriptor instanceof PluginMainDescriptor) {
            if (((PluginMainDescriptor)module).getUseCoreClassLoader() || Intrinsics.areEqual((Object)((PluginMainDescriptor)module).getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                this.setClassLoaderForModuleAndDependsSubDescriptors(module, this.coreLoader);
            } else {
                this.configureMainPluginModule((PluginMainDescriptor)module);
            }
            return true;
        }
        if (pluginModuleDescriptor instanceof ContentModuleDescriptor) {
            return this.configureContentModule((ContentModuleDescriptor)module);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean configureContentModule(ContentModuleDescriptor module) {
        PluginModuleDescriptor missingDependency;
        PluginModuleDescriptor[] dependencies;
        block12: {
            PluginModuleDescriptor pluginModuleDescriptor;
            if (module.getPackagePrefix() == null && !Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID) && module.getJarFiles() == null && module.moduleLoadingRule != ModuleLoadingRule.EMBEDDED) {
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            boolean bl = module.getDependencies().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureContentModule$22 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureContentModule$22 = "Module " + module + " shouldn't have plugin dependencies: " + module.getDependencies();
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureContentModule$22);
            }
            PluginModuleDescriptor[] pluginModuleDescriptorArray = dependencies = this.getSortedDependencies(module);
            int n = pluginModuleDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                PluginModuleDescriptor pluginModuleDescriptor2;
                PluginModuleDescriptor it = pluginModuleDescriptor2 = pluginModuleDescriptorArray[i];
                boolean bl2 = false;
                if (!(it.getPluginClassLoader() == null)) continue;
                pluginModuleDescriptor = pluginModuleDescriptor2;
                break block12;
            }
            pluginModuleDescriptor = missingDependency = null;
        }
        if (missingDependency != null) {
            ClassLoaderConfiguratorKt.access$getLOG().warn("content module's dependency's classloader is not configured:\ncontent module = " + module + "\ndependency module = " + missingDependency);
            return false;
        }
        if (module.getUseCoreClassLoader()) {
            module.setPluginClassLoader(this.coreLoader);
            return true;
        }
        if (Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
            if (module.moduleLoadingRule == ModuleLoadingRule.EMBEDDED) {
                module.setPluginClassLoader(this.coreLoader);
            } else {
                this.configureCorePluginContentModuleClassLoader(module, dependencies);
            }
            return true;
        }
        MainPluginDescriptorClassPathInfo mainPluginDescriptorClassPathInfo = this.mainToClassPath.get(module.getPluginId());
        if (mainPluginDescriptorClassPathInfo == null) {
            ClassLoaderConfigurator $this$configureContentModule_u24lambda_u242 = this;
            boolean bl = false;
            mainPluginDescriptorClassPathInfo = $this$configureContentModule_u24lambda_u242.configureMainPluginModule(IdeaPluginDescriptorImplKt.getMainDescriptor(module));
        }
        MainPluginDescriptorClassPathInfo mainInfo = mainPluginDescriptorClassPathInfo;
        if (module.moduleLoadingRule == ModuleLoadingRule.EMBEDDED) {
            module.setPluginClassLoader(mainInfo.mainClassLoader);
            return true;
        }
        List<Path> customJarFiles = module.getJarFiles();
        if (customJarFiles == null) {
            module.setPluginClassLoader((ClassLoader)((Object)new PluginClassLoader(mainInfo.classPath, dependencies, (PluginDescriptor)module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.getPackagePrefix(), mainInfo.libDirectories)));
        } else {
            boolean mimicJarUrlConnection = Intrinsics.areEqual((Object)module.getVendor(), (Object)"JetBrains") && (Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.android.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.efCore.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.for.tea.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.fsharp.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.godot.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.unity.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.plugins.unreal.link.test.cases") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.test.cases.qodana") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.test.cases.consoles") || Intrinsics.areEqual((Object)module.moduleId.getName(), (Object)"intellij.rider.test.cases.rdct"));
            module.setPluginClassLoader((ClassLoader)((Object)new PluginClassLoader(new ClassPath((Collection)customJarFiles, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection), dependencies, (PluginDescriptor)module, this.coreLoader, null, null, mainInfo.libDirectories)));
        }
        return true;
    }

    private final PluginModuleDescriptor[] getSortedDependencies(PluginModuleDescriptor module) {
        List list;
        List dependenciesList = this.pluginSet.getSortedDependencies$intellij_platform_core_impl(module);
        List mutableDependenciesList = null;
        if (module instanceof PluginMainDescriptor) {
            for (ContentModuleDescriptor module2 : ((PluginMainDescriptor)module).getContentModules()) {
                if (module2.moduleLoadingRule != ModuleLoadingRule.EMBEDDED) continue;
                if (mutableDependenciesList == null) {
                    mutableDependenciesList = CollectionsKt.toMutableList((Collection)dependenciesList);
                }
                mutableDependenciesList.addAll((Collection)this.pluginSet.getSortedDependencies$intellij_platform_core_impl(module2));
            }
        }
        if ((list = mutableDependenciesList) == null) {
            list = dependenciesList;
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PluginModuleDescriptor[] dependencies = thisCollection$iv.toArray(new PluginModuleDescriptor[0]);
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        return dependencies;
    }

    private final MainPluginDescriptorClassPathInfo configureMainPluginModule(PluginMainDescriptor mainDescriptor) {
        ClassLoader classLoader;
        MainPluginDescriptorClassPathInfo exisingMainInfo = this.mainToClassPath.get(mainDescriptor.getPluginId());
        if (exisingMainInfo != null) {
            return exisingMainInfo;
        }
        List mainModuleFiles = mainDescriptor.getJarFiles();
        if (mainModuleFiles == null) {
            if (!mainDescriptor.getUseIdeaClassLoader()) {
                ClassLoaderConfiguratorKt.access$getLOG().error("jarFiles is not set for " + mainDescriptor);
            }
            mainModuleFiles = CollectionsKt.emptyList();
        }
        Set allFiles = null;
        for (ContentModuleDescriptor contentModule : mainDescriptor.getContentModules()) {
            List<Path> customJarFiles;
            if (contentModule.moduleLoadingRule != ModuleLoadingRule.EMBEDDED || (customJarFiles = contentModule.getJarFiles()) == null) continue;
            if (allFiles == null) {
                allFiles = new LinkedHashSet(mainModuleFiles);
            }
            allFiles.addAll((Collection)customJarFiles);
        }
        List<Object> libDirectories = Collections.emptyList();
        Path libDir = mainDescriptor.getPluginPath().resolve("lib");
        if (Files.exists(libDir, new LinkOption[0])) {
            libDirectories = Collections.singletonList(libDir);
        }
        boolean mimicJarUrlConnection = !mainDescriptor.isBundled() && !Intrinsics.areEqual((Object)mainDescriptor.getVendor(), (Object)"JetBrains");
        Collection collection = allFiles;
        if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = mainModuleFiles;
        }
        Collection files = collection;
        ClassPath pluginClassPath = new ClassPath(files, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
        if (mainDescriptor.getUseIdeaClassLoader()) {
            classLoader = ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader((List)files, mainDescriptor);
        } else {
            PluginModuleDescriptor[] pluginModuleDescriptorArray = this.getSortedDependencies(mainDescriptor);
            List<Object> list = libDirectories;
            Intrinsics.checkNotNull(list);
            classLoader = (ClassLoader)((Object)this.createPluginClassLoader(mainDescriptor, pluginModuleDescriptorArray, pluginClassPath, list));
        }
        ClassLoader mainClassLoader = classLoader;
        List<Object> list = libDirectories;
        Intrinsics.checkNotNull(list);
        MainPluginDescriptorClassPathInfo mainInfo = new MainPluginDescriptorClassPathInfo(pluginClassPath, list, mainClassLoader);
        this.mainToClassPath.put(mainDescriptor.getPluginId(), mainInfo);
        this.setClassLoaderForModuleAndDependsSubDescriptors(mainDescriptor, mainClassLoader);
        return mainInfo;
    }

    private final void setClassLoaderForModuleAndDependsSubDescriptors(IdeaPluginDescriptorImpl module, ClassLoader mainClassLoader) {
        module.setPluginClassLoader(mainClassLoader);
        for (PluginDependency dependency : module.getDependencies()) {
            DependsSubDescriptor subDescriptor;
            PluginModuleDescriptor pluginModuleDescriptor;
            if (dependency.getSubDescriptor() == null) continue;
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                PluginModuleDescriptor pluginModuleDescriptor2;
                PluginModuleDescriptor it = pluginModuleDescriptor2;
                boolean bl = false;
                pluginModuleDescriptor = it != module ? pluginModuleDescriptor2 : null;
            } else {
                pluginModuleDescriptor = null;
            }
            if (pluginModuleDescriptor == null) continue;
            PluginId pluginId = module.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            if (!KotlinK2ModeCompatibilityCheckerKt.isKotlinPlugin(pluginId) && KotlinK2ModeCompatibilityCheckerKt.isKotlinPlugin(dependency.getPluginId()) && KotlinK2ModeCompatibilityCheckerKt.isIncompatibleWithKotlinPlugin(module)) {
                ClassLoaderConfiguratorKt.access$getLOG().error("unexpected condition " + module);
                continue;
            }
            this.setClassLoaderForModuleAndDependsSubDescriptors(subDescriptor, mainClassLoader);
        }
    }

    private final void configureCorePluginContentModuleClassLoader(ContentModuleDescriptor module, PluginModuleDescriptor[] deps) {
        List<Path> jarFiles = module.getJarFiles();
        if (jarFiles != null) {
            ClassPath classPath = new ClassPath((Collection)jarFiles, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, false);
            PluginDescriptor pluginDescriptor = (PluginDescriptor)module;
            ClassLoader classLoader = module.isIndependentFromCoreClassLoader() ? this.coreLoader.getParent() : this.coreLoader;
            Intrinsics.checkNotNull((Object)classLoader);
            module.setPluginClassLoader((ClassLoader)((Object)new PluginClassLoader(classPath, deps, pluginDescriptor, classLoader, null, module.getPackagePrefix(), new ArrayList())));
            return;
        }
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible();
        if (coreUrlClassLoader == null) {
            boolean bl = module.getDependencies().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            module.setPluginClassLoader(this.coreLoader);
            return;
        }
        ClassPath classPath = coreUrlClassLoader.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"getClassPath(...)");
        module.setPluginClassLoader((ClassLoader)((Object)new PluginClassLoader(classPath, deps, (PluginDescriptor)module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.getPackagePrefix(), new ArrayList())));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible() {
        ClassLoader classLoader = this.coreLoader;
        UrlClassLoader urlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        if (urlClassLoader == null) {
            return null;
        }
        UrlClassLoader coreUrlClassLoader = urlClassLoader;
        if (coreUrlClassLoader.resolveScopeManager == null) {
            PluginMainDescriptor corePlugin = (PluginMainDescriptor)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = (arg_0, arg_1) -> ClassLoaderConfigurator.getCoreUrlClassLoaderIfPossible$lambda$0(resolveScopeManager, arg_0, arg_1);
            }
        }
        return coreUrlClassLoader;
    }

    private final void checkPackagePrefixUniqueness(PluginModuleDescriptor module) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module.getPackagePrefix();
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module)) != null) {
            throw new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module + ", first=" + old + ')', module.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(PluginMainDescriptor module, PluginModuleDescriptor[] dependencies, ClassPath classPath, List<? extends Path> libDirectories) {
        ResolveScopeManager resolveScopeManager = Intrinsics.areEqual((Object)module.getPluginId().getIdString(), (Object)"com.intellij.diagram") ? ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.diagram.") : ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(module, this.pluginSet);
        return new PluginClassLoader(classPath, dependencies, (PluginDescriptor)module, this.coreLoader, resolveScopeManager, module.getPackagePrefix(), libDirectories);
    }

    private static final String getCoreUrlClassLoaderIfPossible$lambda$0(ResolveScopeManager $resolveScopeManager, String name, Boolean force) {
        Intrinsics.checkNotNull((Object)name);
        Intrinsics.checkNotNull((Object)force);
        return $resolveScopeManager.isDefinitelyAlienClass(name, "", force);
    }
}

