/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 K2\u00020\u0001:\u0004HIJKB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010\u001f\u001a\u00020\u0019H\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020 H\u0014J\b\u00103\u001a\u00020\u0019H\u0015J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u001b\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J\n\u00108\u001a\u0004\u0018\u000105H\u0002J\u001a\u00109\u001a\u0004\u0018\u0001052\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\n\u0010=\u001a\u0004\u0018\u000105H\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0005H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010?2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0005H\u0002J\n\u0010B\u001a\u0004\u0018\u00010?H\u0002J\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020DJ\b\u0010G\u001a\u00020\u0019H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00058\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u0011\u0010#\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R(\u0010-\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006L"}, d2={"Lcom/intellij/diff/merge/TextMergeChange;", "Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "index", "", "isImportChange", "", "fragment", "Lcom/intellij/diff/fragments/MergeLineFragment;", "conflictType", "Lcom/intellij/diff/util/MergeConflictType;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(IZLcom/intellij/diff/fragments/MergeLineFragment;Lcom/intellij/diff/util/MergeConflictType;Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "getIndex", "()I", "()Z", "getFragment", "()Lcom/intellij/diff/fragments/MergeLineFragment;", "resolved", "", "value", "isOnesideAppliedConflict", "isResolvedWithAI", "reinstallHighlighters", "", "setResolved", "side", "Lcom/intellij/diff/util/Side;", "isResolved", "markOnesideAppliedConflict", "markChangeResolvedWithAI", "Lcom/intellij/diff/util/ThreeSide;", "resultStartLine", "getResultStartLine", "resultEndLine", "getResultEndLine", "getStartLine", "getEndLine", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "getInnerFragments", "()Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "setInnerFragments", "(Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;)V", "installOperations", "createOperation", "Lcom/intellij/diff/util/DiffGutterOperation;", "builder", "Lcom/intellij/diff/util/DiffGutterOperation$ModifiersRendererBuilder;", "createResolveOperation", "createAcceptOperation", "versionSide", "type", "Lcom/intellij/diff/merge/TextMergeChange$OperationType;", "createResetOperation", "createApplyRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "modifier", "createIgnoreRenderer", "createResolveRenderer", "storeState", "Lcom/intellij/diff/merge/TextMergeChange$State;", "restoreState", "state", "resetState", "OperationType", "State", "AIResolvedDiffType", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class TextMergeChange
extends ThreesideDiffChangeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int index;
    private final boolean isImportChange;
    @NotNull
    private final MergeLineFragment fragment;
    @NotNull
    private final MergeThreesideViewer viewer;
    @NotNull
    private final boolean[] resolved;
    private boolean isOnesideAppliedConflict;
    private boolean isResolvedWithAI;
    @Nullable
    private MergeInnerDifferences innerFragments;
    @NotNull
    private static final JBColor AI_COLOR = new JBColor(8605168, 10842598);

    @RequiresEdt
    public TextMergeChange(int index, boolean isImportChange, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)conflictType, (String)"conflictType");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(conflictType);
        this.index = index;
        this.isImportChange = isImportChange;
        this.fragment = fragment;
        this.viewer = viewer;
        this.resolved = new boolean[2];
        this.reinstallHighlighters();
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean isImportChange() {
        return this.isImportChange;
    }

    @NotNull
    public final MergeLineFragment getFragment() {
        return this.fragment;
    }

    public final boolean isOnesideAppliedConflict() {
        return this.isOnesideAppliedConflict;
    }

    @ApiStatus.Internal
    public final boolean isResolvedWithAI() {
        return this.isResolvedWithAI;
    }

    @RequiresEdt
    public final void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.viewer.repaintDividers();
    }

    @RequiresEdt
    public final void setResolved(@NotNull Side side, boolean value) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.resolved[side.getIndex()] = value;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx documentEx = this.viewer.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            for (RangeHighlighter highlighter : this.innerHighlighters) {
                if (!Intrinsics.areEqual((Object)document, (Object)highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public final boolean isResolved() {
        return this.resolved[0] && this.resolved[1];
    }

    public final boolean isResolved(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.resolved);
    }

    public final void markOnesideAppliedConflict() {
        this.isOnesideAppliedConflict = true;
    }

    @ApiStatus.Internal
    public final void markChangeResolvedWithAI() {
        this.isResolvedWithAI = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.isResolved(Side.LEFT);
            case 2 -> this.isResolved();
            case 3 -> this.isResolved(Side.RIGHT);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final int getResultStartLine() {
        return this.viewer.getModel().getLineStart(this.index);
    }

    public final int getResultEndLine() {
        return this.viewer.getModel().getLineEnd(this.index);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == ThreeSide.BASE) {
            return this.getResultStartLine();
        }
        return this.fragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == ThreeSide.BASE) {
            return this.getResultEndLine();
        }
        return this.fragment.getEndLine(side);
    }

    @Override
    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType baseType = super.getDiffType();
        if (!this.isResolvedWithAI) {
            return baseType;
        }
        return new AIResolvedDiffType(baseType);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return (Editor)editorEx;
    }

    @Override
    @Nullable
    public MergeInnerDifferences getInnerFragments() {
        return this.innerFragments;
    }

    @RequiresEdt
    public void setInnerFragments(@Nullable MergeInnerDifferences innerFragments) {
        if (this.innerFragments == null && innerFragments == null) {
            return;
        }
        this.innerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    @RequiresEdt
    protected void installOperations() {
        if (this.viewer.isExternalOperationInProgress()) {
            return;
        }
        Object[] objectArray = new DiffGutterOperation[]{this.createResolveOperation(), this.createAcceptOperation(Side.LEFT, OperationType.APPLY), this.createAcceptOperation(Side.LEFT, OperationType.IGNORE), this.createAcceptOperation(Side.RIGHT, OperationType.APPLY), this.createAcceptOperation(Side.RIGHT, OperationType.IGNORE), this.createResetOperation()};
        UtilKt.addAllIfNotNull((List)this.operations, (Object[])objectArray);
    }

    private final DiffGutterOperation createOperation(ThreeSide side, DiffGutterOperation.ModifiersRendererBuilder builder) {
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getStartLine(side));
        return new DiffGutterOperation.WithModifiers((Editor)editor, offset, this.viewer.getModifierProvider(), builder);
    }

    private final DiffGutterOperation createResolveOperation() {
        return this.createOperation(ThreeSide.BASE, (arg_0, arg_1, arg_2) -> TextMergeChange.createResolveOperation$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final DiffGutterOperation createAcceptOperation(Side versionSide, OperationType type) {
        ThreeSide side = (ThreeSide)versionSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return this.createOperation(side, (arg_0, arg_1, arg_2) -> TextMergeChange.createAcceptOperation$lambda$0(this, versionSide, type, arg_0, arg_1, arg_2));
    }

    private final DiffGutterOperation createResetOperation() {
        if (!this.isResolved() || !this.isResolvedWithAI) {
            return null;
        }
        EditorEx editorEx = this.viewer.getEditor(ThreeSide.BASE);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getStartLine(ThreeSide.BASE));
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> TextMergeChange.createResetOperation$lambda$0(this));
    }

    private final GutterIconRenderer createApplyRenderer(Side side, boolean modifier) {
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon = this.isOnesideAppliedConflict ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TextMergeChange.Companion.createIconRenderer(string, icon2, this.isConflict(), () -> TextMergeChange.createApplyRenderer$lambda$0(this, side, modifier));
    }

    private final GutterIconRenderer createIgnoreRenderer(Side side, boolean modifier) {
        if (this.isResolved(side)) {
            return null;
        }
        String string = DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remove");
        return TextMergeChange.Companion.createIconRenderer(string, icon, this.isConflict(), () -> TextMergeChange.createIgnoreRenderer$lambda$0(this, side, modifier));
    }

    private final GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.viewer.canResolveChangeAutomatically(this, ThreeSide.BASE)) {
            return null;
        }
        String string = DiffBundle.message((String)"action.presentation.merge.resolve.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.MagicResolve;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MagicResolve");
        return TextMergeChange.Companion.createIconRenderer(string, icon, false, () -> TextMergeChange.createResolveRenderer$lambda$0(this));
    }

    @NotNull
    public final State storeState() {
        return new State(this.index, this.getResultStartLine(), this.getResultEndLine(), this.resolved[0], this.resolved[1], this.isOnesideAppliedConflict, this.isResolvedWithAI);
    }

    public final void restoreState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.resolved[0] = state.getResolved1();
        this.resolved[1] = state.getResolved2();
        this.isOnesideAppliedConflict = state.getOnesideAppliedConflict();
        this.isResolvedWithAI = state.isResolvedByAI();
    }

    @ApiStatus.Internal
    public final void resetState() {
        this.resolved[0] = false;
        this.resolved[1] = false;
        this.isOnesideAppliedConflict = false;
        this.isResolvedWithAI = false;
    }

    private static final GutterIconRenderer createResolveOperation$lambda$0(TextMergeChange this$0, boolean bl, boolean bl2, boolean bl3) {
        return this$0.createResolveRenderer();
    }

    private static final GutterIconRenderer createAcceptOperation$lambda$0(TextMergeChange this$0, Side $versionSide, OperationType $type, boolean ctrlPressed, boolean bl, boolean bl2) {
        if (!this$0.isChange($versionSide)) {
            return null;
        }
        if ($type == OperationType.APPLY) {
            return this$0.createApplyRenderer($versionSide, ctrlPressed);
        }
        return this$0.createIgnoreRenderer($versionSide, ctrlPressed);
    }

    private static final void createResetOperation$lambda$0$0$0(TextMergeChange this$0) {
        this$0.viewer.resetResolvedChange(this$0);
    }

    private static final void createResetOperation$lambda$0$0(TextMergeChange this$0) {
        Object[] objectArray = new TextMergeChange[]{this$0};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.reset.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> TextMergeChange.createResetOperation$lambda$0$0$0(this$0));
    }

    private static final GutterIconRenderer createResetOperation$lambda$0(TextMergeChange this$0) {
        String string = DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.Revert;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Revert");
        return TextMergeChange.Companion.createIconRenderer(string, icon, false, () -> TextMergeChange.createResetOperation$lambda$0$0(this$0));
    }

    private static final void createApplyRenderer$lambda$0$0(TextMergeChange this$0, Side $side, boolean $modifier) {
        this$0.viewer.replaceSingleChange(this$0, $side, $modifier);
    }

    private static final void createApplyRenderer$lambda$0(TextMergeChange this$0, Side $side, boolean $modifier) {
        Object[] objectArray = new TextMergeChange[]{this$0};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> TextMergeChange.createApplyRenderer$lambda$0$0(this$0, $side, $modifier));
    }

    private static final void createIgnoreRenderer$lambda$0$0(TextMergeChange this$0, Side $side, boolean $modifier) {
        this$0.viewer.ignoreChange(this$0, $side, $modifier);
    }

    private static final void createIgnoreRenderer$lambda$0(TextMergeChange this$0, Side $side, boolean $modifier) {
        Object[] objectArray = new TextMergeChange[]{this$0};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> TextMergeChange.createIgnoreRenderer$lambda$0$0(this$0, $side, $modifier));
    }

    private static final void createResolveRenderer$lambda$0$0(TextMergeChange this$0) {
        this$0.viewer.resolveSingleChangeAutomatically(this$0, ThreeSide.BASE);
    }

    private static final void createResolveRenderer$lambda$0(TextMergeChange this$0) {
        Object[] objectArray = new TextMergeChange[]{this$0};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.resolve.conflict.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> TextMergeChange.createResolveRenderer$lambda$0$0(this$0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$AIResolvedDiffType;", "Lcom/intellij/diff/util/TextDiffType;", "baseType", "<init>", "(Lcom/intellij/diff/util/TextDiffType;)V", "getName", "", "getColor", "Ljava/awt/Color;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getIgnoredColor", "getMarkerColor", "intellij.platform.diff.impl"})
    private static final class AIResolvedDiffType
    implements TextDiffType {
        @NotNull
        private final TextDiffType baseType;

        public AIResolvedDiffType(@NotNull TextDiffType baseType) {
            Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
            this.baseType = baseType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.baseType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            return (Color)AI_COLOR;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.baseType.getIgnoredColor(editor);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getIgnoredColor(...)");
            return color;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.baseType.getMarkerColor(editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$Companion;", "", "<init>", "()V", "createIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "icon", "Ljavax/swing/Icon;", "ctrlClickVisible", "", "perform", "Ljava/lang/Runnable;", "AI_COLOR", "Lcom/intellij/ui/JBColor;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final GutterIconRenderer createIconRenderer(String text, Icon icon, boolean ctrlClickVisible, Runnable perform) {
            String appendix = ctrlClickVisible ? DiffBundle.message((String)"tooltip.merge.ctrl.click.to.resolve.conflict", (Object[])new Object[0]) : null;
            String string = DiffUtil.createTooltipText(text, appendix);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createTooltipText(...)");
            String tooltipText = string;
            return new DiffGutterRenderer(icon, tooltipText, perform){
                final /* synthetic */ Runnable $perform;
                {
                    this.$perform = $perform;
                    super($icon, $tooltipText);
                }

                protected void handleMouseClick() {
                    this.$perform.run();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$OperationType;", "", "<init>", "(Ljava/lang/String;I)V", "APPLY", "IGNORE", "intellij.platform.diff.impl"})
    private static final class OperationType
    extends Enum<OperationType> {
        public static final /* enum */ OperationType APPLY = new OperationType();
        public static final /* enum */ OperationType IGNORE = new OperationType();
        private static final /* synthetic */ OperationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperationType[] values() {
            return (OperationType[])$VALUES.clone();
        }

        public static OperationType valueOf(String value) {
            return Enum.valueOf(OperationType.class, value);
        }

        @NotNull
        public static EnumEntries<OperationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationTypeArray = new OperationType[]{OperationType.APPLY, OperationType.IGNORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$State;", "Lcom/intellij/diff/merge/MergeModelBase$State;", "index", "", "startLine", "endLine", "resolved1", "", "resolved2", "onesideAppliedConflict", "isResolvedByAI", "<init>", "(IIIZZZZ)V", "getResolved1", "()Z", "getResolved2", "getOnesideAppliedConflict", "intellij.platform.diff.impl"})
    public static final class State
    extends MergeModelBase.State {
        private final boolean resolved1;
        private final boolean resolved2;
        private final boolean onesideAppliedConflict;
        private final boolean isResolvedByAI;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict, boolean isResolvedByAI) {
            super(index, startLine, endLine);
            this.resolved1 = resolved1;
            this.resolved2 = resolved2;
            this.onesideAppliedConflict = onesideAppliedConflict;
            this.isResolvedByAI = isResolvedByAI;
        }

        public final boolean getResolved1() {
            return this.resolved1;
        }

        public final boolean getResolved2() {
            return this.resolved2;
        }

        public final boolean getOnesideAppliedConflict() {
            return this.onesideAppliedConflict;
        }

        public final boolean isResolvedByAI() {
            return this.isResolvedByAI;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeSide.values().length];
            try {
                nArray[ThreeSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.BASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

