/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.nls;

import com.ibm.icu.number.FormattedNumber;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.intellij.DynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class NlsMessages {
    private static final MeasureUnit[] TIME_UNITS = new MeasureUnit[]{MeasureUnit.NANOSECOND, MeasureUnit.MICROSECOND, MeasureUnit.MILLISECOND, MeasureUnit.SECOND, MeasureUnit.MINUTE, MeasureUnit.HOUR, MeasureUnit.DAY, MeasureUnit.WEEK};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 1000L, 1000L, 60L, 60L, 24L, 7L};
    private static final int[] PADDED_FORMAT = new int[]{3, 3, 3, 2, 2, 2, 1, 1};
    private static volatile CachedFormats ourFormats = null;

    @NotNull
    @Nls
    public static String formatAndList(Collection<?> list) {
        String string = NlsMessages.getFormats().andWideList.format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatNarrowAndList(Collection<?> list) {
        String string = NlsMessages.getFormats().andNarrowList.format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatOrList(Collection<?> list) {
        String string = NlsMessages.getFormats().orWideList.format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(3);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningNarrowAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatNarrowAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(4);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningOr() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatOrList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(5);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationApproximate(long duration) {
        String string = new NlsDurationFormatter().setMaxFragments(2).setNarrow(false).formatDuration(duration);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationApproximateNarrow(long duration) {
        String string = new NlsDurationFormatter().setMaxFragments(2).formatDuration(duration);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDuration(long duration) {
        String string = new NlsDurationFormatter().setNarrow(false).formatDuration(duration);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static MeasureUnit convert(@NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            NlsMessages.$$$reportNull$$$0(9);
        }
        MeasureUnit measureUnit = switch (timeUnit) {
            default -> throw new MatchException(null, null);
            case TimeUnit.NANOSECONDS -> MeasureUnit.NANOSECOND;
            case TimeUnit.MICROSECONDS -> MeasureUnit.MICROSECOND;
            case TimeUnit.MILLISECONDS -> MeasureUnit.MILLISECOND;
            case TimeUnit.SECONDS -> MeasureUnit.SECOND;
            case TimeUnit.MINUTES -> MeasureUnit.MINUTE;
            case TimeUnit.HOURS -> MeasureUnit.HOUR;
            case TimeUnit.DAYS -> MeasureUnit.DAY;
        };
        if (measureUnit == null) {
            NlsMessages.$$$reportNull$$$0(10);
        }
        return measureUnit;
    }

    @NotNull
    @Nls
    private static String formatDuration(long duration, MeasureUnit durationTimeUnit, int maxFragments, boolean narrow) {
        long multiplier;
        LongArrayList unitValues = new LongArrayList();
        IntArrayList unitIndices = new IntArrayList();
        long count = duration;
        int i = 0;
        while (TIME_UNITS[i] != durationTimeUnit) {
            if (++i != TIME_UNITS.length) continue;
            throw new IllegalArgumentException("Duration time unit doesn't exists in all time units");
        }
        int startPosition = i++;
        while (i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i])) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder != 0L || !unitValues.isEmpty()) {
                unitValues.add(0, remainder);
                unitIndices.add(0, i - 1);
            }
            ++i;
        }
        unitValues.add(0, count);
        unitIndices.add(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.getInt(maxFragments - 1);
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.getLong(maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.getLong(maxFragments);
                for (int unit = lastUnitIndex - 1; unit > startPosition; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                String string = new NlsDurationFormatter().setDurationMeasureTimeUnit(durationTimeUnit).setNarrow(narrow).setMaxFragments(maxFragments).formatDuration(duration + increment);
                if (string == null) {
                    NlsMessages.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        int finalCount = Math.min(unitValues.size(), maxFragments);
        CachedFormats formats = NlsMessages.getFormats();
        if (narrow) {
            ArrayList<String> fragments = new ArrayList<String>();
            for (i = 0; i < finalCount; ++i) {
                fragments.add(formats.shortNumberUnitFormatters[unitIndices.getInt(i)].format(unitValues.getLong(i)).toString().replace(' ', '\u2009'));
            }
            String string = StringUtil.join(fragments, (String)" ");
            if (string == null) {
                NlsMessages.$$$reportNull$$$0(12);
            }
            return string;
        }
        MeasureFormat format = formats.shortFormat;
        Measure[] measures = new Measure[finalCount];
        for (i = 0; i < finalCount; ++i) {
            measures[i] = new Measure((Number)unitValues.getLong(i), TIME_UNITS[unitIndices.getInt(i)]);
        }
        String string = format.formatMeasures(measures);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDuration(long duration, int maxFragments, boolean narrow) {
        String string = new NlsDurationFormatter().setDurationTimeUnit(TimeUnit.MILLISECONDS).setNarrow(narrow).setMaxFragments(maxFragments).formatDuration(duration);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    private static String formatDurationPaddedMeasure(long duration, @NotNull MeasureUnit measureUnit) {
        long multiplier;
        void durationTimeUnit;
        if (measureUnit == null) {
            NlsMessages.$$$reportNull$$$0(15);
        }
        long millisIn = 1L;
        int i = 0;
        while (TIME_UNITS[i] != durationTimeUnit) {
            if (++i != TIME_UNITS.length) continue;
            throw new IllegalArgumentException("Duration time unit doesn't exists in all time units");
        }
        int startPosition = ++i;
        while (i < TIME_MULTIPLIERS.length && duration >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i]))) {
            ++i;
        }
        long d = duration;
        LocalizedNumberFormatter formatter = NlsMessages.getFormats().narrowNumber;
        ArrayList<FormattedNumber> result = new ArrayList<FormattedNumber>();
        --i;
        while (i >= startPosition - 1) {
            long multiplier2 = i == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i + 1];
            long value = d / (millisIn /= multiplier2);
            d %= millisIn;
            IntegerWidth style = IntegerWidth.zeroFillTo((int)(result.isEmpty() ? 1 : PADDED_FORMAT[i]));
            LocalizedNumberFormatter unitFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)formatter.unit(TIME_UNITS[i])).integerWidth(style);
            result.add(unitFormatter.format(value));
            --i;
        }
        String string = ListFormatter.getInstance((Locale)Locale.getDefault(), (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)ListFormatter.Width.NARROW).format(result);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationPadded(long millis) {
        String string = new NlsDurationFormatter().setPadded(true).formatDuration(millis);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDateLong(Date date) {
        String string = DateFormat.getDateInstance(1, DynamicBundle.getLocale()).format(date);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static CachedFormats getFormats() {
        CachedFormats formats = ourFormats;
        Locale locale = DynamicBundle.getLocale();
        if (formats == null || formats.locale != locale) {
            ourFormats = formats = new CachedFormats(locale);
        }
        CachedFormats cachedFormats = formats;
        if (cachedFormats == null) {
            NlsMessages.$$$reportNull$$$0(19);
        }
        return cachedFormats;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 9, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/nls/NlsMessages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durationTimeUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAndList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNarrowAndList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatOrList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningAnd";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningNarrowAnd";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningOr";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationApproximate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationApproximateNarrow";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 9: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/nls/NlsMessages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPaddedMeasure";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateLong";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatDurationPaddedMeasure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 9, 15 -> new IllegalArgumentException(string);
        };
    }

    private static final class CachedFormats {
        final Locale locale;
        final MeasureFormat shortFormat;
        final LocalizedNumberFormatter narrowNumber;
        final LocalizedNumberFormatter[] shortNumberUnitFormatters;
        final ListFormatter andWideList;
        final ListFormatter andNarrowList;
        final ListFormatter orWideList;

        CachedFormats(Locale locale) {
            this.locale = locale;
            this.shortFormat = MeasureFormat.getInstance((Locale)locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
            LocalizedNumberFormatter numberFormatter = NumberFormatter.withLocale((Locale)locale);
            LocalizedNumberFormatter shortNumber = (LocalizedNumberFormatter)numberFormatter.unitWidth(NumberFormatter.UnitWidth.SHORT);
            this.shortNumberUnitFormatters = (LocalizedNumberFormatter[])ContainerUtil.map2Array((Object[])TIME_UNITS, LocalizedNumberFormatter.class, arg_0 -> ((LocalizedNumberFormatter)shortNumber).unit(arg_0));
            this.narrowNumber = (LocalizedNumberFormatter)numberFormatter.unitWidth(NumberFormatter.UnitWidth.NARROW);
            this.andWideList = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.WIDE);
            this.orWideList = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.OR, (ListFormatter.Width)ListFormatter.Width.WIDE);
            this.andNarrowList = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.NARROW);
        }
    }

    public static final class NlsDurationFormatter {
        private boolean padded = false;
        private boolean narrow = true;
        private int maxFragments = Integer.MAX_VALUE;
        @NotNull
        private MeasureUnit durationTimeUnit = MeasureUnit.MILLISECOND;

        @NotNull
        public NlsDurationFormatter setPadded(boolean padded) {
            this.padded = padded;
            NlsDurationFormatter nlsDurationFormatter = this;
            if (nlsDurationFormatter == null) {
                NlsDurationFormatter.$$$reportNull$$$0(0);
            }
            return nlsDurationFormatter;
        }

        @NotNull
        public NlsDurationFormatter setNarrow(boolean narrow) {
            this.narrow = narrow;
            NlsDurationFormatter nlsDurationFormatter = this;
            if (nlsDurationFormatter == null) {
                NlsDurationFormatter.$$$reportNull$$$0(1);
            }
            return nlsDurationFormatter;
        }

        @NotNull
        public NlsDurationFormatter setMaxFragments(int maxFragments) {
            this.maxFragments = maxFragments;
            NlsDurationFormatter nlsDurationFormatter = this;
            if (nlsDurationFormatter == null) {
                NlsDurationFormatter.$$$reportNull$$$0(2);
            }
            return nlsDurationFormatter;
        }

        @NotNull
        public NlsDurationFormatter setDurationTimeUnit(@NotNull TimeUnit durationTimeUnit) {
            if (durationTimeUnit == null) {
                NlsDurationFormatter.$$$reportNull$$$0(3);
            }
            this.durationTimeUnit = NlsMessages.convert(durationTimeUnit);
            NlsDurationFormatter nlsDurationFormatter = this;
            if (nlsDurationFormatter == null) {
                NlsDurationFormatter.$$$reportNull$$$0(4);
            }
            return nlsDurationFormatter;
        }

        @ApiStatus.Internal
        @NotNull
        public NlsDurationFormatter setDurationMeasureTimeUnit(@NotNull MeasureUnit durationTimeUnit) {
            if (durationTimeUnit == null) {
                NlsDurationFormatter.$$$reportNull$$$0(5);
            }
            if (durationTimeUnit != MeasureUnit.NANOSECOND && durationTimeUnit != MeasureUnit.MICROSECOND && durationTimeUnit != MeasureUnit.MILLISECOND && durationTimeUnit != MeasureUnit.SECOND && durationTimeUnit != MeasureUnit.MINUTE && durationTimeUnit != MeasureUnit.HOUR && durationTimeUnit != MeasureUnit.DAY) {
                throw new IllegalArgumentException("The measurement must be a measurement of time");
            }
            this.durationTimeUnit = durationTimeUnit;
            NlsDurationFormatter nlsDurationFormatter = this;
            if (nlsDurationFormatter == null) {
                NlsDurationFormatter.$$$reportNull$$$0(6);
            }
            return nlsDurationFormatter;
        }

        @NotNull
        @Nls
        public String formatDuration(long duration) {
            if (this.padded) {
                String string = NlsMessages.formatDurationPaddedMeasure(duration, this.durationTimeUnit);
                if (string == null) {
                    NlsDurationFormatter.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = NlsMessages.formatDuration(duration, this.durationTimeUnit, this.maxFragments, this.narrow);
            if (string == null) {
                NlsDurationFormatter.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/nls/NlsMessages$NlsDurationFormatter";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "durationTimeUnit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPadded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNarrow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxFragments";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/nls/NlsMessages$NlsDurationFormatter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDurationTimeUnit";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDurationMeasureTimeUnit";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatDuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDurationTimeUnit";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setDurationMeasureTimeUnit";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

