/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightDirectoryIndex<T> {
    private final Map<VirtualFile, T> myRootInfos;
    private final ConcurrentBitSet myNonInterestingIds;
    private final T myDefValue;
    private final Consumer<? super LightDirectoryIndex<T>> myInitializer;

    public LightDirectoryIndex(@NotNull Disposable parentDisposable, @NotNull T defValue, @NotNull Consumer<? super LightDirectoryIndex<T>> initializer) {
        if (parentDisposable == null) {
            LightDirectoryIndex.$$$reportNull$$$0(0);
        }
        if (defValue == null) {
            LightDirectoryIndex.$$$reportNull$$$0(1);
        }
        if (initializer == null) {
            LightDirectoryIndex.$$$reportNull$$$0(2);
        }
        this.myRootInfos = new ConcurrentHashMap<VirtualFile, T>();
        this.myNonInterestingIds = ConcurrentBitSet.create();
        this.myDefValue = defValue;
        this.myInitializer = initializer;
        this.resetIndex();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LightDirectoryIndex.this.resetIndex();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/LightDirectoryIndex$1", "fileTypesChanged"));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!LightDirectoryIndex.shouldReset(vFileEvent)) continue;
                    LightDirectoryIndex.this.resetIndex();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/LightDirectoryIndex$2", "after"));
            }
        });
    }

    private static boolean shouldReset(VFileEvent event) {
        if (event instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)event).isDirectory();
        }
        VirtualFile file = event.getFile();
        return file == null || file.isDirectory();
    }

    public void resetIndex() {
        this.myRootInfos.clear();
        this.myNonInterestingIds.clear();
        this.myInitializer.consume((Object)this);
    }

    public void putInfo(@Nullable VirtualFile file, @NotNull T value) {
        if (value == null) {
            LightDirectoryIndex.$$$reportNull$$$0(3);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return;
        }
        this.myRootInfos.put(file, value);
    }

    @NotNull
    public T getInfoForFile(@Nullable VirtualFile file) {
        if (!(file instanceof VirtualFileWithId) || !file.isValid()) {
            T t = this.myDefValue;
            if (t == null) {
                LightDirectoryIndex.$$$reportNull$$$0(4);
            }
            return t;
        }
        for (VirtualFile each = file; each != null; each = each.getParent()) {
            int id = ((VirtualFileWithId)each).getId();
            if (this.myNonInterestingIds.get(id)) continue;
            T info = this.myRootInfos.get(each);
            if (info != null) {
                T t = info;
                if (t == null) {
                    LightDirectoryIndex.$$$reportNull$$$0(5);
                }
                return t;
            }
            this.myNonInterestingIds.set(id);
        }
        T t = this.myDefValue;
        if (t == null) {
            LightDirectoryIndex.$$$reportNull$$$0(6);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/LightDirectoryIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/LightDirectoryIndex";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

