/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MainKey;
import com.intellij.credentialStore.keePass.MainKeyFileStorage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001c\u0010\u0017\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0004J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u0016H\u0002JO\u0010&\u001a\u00020\u00162\b\b\u0001\u0010'\u001a\u00020\u00192\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2%\b\u0001\u0010(\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(#\u0012\u0006\u0012\u0004\u0018\u00010\u00190)H\u0014J\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "", "file", "Ljava/nio/file/Path;", "mainKeyFile", "mainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/credentialStore/EncryptionSpec;Lkotlin/Lazy;)V", "mainKeyFileStorage", "Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;", "clear", "", "import", "fromFile", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "useExisting", "doImportOrUseExisting", "", "askAndSetMainKey", "topNote", "", "requestCurrentAndNewKeys", "contextComponent", "Ljava/awt/Component;", "doSetNewMainPassword", "current", "", "new", "createMainKey", "Lcom/intellij/credentialStore/keePass/MainKey;", "value", "", "isAutoGenerated", "requestMainPassword", "title", "ok", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "saveMainKeyToApplyNewEncryptionSpec", "setCustomMainPasswordIfNeeded", "defaultDbFile", "intellij.platform.credentialStore.impl"})
public class KeePassFileManager {
    @NotNull
    private final Path file;
    @NotNull
    private final EncryptionSpec mainKeyEncryptionSpec;
    @NotNull
    private final Lazy<SecureRandom> secureRandom;
    @NotNull
    private final MainKeyFileStorage mainKeyFileStorage;

    public KeePassFileManager(@NotNull Path file, @NotNull Path mainKeyFile, @NotNull EncryptionSpec mainKeyEncryptionSpec, @NotNull Lazy<? extends SecureRandom> secureRandom) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)mainKeyFile, (String)"mainKeyFile");
        Intrinsics.checkNotNullParameter((Object)mainKeyEncryptionSpec, (String)"mainKeyEncryptionSpec");
        Intrinsics.checkNotNullParameter(secureRandom, (String)"secureRandom");
        this.file = file;
        this.mainKeyEncryptionSpec = mainKeyEncryptionSpec;
        this.secureRandom = secureRandom;
        this.mainKeyFileStorage = new MainKeyFileStorage(mainKeyFile);
    }

    public final void clear() {
        block4: {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(this.file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return;
            }
            try {
                byte[] mainPassword = this.mainKeyFileStorage.load();
                if (mainPassword != null) {
                    KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(mainPassword));
                    KeePassCredentialStore store = new KeePassCredentialStore(this.file, this.mainKeyFileStorage, db);
                    store.clear();
                    store.save(this.mainKeyEncryptionSpec);
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof IncorrectMainPasswordException) break block4;
                Application application = ApplicationManager.getApplication();
                boolean bl = application != null ? !application.isUnitTestMode() : false;
                if (!bl) break block4;
                CredentialStoreKt.getLOG().error((Throwable)e);
            }
        }
        PathKt.delete$default((Path)this.file, (boolean)false, (int)1, null);
    }

    public final void import(@NotNull Path fromFile, @Nullable AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)fromFile, (String)"fromFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)fromFile)) {
            return;
        }
        try {
            this.doImportOrUseExisting(fromFile, event);
        }
        catch (IncorrectMainPasswordException e) {
            throw e;
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().warn((Throwable)e);
            AnActionEvent anActionEvent = event;
            CredentialStoreUiService.Companion.getInstance().showErrorMessage(anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null, CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.cannot.import", new Object[0]), CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.message", new Object[0]));
        }
    }

    public final void useExisting() throws IncorrectMainPasswordException {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (!this.doImportOrUseExisting(this.file, null)) {
                throw new IncorrectMainPasswordException(false, 1, null);
            }
        } else {
            MainKey mainKey = KeePassCredentialStoreKt.generateRandomMainKey(this.mainKeyEncryptionSpec, (SecureRandom)this.secureRandom.getValue());
            KeePassCredentialStoreKt.saveDatabase(this.file, new KeePassDatabase(null, 1, null), mainKey, this.mainKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        }
    }

    private final boolean doImportOrUseExisting(Path file, AnActionEvent event) {
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null;
        Path possibleMainKeyFile = file.getParent().resolve("c.pwd");
        Ref.ObjectRef mainPassword = new Ref.ObjectRef();
        Intrinsics.checkNotNull((Object)possibleMainKeyFile);
        mainPassword.element = new MainKeyFileStorage(possibleMainKeyFile).load();
        if (mainPassword.element != null) {
            try {
                KdbxKt.loadKdbx(file, new KdbxPassword((byte[])mainPassword.element));
            }
            catch (IncorrectMainPasswordException incorrectMainPasswordException) {
                CredentialStoreKt.getLOG().warn("On import \"" + file + "\" found existing main key file \"" + possibleMainKeyFile + "\" but key is not correct");
                mainPassword.element = null;
            }
        }
        if (mainPassword.element == null && !this.requestMainPassword(CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.request.main.title", new Object[0]), null, contextComponent, (Function1<? super byte[], String>)((Function1)arg_0 -> KeePassFileManager.doImportOrUseExisting$lambda$0(file, mainPassword, arg_0)))) {
            return false;
        }
        if (file != this.file) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(file, this.file, copyOptionArray);
        }
        Object object = mainPassword.element;
        Intrinsics.checkNotNull((Object)object);
        this.mainKeyFileStorage.save(KeePassFileManager.createMainKey$default(this, (byte[])object, false, 2, null));
        return true;
    }

    public final boolean askAndSetMainKey(@Nullable AnActionEvent event, @NlsContexts.DialogMessage @Nullable String topNote) {
        KeePassDatabase keePassDatabase;
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null;
        try {
            KeePassDatabase keePassDatabase2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                byte[] byArray = this.mainKeyFileStorage.load();
                if (byArray == null) {
                    throw new IncorrectMainPasswordException(true);
                }
                keePassDatabase2 = KdbxKt.loadKdbx(this.file, new KdbxPassword(byArray));
            } else {
                keePassDatabase2 = new KeePassDatabase(null, 1, null);
            }
            keePassDatabase = keePassDatabase2;
        }
        catch (IncorrectMainPasswordException incorrectMainPasswordException) {
            return this.requestCurrentAndNewKeys(contextComponent);
        }
        KeePassDatabase db = keePassDatabase;
        return this.requestMainPassword(CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.set.main.password", new Object[0]), topNote, contextComponent, (Function1<? super byte[], String>)((Function1)arg_0 -> KeePassFileManager.askAndSetMainKey$lambda$0(this, db, arg_0)));
    }

    public static /* synthetic */ boolean askAndSetMainKey$default(KeePassFileManager keePassFileManager, AnActionEvent anActionEvent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: askAndSetMainKey");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return keePassFileManager.askAndSetMainKey(anActionEvent, string);
    }

    protected boolean requestCurrentAndNewKeys(@Nullable Component contextComponent) {
        return CredentialStoreUiService.Companion.getInstance().showChangeMainPasswordDialog(contextComponent, (Function2<? super char[], ? super char[], Boolean>)((Function2)new Function2<char[], char[], Boolean>((Object)this){

            public final Boolean invoke(char[] p0, char[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((KeePassFileManager)this.receiver).doSetNewMainPassword(p0, p1);
            }
        }));
    }

    protected final boolean doSetNewMainPassword(@NotNull char[] current, @NotNull char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"new");
        KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(EncryptionSupportKt.toByteArrayAndClear(current)));
        KeePassCredentialStoreKt.saveDatabase(this.file, db, KeePassFileManager.createMainKey$default(this, EncryptionSupportKt.toByteArrayAndClear(cArray), false, 2, null), this.mainKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        return false;
    }

    private final MainKey createMainKey(byte[] value, boolean isAutoGenerated) {
        return new MainKey(value, isAutoGenerated, this.mainKeyEncryptionSpec);
    }

    static /* synthetic */ MainKey createMainKey$default(KeePassFileManager keePassFileManager, byte[] byArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createMainKey");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return keePassFileManager.createMainKey(byArray, bl);
    }

    protected boolean requestMainPassword(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @Nullable String topNote, @Nullable Component contextComponent, @NlsContexts.DialogMessage @NotNull Function1<? super byte[], String> ok) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(ok, (String)"ok");
        return CredentialStoreUiService.Companion.getInstance().showRequestMainPasswordDialog(title, topNote, contextComponent, ok);
    }

    public final void saveMainKeyToApplyNewEncryptionSpec() {
        byte[] byArray = this.mainKeyFileStorage.load();
        if (byArray == null) {
            return;
        }
        byte[] existing = byArray;
        this.mainKeyFileStorage.save(this.createMainKey(existing, this.mainKeyFileStorage.isAutoGenerated()));
    }

    public final void setCustomMainPasswordIfNeeded(@NotNull Path defaultDbFile) {
        Intrinsics.checkNotNullParameter((Object)defaultDbFile, (String)"defaultDbFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)defaultDbFile)) {
            return;
        }
        if (!this.mainKeyFileStorage.isAutoGenerated()) {
            return;
        }
        this.askAndSetMainKey(null, CredentialStoreBundle.INSTANCE.message("kee.pass.top.note", new Object[0]));
    }

    private static final String doImportOrUseExisting$lambda$0(Path $file, Ref.ObjectRef $mainPassword, byte[] it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            KdbxKt.loadKdbx($file, new KdbxPassword(it));
            $mainPassword.element = it;
            string = null;
        }
        catch (IncorrectMainPasswordException incorrectMainPasswordException) {
            string = CredentialStoreBundle.INSTANCE.message("dialog.message.main.password.not.correct", new Object[0]);
        }
        return string;
    }

    private static final String askAndSetMainKey$lambda$0(KeePassFileManager this$0, KeePassDatabase $db, byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KeePassCredentialStoreKt.saveDatabase(this$0.file, $db, KeePassFileManager.createMainKey$default(this$0, it, false, 2, null), this$0.mainKeyFileStorage, (SecureRandom)this$0.secureRandom.getValue());
        return null;
    }
}

