/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.plugin.ui.filters.Filter;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterProvider;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.structuralsearch.plugin.ui.filters.ScriptFilter;
import com.intellij.structuralsearch.plugin.ui.filters.ShortFilterTextProvider;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterPanel
implements FilterTable,
ShortFilterTextProvider {
    private final JPanel myFilterPanel;
    final JBListTable myFilterTable;
    final ListTableModel<Filter> myTableModel;
    @NotNull
    final Project myProject;
    private CompiledPattern myCompiledPattern;
    NamedScriptableDefinition myConstraint;
    LanguageFileType myFileType;
    final Header myHeader;
    private final ScriptFilter myScriptFilter;
    private final List<FilterAction> myFilters;
    private Runnable myConstraintChangedCallback;

    public FilterPanel(@NotNull Project project, LanguageFileType fileType, Disposable parent) {
        if (project == null) {
            FilterPanel.$$$reportNull$$$0(0);
        }
        this.myHeader = new Header();
        this.myProject = project;
        this.myFileType = fileType;
        this.myFilters = new SmartList();
        for (FilterProvider provider : FilterProvider.EP_NAME.getExtensionList()) {
            for (FilterAction filter : provider.getFilters()) {
                this.myFilters.add(filter);
                filter.setTable(this);
            }
        }
        this.myScriptFilter = new ScriptFilter();
        this.myFilters.add(this.myScriptFilter);
        this.myScriptFilter.setTable(this);
        this.myTableModel = new ListTableModel(new ColumnInfo[]{new ColumnInfo<Filter, Filter>(this, ""){

            @Nullable
            public Filter valueOf(Filter s) {
                return s;
            }
        }}, (List)new SmartList());
        this.myFilterTable = new JBListTable((JBTable)new TableView(this.myTableModel), parent){

            protected JBTableRowRenderer getRowRenderer(int row) {
                return (table, row1, selected, focused) -> ((Filter)FilterPanel.this.myTableModel.getRowValue(row1)).getRenderer();
            }

            protected JBTableRowEditor getRowEditor(int row) {
                if (!FilterPanel.this.isValid()) {
                    return null;
                }
                return (JBTableRowEditor)WriteIntentReadAction.compute(() -> ((Filter)FilterPanel.this.myTableModel.getRowValue(row)).getEditor());
            }
        };
        JBTable table = this.myFilterTable.getTable();
        table.setTableHeader(new JTableHeader());
        table.setStriped(false);
        this.myFilterPanel = ToolbarDecorator.createDecorator((JTable)table).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.RIGHT).setAddAction(button -> this.showAddFilterPopup(button.getContextComponent(), button.getPreferredPopupPoint())).setAddActionUpdater(e -> this.isValid() && ContainerUtil.exists(this.myFilters, f -> f.isAvailable())).setRemoveAction(button -> {
            this.myFilterTable.stopEditing();
            int selectedRow = this.myFilterTable.getTable().getSelectedRow();
            Filter filter = (Filter)this.myTableModel.getRowValue(selectedRow);
            if (filter instanceof FilterAction) {
                this.removeFilter((FilterAction)filter);
            }
        }).setRemoveActionUpdater(e -> this.isValid() && this.myFilterTable.getTable().getSelectedRow() != 0).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder((Border)JBUI.Borders.empty()).createPanel();
        this.myFilterPanel.setPreferredSize(new Dimension(350, 60));
    }

    @Override
    public void addFilter(FilterAction filter) {
        int index;
        JBTable table = this.myFilterTable.getTable();
        TableUtil.stopEditing((JTable)table);
        table.setRowHeight(table.getRowHeight());
        int max = this.myTableModel.getRowCount();
        for (index = 0; index < max && filter.position() >= ((Filter)this.myTableModel.getItem(index)).position(); ++index) {
        }
        if (index == 0) {
            this.myTableModel.addRow((Object)this.myHeader);
            index = 1;
        }
        this.myTableModel.insertRow(index, (Object)filter);
        table.editCellAt(index, 0);
        table.setRowSelectionInterval(index, index);
        table.setColumnSelectionInterval(0, 0);
        TableUtil.updateScroller((JTable)table);
        Component editorComponent = table.getEditorComponent();
        if (editorComponent != null) {
            table.scrollRectToVisible(editorComponent.getBounds());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComponent, true));
        }
    }

    final void initFilter(FilterAction filter, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (filter.checkApplicable(nodes, completePattern, target)) {
            if (filter.isActive() && !this.myTableModel.getItems().contains(filter)) {
                if (this.myTableModel.getRowCount() == 0) {
                    this.myTableModel.addRow((Object)this.myHeader);
                }
                this.myTableModel.addRow((Object)filter);
            }
        } else if (filter.hasFilter()) {
            filter.clearFilter();
            this.myConstraintChangedCallback.run();
        }
    }

    @Override
    public final void removeFilter(FilterAction filter) {
        int index = this.myTableModel.indexOf((Object)filter);
        if (index >= 0) {
            this.myTableModel.removeRow(index);
        }
        if (this.myTableModel.getRowCount() == 1) {
            this.myTableModel.removeRow(0);
        }
        filter.clearFilter();
        filter.reset();
        this.myConstraintChangedCallback.run();
    }

    @Override
    public NamedScriptableDefinition getVariable() {
        return this.myConstraint;
    }

    @Override
    public String getShortFilterText(NamedScriptableDefinition variable) {
        if (variable == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (FilterAction filter : this.myFilters) {
            String text = filter.getShortText(variable);
            if (text.isEmpty()) continue;
            if (!builder.isEmpty()) {
                builder.append(", ");
            }
            builder.append(text);
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public StructuralSearchProfile getProfile() {
        return StructuralSearchUtil.getProfileByFileType(this.myFileType);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FilterPanel.$$$reportNull$$$0(1);
        }
        return project;
    }

    void showAddFilterPopup(Component component, RelativePoint point) {
        this.myFilterTable.getTable().requestFocus();
        if (this.myConstraint instanceof MatchVariableConstraint) {
            DefaultActionGroup group = new DefaultActionGroup(this.myFilters);
            DataContext context = DataManager.getInstance().getDataContext(component);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(SSRBundle.message("add.filter.title", new Object[0]), (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, ActionPlaces.getPopupPlace((String)"StructuralSearchFilterPanel"));
            popup.show(point);
        } else {
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this.myScriptFilter, null, (String)"unknown", (DataContext)DataContext.EMPTY_CONTEXT);
            this.myScriptFilter.actionPerformed(event);
        }
    }

    public JComponent getComponent() {
        return this.myFilterPanel;
    }

    public void setFileType(@Nullable LanguageFileType fileType) {
        this.myFileType = fileType;
    }

    public void setCompiledPattern(@Nullable CompiledPattern compiledPattern) {
        this.myCompiledPattern = compiledPattern;
        this.showFilters();
    }

    private boolean isValid() {
        return this.myCompiledPattern != null;
    }

    public void initFilters(@NotNull NamedScriptableDefinition constraint) {
        if (constraint == null) {
            FilterPanel.$$$reportNull$$$0(2);
        }
        if (constraint == this.myConstraint) {
            return;
        }
        this.myConstraint = constraint;
        this.resetFilters();
        this.showFilters();
    }

    public boolean hasVisibleFilter() {
        return this.myTableModel.getRowCount() > 0;
    }

    private void resetFilters() {
        for (FilterAction filter : this.myFilters) {
            filter.reset();
        }
    }

    private void showFilters() {
        if (this.myConstraint == null) {
            return;
        }
        if (!this.isValid()) {
            this.myConstraint = null;
            return;
        }
        String varName = this.myConstraint.getName();
        List<PsiElement> nodes = this.myCompiledPattern.getVariableNodes(varName);
        boolean completePattern = "__context__".equals(varName);
        boolean target = this.myConstraint instanceof MatchVariableConstraint && ((MatchVariableConstraint)this.myConstraint).isPartOfSearchResults();
        this.myTableModel.setItems((List)new SmartList());
        ReadAction.run(() -> {
            for (FilterAction filter : this.myFilters) {
                this.initFilter(filter, nodes, completePattern, target);
            }
        });
        String message = this.myConstraint instanceof MatchVariableConstraint ? ("__context__".equals(varName) ? SSRBundle.message("no.filters.whole.template.label", new Object[0]) : SSRBundle.message("no.filters.for.0.label", varName)) : SSRBundle.message("no.script.for.0.label", varName);
        StatusText statusText = this.myFilterTable.getTable().getEmptyText();
        statusText.clear();
        Arrays.stream(message.split("\n")).forEach(line -> statusText.appendLine(line));
        if (this.isValid()) {
            statusText.appendLine(this.myConstraint instanceof MatchVariableConstraint ? SSRBundle.message("add.filter.label", new Object[0]) : SSRBundle.message("add.script.label", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.showAddFilterPopup((Component)this.myFilterTable.getTable(), new RelativePoint(MouseInfo.getPointerInfo().getLocation())));
        }
    }

    public void setConstraintChangedCallback(Runnable callback) {
        this.myConstraintChangedCallback = callback;
    }

    @Override
    public Runnable getConstraintChangedCallback() {
        return this.myConstraintChangedCallback;
    }

    public JBTable getTable() {
        return this.myFilterTable.getTable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/filters/FilterPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/filters/FilterPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class Header
    implements Filter {
        private final SimpleColoredComponent myLabel = new SimpleColoredComponent();

        Header() {
        }

        @Override
        public int position() {
            return 0;
        }

        public SimpleColoredComponent getRenderer() {
            this.myLabel.clear();
            String varName = FilterPanel.this.myConstraint.getName();
            this.myLabel.append("__context__".equals(varName) ? SSRBundle.message("filters.for.whole.template.title", new Object[0]) : SSRBundle.message("filters.for.0.title", varName), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return this.myLabel;
        }
    }
}

