/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.sdk.ui.evolution.tool.pip.sdk;

import com.intellij.openapi.module.Module;
import com.intellij.python.sdk.ui.evolution.sdk.EvoSdk;
import com.intellij.python.sdk.ui.evolution.sdk.EvoSdkKt;
import com.intellij.python.sdk.ui.icons.PythonSdkUIIcons;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.Result;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.sdk.impl.PythonBinaryExtKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/sdk/ui/evolution/tool/pip/sdk/VenvEvoSdkManager;", "", "<init>", "()V", "findEnvironments", "Lcom/jetbrains/python/Result;", "", "Lcom/intellij/python/sdk/ui/evolution/sdk/EvoSdk;", "Lcom/jetbrains/python/errorProcessing/PyError;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildEvoSdk", "pythonBinaryPath", "Ljava/nio/file/Path;", "intellij.python.sdk.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVenvEvoSdkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VenvEvoSdkManager.kt\ncom/intellij/python/sdk/ui/evolution/tool/pip/sdk/VenvEvoSdkManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,82:1\n1300#2,2:83\n1315#2,4:85\n1586#2:92\n1661#2,3:93\n1068#2:99\n78#3:89\n99#3,2:90\n101#3,3:96\n*S KotlinDebug\n*F\n+ 1 VenvEvoSdkManager.kt\ncom/intellij/python/sdk/ui/evolution/tool/pip/sdk/VenvEvoSdkManager\n*L\n48#1:83,2\n48#1:85,4\n57#1:92\n57#1:93,3\n58#1:99\n56#1:89\n56#1:90,2\n56#1:96,3\n*E\n"})
public final class VenvEvoSdkManager {
    @NotNull
    public static final VenvEvoSdkManager INSTANCE = new VenvEvoSdkManager();

    private VenvEvoSdkManager() {
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @Nullable
    public final Object findEnvironments(@NotNull Module module, @NotNull Continuation<? super Result<? extends List<EvoSdk>, ? extends PyError>> $completion) {
        void $this$sortedBy$iv;
        void $this$flatMapTo$iv$iv;
        Object venvRootPath;
        Object element$iv$iv;
        Map $this$associateWithTo$iv$iv;
        String string = module.getProject().getBasePath();
        Intrinsics.checkNotNull((Object)string);
        List venvRootPaths = CollectionsKt.listOf((Object)Path.of(string, new String[0]));
        Iterable $this$associateWith$iv = venvRootPaths;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Iterator<Object> iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Path path = (Path)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            FileVisitOption[] fileVisitOptionArray = new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS};
            Stream<Path> stream = Files.walk((Path)venvRootPath, 1, fileVisitOptionArray);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(...)");
            List list = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), VenvEvoSdkManager::findEnvironments$lambda$0$0), VenvEvoSdkManager::findEnvironments$lambda$0$1));
            map.put(t, list);
        }
        Map potentialPythonBinaryPaths = destination$iv$iv;
        Object $this$flatMap$iv = potentialPythonBinaryPaths;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            venvRootPath = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Path k = (Path)venvRootPath.getKey();
            List pythonBinaryPaths = (List)venvRootPath.getValue();
            Iterable $this$map$iv = pythonBinaryPaths;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(INSTANCE.buildEvoSdk((Path)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List evoSdks = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EvoSdk it = (EvoSdk)a;
                boolean bl = false;
                Comparable comparable = it.getPythonBinaryPath();
                it = (EvoSdk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getPythonBinaryPath());
            }
        }));
        return Result.Companion.success((Object)evoSdks);
    }

    @NotNull
    public final EvoSdk buildEvoSdk(@NotNull Path pythonBinaryPath) {
        Intrinsics.checkNotNullParameter((Object)pythonBinaryPath, (String)"pythonBinaryPath");
        Path sdkHome = PythonBinaryExtKt.resolvePythonHome((Path)pythonBinaryPath);
        String name = PathsKt.getName((Path)sdkHome);
        Icon icon = PythonSdkUIIcons.Tools.Pip;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Pip");
        return new EvoSdk(null, icon, name, pythonBinaryPath, null, 17, null);
    }

    private static final boolean findEnvironments$lambda$0$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final Path findEnvironments$lambda$0$1(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return EvoSdkKt.resolvePythonExecutable(it);
    }
}

