/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonFileType;
import com.intellij.json.pointer.JsonPointerResolver;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.RootJsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorage;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonPointerReferenceProvider
extends PsiReferenceProvider {
    private final boolean myIsSchemaProperty;

    public JsonPointerReferenceProvider(boolean isSchemaProperty) {
        this.myIsSchemaProperty = isSchemaProperty;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        List<String> parts2;
        List<String> parts1;
        String[] strings;
        String relativePath;
        if (element == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JsonStringLiteral)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JsonPointerReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        List fragments = ((JsonStringLiteral)element).getTextFragments();
        if (fragments.size() != 1) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JsonPointerReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Pair fragment = (Pair)fragments.get(0);
        String originalText = element.getText();
        int hash = originalText.indexOf(35);
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter((String)fragment.second);
        String id = splitter.getSchemaId();
        if (id != null) {
            if (id.startsWith("#")) {
                refs.add((PsiReference)new JsonSchemaIdReference((JsonValue)element, id));
            } else {
                this.addFileOrWebReferences(element, refs, hash, id);
            }
        }
        if (!this.myIsSchemaProperty && !StringUtil.isEmpty((String)(relativePath = JsonPointerUtil.normalizeSlashes(JsonPointerUtil.normalizeId(splitter.getRelativePath())))) && (strings = (String[])ContainerUtil.toArray(parts1 = JsonPointerUtil.split(relativePath), String[]::new)).length == (parts2 = JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(originalText.substring(hash + 1)))).size()) {
            int start = hash + 2;
            for (int i = 0; i < parts2.size(); ++i) {
                int length = parts2.get(i).length();
                if (i == parts2.size() - 1) {
                    --length;
                }
                if (length <= 0) break;
                refs.add((PsiReference)new JsonPointerReference((JsonValue)element, new TextRange(start, start + length), (id == null ? "" : id) + "#/" + StringUtil.join((String[])strings, (int)0, (int)(i + 1), (String)"/")));
                start += length + 1;
            }
        }
        PsiReference[] psiReferenceArray = refs.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
        if (psiReferenceArray == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private void addFileOrWebReferences(@NotNull PsiElement element, List<PsiReference> refs, final int hashIndex, String id) {
        if (element == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(5);
        }
        if (JsonFileResolver.isHttpPath(id)) {
            refs.add((PsiReference)new WebReference(element, new TextRange(1, hashIndex >= 0 ? hashIndex : id.length() + 1), id));
            return;
        }
        final boolean isCompletion = id.contains("IntellijIdeaRulezzz");
        ContainerUtil.addAll(refs, (Object[])new FileReferenceSet(this, id, element, 1, null, true, true, (FileType[])new JsonFileType[]{JsonFileType.INSTANCE}){

            public boolean isEmptyPathAllowed() {
                return true;
            }

            protected boolean isSoft() {
                return true;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                if (hashIndex != -1 && range.getStartOffset() >= hashIndex) {
                    return null;
                }
                if (hashIndex != -1 && range.getEndOffset() > hashIndex) {
                    range = new TextRange(range.getStartOffset(), hashIndex);
                    text = text.substring(0, text.indexOf(35));
                }
                return new FileReference(this, range, index, text){

                    protected Object createLookupItem(PsiElement candidate) {
                        return FileInfoManager.getFileLookupItem((PsiElement)candidate);
                    }

                    public Object @NotNull [] getVariants() {
                        Object[] fileVariants = super.getVariants();
                        if (!isCompletion || this.getRangeInElement().getStartOffset() != 1) {
                            if (fileVariants == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return fileVariants;
                        }
                        Object[] objectArray = ArrayUtil.mergeArrays((Object[])fileVariants, (Object[])this.collectCatalogVariants());
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return objectArray;
                    }

                    private Object @NotNull [] collectCatalogVariants() {
                        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
                        Project project = this.getElement().getProject();
                        List<JsonSchemaInfo> schemas = JsonSchemaService.Impl.get(project).getAllUserVisibleSchemas();
                        for (JsonSchemaInfo schema : schemas) {
                            LookupElementBuilder element = LookupElementBuilder.create((String)schema.getUrl(project)).withPresentableText(schema.getDescription()).withLookupString(schema.getDescription()).withIcon(AllIcons.General.Web).withTypeText(schema.getDocumentation(), true);
                            if (schema.getName() != null) {
                                element = element.withLookupString(schema.getName());
                            }
                            if (schema.getDocumentation() != null) {
                                element = element.withLookupString(schema.getDocumentation());
                            }
                            elements.add(PrioritizedLookupElement.withPriority((LookupElement)element, (double)-1.0));
                        }
                        Object[] objectArray = elements.toArray();
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return objectArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getVariants";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "collectCatalogVariants";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }
        }.getAllReferences());
    }

    @Nullable
    static PsiElement resolveForPath(PsiElement element, String text, boolean alwaysRoot) {
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter(text);
        VirtualFile schemaFile = ((PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)element.getContainingFile())).getVirtualFile();
        if (splitter.isAbsolute()) {
            assert (splitter.getSchemaId() != null);
            schemaFile = service.findSchemaFileByReference(splitter.getSchemaId(), schemaFile);
            if (schemaFile == null) {
                return null;
            }
        }
        PsiFile psiFile = element.getManager().findFile(schemaFile);
        String normalized = JsonPointerUtil.normalizeId(splitter.getRelativePath());
        if (!alwaysRoot && (StringUtil.isEmptyOrSpaces((String)normalized) || JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(normalized)).isEmpty()) || !(psiFile instanceof JsonFile)) {
            return psiFile;
        }
        List<String> chain = JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(normalized));
        JsonSchemaObject schemaObject = service.getSchemaObjectForSchemaFile(schemaFile);
        if (schemaObject == null) {
            return null;
        }
        JsonValue value = ((JsonFile)psiFile).getTopLevelValue();
        return value == null ? psiFile : new JsonPointerResolver(value, StringUtil.join(chain, (String)"/")).resolve();
    }

    @NotNull
    private static String prepare(String part) {
        String string = part.endsWith("#/") ? part : StringUtil.trimEnd((String)part, (char)'/');
        if (string == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrWebReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static final class JsonSchemaIdReference
    extends JsonSchemaBaseReference<JsonValue> {
        private final String myText;

        private JsonSchemaIdReference(JsonValue element, String text) {
            super(element, JsonSchemaIdReference.getRange(element));
            this.myText = text;
        }

        @NotNull
        private static TextRange getRange(JsonValue element) {
            TextRange range = element.getTextRange().shiftLeft(element.getTextOffset());
            return new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1);
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String id = null;
            JsonSchemaObject schemaRootOrNull = JsonSchemaObjectStorage.getInstance(((JsonValue)this.myElement).getProject()).getComputedSchemaRootOrNull(((JsonValue)this.myElement).getContainingFile().getVirtualFile());
            if (schemaRootOrNull instanceof RootJsonSchemaObject) {
                RootJsonSchemaObject rootJsonSchemaObject = (RootJsonSchemaObject)((Object)schemaRootOrNull);
                id = rootJsonSchemaObject.resolveId(this.myText);
            }
            if (id == null) {
                id = JsonCachedValues.resolveId(((JsonValue)this.myElement).getContainingFile(), this.myText);
            }
            if (id == null) {
                return null;
            }
            return JsonPointerReferenceProvider.resolveForPath(this.myElement, "#" + id, false);
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = JsonCachedValues.getAllIdsInFile(((JsonValue)this.myElement).getContainingFile()).toArray();
            if (objectArray == null) {
                JsonSchemaIdReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$JsonSchemaIdReference", "getVariants"));
        }
    }

    static final class JsonPointerReference
    extends JsonSchemaBaseReference<JsonValue> {
        private final String myFullPath;

        JsonPointerReference(JsonValue element, TextRange textRange, String curPath) {
            super(element, textRange);
            this.myFullPath = curPath;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myFullPath;
            if (string == null) {
                JsonPointerReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            return JsonPointerReferenceProvider.resolveForPath(this.myElement, this.getCanonicalText(), false);
        }

        @Override
        protected boolean isIdenticalTo(JsonSchemaBaseReference that) {
            return super.isIdenticalTo(that) && this.getRangeInElement().equals((Object)that.getRangeInElement());
        }

        public Object @NotNull [] getVariants() {
            String text = this.getCanonicalText();
            int index = text.indexOf("IntellijIdeaRulezzz");
            if (index >= 0) {
                String part = text.substring(0, index);
                text = JsonPointerReferenceProvider.prepare(part);
                String prefix = null;
                PsiElement element = JsonPointerReferenceProvider.resolveForPath(this.myElement, text, true);
                int indexOfSlash = part.lastIndexOf(47);
                if (indexOfSlash != -1 && indexOfSlash < text.length() - 1) {
                    prefix = text.substring(indexOfSlash + 1);
                    element = JsonPointerReferenceProvider.resolveForPath(this.myElement, JsonPointerReferenceProvider.prepare(text.substring(0, indexOfSlash)), true);
                }
                String finalPrefix = prefix;
                if (element instanceof JsonObject) {
                    Object[] objectArray = ((JsonObject)element).getPropertyList().stream().filter(p -> p.getValue() instanceof JsonContainer && (finalPrefix == null || p.getName().startsWith(finalPrefix))).map(p -> LookupElementBuilder.create((Object)p, (String)JsonPointerUtil.escapeForJsonPointer(p.getName())).withIcon(JsonPointerReference.getIcon(p.getValue()))).toArray();
                    if (objectArray == null) {
                        JsonPointerReference.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }
                if (element instanceof JsonArray) {
                    List list = ((JsonArray)element).getValueList();
                    LinkedList<LookupElementBuilder> values = new LinkedList<LookupElementBuilder>();
                    for (int i = 0; i < list.size(); ++i) {
                        String stringValue = String.valueOf(i);
                        if (prefix != null && !stringValue.startsWith(prefix)) continue;
                        values.add(LookupElementBuilder.create((String)stringValue).withIcon(JsonPointerReference.getIcon((JsonValue)list.get(i))));
                    }
                    Object[] objectArray = ContainerUtil.toArray(values, Object[]::new);
                    if (objectArray == null) {
                        JsonPointerReference.$$$reportNull$$$0(2);
                    }
                    return objectArray;
                }
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                JsonPointerReference.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private static Icon getIcon(JsonValue value) {
            if (value instanceof JsonObject) {
                return AllIcons.Json.Object;
            }
            if (value instanceof JsonArray) {
                return AllIcons.Json.Array;
            }
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Property);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$JsonPointerReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

