/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.nonModalWelcomeScreen.newFileDialog;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WelcomeScreenProjectProvider;
import com.intellij.platform.ide.nonModalWelcomeScreen.NonModalWelcomeScreenBundle;
import com.intellij.platform.ide.nonModalWelcomeScreen.newFileDialog.TemplateName;
import com.intellij.platform.ide.nonModalWelcomeScreen.newFileDialog.WelcomeScreenNewFileDialog;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J;\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/ide/nonModalWelcomeScreen/newFileDialog/WelcomeScreenNewFileHandler;", "", "<init>", "()V", "getDefaultProjectPath", "", "showNewFileDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "dialogTitle", "templateName", "Lcom/intellij/platform/ide/nonModalWelcomeScreen/newFileDialog/TemplateName;", "dialogBuilderBlock", "Lkotlin/Function1;", "Lcom/intellij/platform/ide/nonModalWelcomeScreen/newFileDialog/WelcomeScreenNewFileDialog$Builder;", "Lkotlin/ExtensionFunctionType;", "showDialogAndCreateFile", "dialog", "Lcom/intellij/platform/ide/nonModalWelcomeScreen/newFileDialog/WelcomeScreenNewFileDialog;", "showErrorMessage", "message", "intellij.platform.ide.nonModalWelcomeScreen"})
@ApiStatus.Internal
@ApiStatus.Experimental
@StabilityInferred(parameters=1)
public final class WelcomeScreenNewFileHandler {
    @NotNull
    public static final WelcomeScreenNewFileHandler INSTANCE = new WelcomeScreenNewFileHandler();
    public static final int $stable;

    private WelcomeScreenNewFileHandler() {
    }

    private final String getDefaultProjectPath() {
        String filePrefix = WelcomeScreenProjectProvider.Companion.getCreateNewFileProjectPrefix();
        String string = FileUtil.findSequentNonexistentFile((File)Path.of(ProjectUtil.getBaseDir(), new String[0]).toFile(), (String)filePrefix, (String)"").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public final void showNewFileDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NotNull TemplateName templateName, @NotNull Function1<? super WelcomeScreenNewFileDialog.Builder, Unit> dialogBuilderBlock) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter(dialogBuilderBlock, (String)"dialogBuilderBlock");
        WelcomeScreenNewFileDialog.Builder dialogBuilder = new WelcomeScreenNewFileDialog.Builder(project, dialogTitle);
        if (templateName instanceof TemplateName.SelectedOption) {
            dialogBuilder.setTemplateOptions(((TemplateName.SelectedOption)templateName).getOptions());
        }
        dialogBuilder.setDefaultDirectory(this.getDefaultProjectPath());
        dialogBuilderBlock.invoke((Object)dialogBuilder);
        this.showDialogAndCreateFile(dialogBuilder.build(), templateName);
    }

    public static /* synthetic */ void showNewFileDialog$default(WelcomeScreenNewFileHandler welcomeScreenNewFileHandler, Project project, String string, TemplateName templateName, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = WelcomeScreenNewFileHandler::showNewFileDialog$lambda$0;
        }
        welcomeScreenNewFileHandler.showNewFileDialog(project, string, templateName, (Function1<? super WelcomeScreenNewFileDialog.Builder, Unit>)function1);
    }

    private final void showDialogAndCreateFile(WelcomeScreenNewFileDialog dialog, TemplateName templateName) {
        if (!dialog.showAndGet()) {
            return;
        }
        PsiDirectory psiDirectory = dialog.getTargetDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        String fileName = dialog.getFileName();
        Project project = dialog.getProject$intellij_platform_ide_nonModalWelcomeScreen();
        try {
            String string;
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(fileName, directory);
            TemplateName templateName2 = templateName;
            if (templateName2 instanceof TemplateName.Static) {
                string = ((TemplateName.Static)templateName).getName();
            } else if (templateName2 instanceof TemplateName.SelectedOption) {
                string = dialog.getSelectedTemplateName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (string == null) {
                return;
            }
            String selectedTemplateName = string;
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate(selectedTemplateName);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
            FileTemplate template = fileTemplate;
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
            Properties templateProperties = properties;
            PsiFile psiFile = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)mkdirs.newName, (Properties)templateProperties, (PsiDirectory)mkdirs.directory).getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                NonProjectFileWritingAccessProvider.allowWriting((Iterable)CollectionsKt.listOf((Object)virtualFile));
                ApplicationManager.getApplication().invokeLater(() -> WelcomeScreenNewFileHandler.showDialogAndCreateFile$lambda$0(template, psiFile, project, virtualFile));
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = fileName;
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            objectArray[1] = string;
            this.showErrorMessage(project, NonModalWelcomeScreenBundle.message("welcome.screen.error.dialog.message.cannot.create.file", objectArray));
        }
    }

    private final void showErrorMessage(Project project, @NlsContexts.DialogMessage String message) {
        ApplicationManager.getApplication().invokeLater(() -> WelcomeScreenNewFileHandler.showErrorMessage$lambda$0(project, message));
    }

    private static final Unit showNewFileDialog$lambda$0(WelcomeScreenNewFileDialog.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final void showDialogAndCreateFile$lambda$0(FileTemplate $template, PsiFile $psiFile, Project $project, VirtualFile $virtualFile) {
        if ($template.isLiveTemplateEnabled()) {
            CreateFromTemplateManager.startLiveTemplate((PsiFile)$psiFile, (Map)MapsKt.emptyMap());
        } else {
            FileEditorManager.getInstance((Project)$project).openFile($virtualFile, true);
        }
    }

    private static final void showErrorMessage$lambda$0(Project $project, String $message) {
        Messages.showMessageDialog((Project)$project, (String)$message, (String)NonModalWelcomeScreenBundle.message("welcome.screen.error.dialog.title.cannot.create.file", new Object[0]), (Icon)Messages.getErrorIcon());
    }
}

