/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ScreenUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MouseMovementTracker {
    private static final int HISTORY_SIZE = 4;
    private static final int MOVEMENT_MARGIN_PX = 2;
    private final Point[] myHistory = new Point[4];
    private int myCurrentIndex;

    public void reset() {
        Arrays.fill(this.myHistory, null);
    }

    public boolean isMovingTowards(@NotNull MouseEvent me, @Nullable Rectangle rectangleOnScreen) {
        Point prevHistory;
        if (me == null) {
            MouseMovementTracker.$$$reportNull$$$0(0);
        }
        Point currentLocation = me.getLocationOnScreen();
        Point previousLocation = null;
        for (int i = 0; i < 4; ++i) {
            Point p = this.myHistory[(this.myCurrentIndex - i + 4) % 4];
            if (p == null || !(p.distance(currentLocation) >= 2.0)) continue;
            previousLocation = p;
            break;
        }
        if ((prevHistory = this.myHistory[this.myCurrentIndex % 4]) == null || currentLocation.distance(prevHistory) >= 2.0) {
            this.myCurrentIndex = (this.myCurrentIndex + 1) % 4;
            this.myHistory[this.myCurrentIndex] = currentLocation;
        }
        return ScreenUtil.isMovementTowards(previousLocation, currentLocation, rectangleOnScreen);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ui/MouseMovementTracker", "isMovingTowards"));
    }
}

