/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorIcon
extends EmptyIcon {
    private final Color myColor;
    @Nullable
    private final Color myBorderColor;
    private final int myColorWidth;
    private final int myColorHeight;
    private final int myArc;

    public ColorIcon(int width, int height, int colorWidth, int colorHeight, @NotNull Color color, @Nullable Color borderColor, int arc) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(0);
        }
        super(width, height);
        this.myColor = color;
        this.myColorWidth = colorWidth;
        this.myColorHeight = colorHeight;
        this.myBorderColor = borderColor;
        this.myArc = arc;
    }

    public ColorIcon(int width, int height, int colorWidth, int colorHeight, @NotNull Color color, boolean border, int arc) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(1);
        }
        this(width, height, colorWidth, colorHeight, color, border ? Gray.x00.withAlpha(40) : null, arc);
    }

    public ColorIcon(int width, int height, int colorWidth, int colorHeight, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(2);
        }
        this(width, height, colorWidth, colorHeight, color, border, 0);
    }

    public ColorIcon(int size, int colorSize, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(3);
        }
        this(size, size, colorSize, colorSize, color, border, 0);
    }

    public ColorIcon(int size, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(4);
        }
        this(size, size, color, border);
    }

    public ColorIcon(int size, @NotNull Color color) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(5);
        }
        this(size, color, false);
    }

    protected ColorIcon(ColorIcon icon) {
        super(icon);
        this.myColor = icon.myColor;
        this.myBorderColor = icon.myBorderColor;
        this.myColorWidth = icon.myColorWidth;
        this.myColorHeight = icon.myColorHeight;
        this.myArc = icon.myArc;
    }

    @Override
    @NotNull
    public ColorIcon copy() {
        return new ColorIcon(this);
    }

    public Color getIconColor() {
        return this.myColor;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        g.setColor(this.getIconColor());
        int width = this.getColorWidth();
        int height = this.getColorHeight();
        int arc = this.getArc();
        int x = i + (iconWidth - width) / 2;
        int y = j + (iconHeight - height) / 2;
        g.fillRoundRect(x, y, width, height, arc, arc);
        if (this.myBorderColor != null) {
            g.setColor(this.myBorderColor);
            g.drawRoundRect(x, y, width, height, arc, arc);
        }
        config.restore();
    }

    private int getColorWidth() {
        return (int)Math.ceil(this.scaleVal(this.myColorWidth));
    }

    private int getColorHeight() {
        return (int)Math.ceil(this.scaleVal(this.myColorHeight));
    }

    private int getArc() {
        return (int)Math.ceil(this.scaleVal(this.myArc));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColorIcon icon = (ColorIcon)o;
        if (!Objects.equals(this.myBorderColor, icon.myBorderColor)) {
            return false;
        }
        if (this.myColorWidth != icon.myColorWidth) {
            return false;
        }
        if (this.myColorHeight != icon.myColorHeight) {
            return false;
        }
        if (this.myArc != icon.myArc) {
            return false;
        }
        return this.myColor.equals(icon.myColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
        result = 31 * result + (this.myBorderColor != null ? this.myBorderColor.hashCode() : 0);
        result = 31 * result + this.myColorWidth;
        result = 31 * result + this.myColorHeight;
        result = 31 * result + this.myArc;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/ColorIcon", "<init>"));
    }
}

