/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getJarAttribute", "", "path", "Ljava/nio/file/Path;", "attribute", "Ljava/util/jar/Attributes$Name;", "intellij.platform.util"})
public final class NioJarUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getJarAttribute(@NotNull Path path, @NotNull Attributes.Name attribute) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        try {
            String string;
            Closeable closeable = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));
            Throwable throwable = null;
            try {
                JarInputStream jarInputStream = (JarInputStream)closeable;
                boolean bl = false;
                Cloneable cloneable = jarInputStream.getManifest();
                string = cloneable != null && (cloneable = ((Manifest)cloneable).getMainAttributes()) != null ? ((Attributes)cloneable).getValue(attribute) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

