/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.interpreters.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.community.interpreters.Interpreter;
import com.intellij.python.community.interpreters.impl.InterpreterFields;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0082\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/community/interpreters/impl/SdkMixin;", "Lcom/intellij/python/community/interpreters/impl/InterpreterFields;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "data", "Lcom/jetbrains/python/sdk/PythonSdkAdditionalData;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/jetbrains/python/sdk/PythonSdkAdditionalData;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "getReadableName", "", "Lorg/jetbrains/annotations/Nls;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "intellij.python.community.interpreters"})
public final class SdkMixin
implements InterpreterFields {
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final UUID id;

    public SdkMixin(@NotNull Sdk sdk, @NotNull PythonSdkAdditionalData data) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.sdk = sdk;
        UUID uUID = data.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.id = uUID;
    }

    @Override
    @NotNull
    public Sdk getSdk() {
        return this.sdk;
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.id;
    }

    @Nullable
    public Object getReadableName(@NotNull Continuation<? super String> $completion) {
        String string = this.getSdk().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Interpreter)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getId(), (Object)((Interpreter)other).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

