/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.mass;

import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.ide.ui.mass.Change;
import com.intellij.grazie.ide.ui.mass.ChangeType;
import com.intellij.grazie.ide.ui.mass.GrazieMassApplyDialogKt;
import com.intellij.grazie.ide.ui.mass.Highlighting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001%B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\n\u0010\u001b\u001a\u00020\u0003H\u0096\u0080\u0004J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0003H\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/grazie/ide/ui/mass/DocumentChange;", "Lcom/intellij/grazie/ide/ui/mass/Change;", "presentableText", "", "replacements", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "Lcom/intellij/openapi/editor/RangeMarker;", "originalReplacements", "getOriginalReplacements", "()Ljava/util/List;", "revertChanges", "", "Lcom/intellij/grazie/ide/ui/mass/DocumentChange$RevertChange;", "highlighting", "Lcom/intellij/grazie/ide/ui/mass/Highlighting;", "setHighlighting", "", "apply", "revert", "toString", "clear", "getChangeType", "Lcom/intellij/grazie/ide/ui/mass/ChangeType;", "marker", "text", "createRangeHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "changeType", "replacement", "RevertChange", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieMassApplyDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieMassApplyDialog.kt\ncom/intellij/grazie/ide/ui/mass/DocumentChange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,566:1\n1586#2:567\n1661#2,3:568\n1915#2,2:571\n1915#2,2:573\n1915#2,2:575\n*S KotlinDebug\n*F\n+ 1 GrazieMassApplyDialog.kt\ncom/intellij/grazie/ide/ui/mass/DocumentChange\n*L\n356#1:567\n356#1:568,3\n397#1:571,2\n368#1:573,2\n382#1:575,2\n*E\n"})
final class DocumentChange
implements Change {
    @NotNull
    private final String presentableText;
    @NotNull
    private final List<Pair<RangeMarker, String>> replacements;
    @NotNull
    private final List<Pair<TextRange, String>> originalReplacements;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final List<RevertChange> revertChanges;
    @Nullable
    private Highlighting highlighting;

    @NotNull
    public final List<Pair<TextRange, String>> getOriginalReplacements() {
        return this.originalReplacements;
    }

    /*
     * WARNING - void declaration
     */
    public DocumentChange(@NotNull String presentableText, @NotNull List<? extends Pair<? extends TextRange, String>> replacements, @NotNull Editor editor, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.revertChanges = new ArrayList();
        this.presentableText = presentableText;
        Iterable iterable = replacements;
        DocumentChange documentChange = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)editor.getDocument().createRangeMarker((TextRange)it.getFirst()), (Object)it.getSecond()));
        }
        documentChange.replacements = (List)destination$iv$iv;
        this.originalReplacements = replacements;
        this.editor = editor;
        this.project = project;
    }

    public final void setHighlighting(@NotNull Highlighting highlighting) {
        Intrinsics.checkNotNullParameter((Object)highlighting, (String)"highlighting");
        this.highlighting = highlighting;
    }

    @Override
    public void apply() {
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)GrazieBundle.message("grazie.mass.apply.text.do", new Object[0]), null, () -> DocumentChange.apply$lambda$0(this), (PsiFile[])new PsiFile[0]);
        Highlighting highlighting = this.highlighting;
        Intrinsics.checkNotNull((Object)highlighting);
        highlighting.setChange(this);
    }

    @Override
    public void revert() {
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)GrazieBundle.message("grazie.mass.apply.text.do", new Object[0]), null, () -> DocumentChange.revert$lambda$0(this), (PsiFile[])new PsiFile[0]);
        this.revertChanges.clear();
        Highlighting highlighting = this.highlighting;
        Intrinsics.checkNotNull((Object)highlighting);
        highlighting.removeChange();
    }

    @NotNull
    public String toString() {
        return this.presentableText;
    }

    public final void clear(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$forEach$iv = this.revertChanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RevertChange it = (RevertChange)element$iv;
            boolean bl = false;
            editor.getMarkupModel().removeHighlighter(it.getRange());
        }
        this.revertChanges.clear();
    }

    private final ChangeType getChangeType(RangeMarker marker, String text) {
        return marker.getTextRange().isEmpty() ? ChangeType.INSERT : (((CharSequence)text).length() == 0 ? ChangeType.DELETE : ChangeType.MODIFY);
    }

    private final RangeHighlighter createRangeHighlighter(Editor editor, ChangeType changeType, RangeMarker marker, String replacement) {
        RangeHighlighter rangeHighlighter;
        TextRange textRange = changeType == ChangeType.INSERT ? marker.getTextRange().grown(replacement.length()) : marker.getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        if (changeType == ChangeType.DELETE) {
            return GrazieMassApplyDialogKt.access$addRangeHighlighter(editor, range, GrazieMassApplyDialogKt.access$getSTRIKEOUT_TEXT_ATTRIBUTES$p());
        }
        Highlighting highlighting = this.highlighting;
        Intrinsics.checkNotNull((Object)highlighting);
        if (highlighting.getProblem().isSpellingProblem()) {
            rangeHighlighter = GrazieMassApplyDialogKt.access$createInlineHighlighter(editor, range, GrazieMassApplyDialogKt.access$getTYPO_TEXT_DIFF$p());
        } else {
            Highlighting highlighting2 = this.highlighting;
            Intrinsics.checkNotNull((Object)highlighting2);
            rangeHighlighter = highlighting2.getProblem().isStyleLike() ? GrazieMassApplyDialogKt.access$createInlineHighlighter(editor, range, GrazieMassApplyDialogKt.access$getSTYLE_TEXT_DIFF$p()) : GrazieMassApplyDialogKt.access$createInlineHighlighter(editor, range, GrazieMassApplyDialogKt.access$getGRAMMAR_TEXT_DIFF$p());
        }
        return rangeHighlighter;
    }

    private static final void apply$lambda$0(DocumentChange this$0) {
        Iterable $this$forEach$iv = CollectionsKt.asReversed(this$0.replacements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String oldText;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            RangeMarker marker = (RangeMarker)pair.component1();
            String replacement = (String)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)this$0.editor.getDocument().getText(marker.getTextRange()), (String)"getText(...)");
            ChangeType type = this$0.getChangeType(marker, replacement);
            if (type != ChangeType.DELETE) {
                this$0.editor.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)replacement);
            }
            this$0.revertChanges.add(new RevertChange(oldText, type, this$0.createRangeHighlighter(this$0.editor, type, marker, replacement)));
        }
    }

    private static final void revert$lambda$0(DocumentChange this$0) {
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable(this$0.revertChanges);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range;
            RevertChange info = (RevertChange)element$iv;
            boolean bl = false;
            this$0.editor.getMarkupModel().removeHighlighter(info.getRange());
            if (info.getType() == ChangeType.DELETE) continue;
            Intrinsics.checkNotNullExpressionValue((Object)info.getRange().getTextRange(), (String)"getTextRange(...)");
            this$0.editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)info.getOldText());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/ide/ui/mass/DocumentChange$RevertChange;", "", "oldText", "", "type", "Lcom/intellij/grazie/ide/ui/mass/ChangeType;", "range", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Ljava/lang/String;Lcom/intellij/grazie/ide/ui/mass/ChangeType;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getOldText", "()Ljava/lang/String;", "getType", "()Lcom/intellij/grazie/ide/ui/mass/ChangeType;", "getRange", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.grazie.core"})
    private static final class RevertChange {
        @NotNull
        private final String oldText;
        @NotNull
        private final ChangeType type;
        @NotNull
        private final RangeHighlighter range;

        public RevertChange(@NotNull String oldText, @NotNull ChangeType type, @NotNull RangeHighlighter range) {
            Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.oldText = oldText;
            this.type = type;
            this.range = range;
        }

        @NotNull
        public final String getOldText() {
            return this.oldText;
        }

        @NotNull
        public final ChangeType getType() {
            return this.type;
        }

        @NotNull
        public final RangeHighlighter getRange() {
            return this.range;
        }

        @NotNull
        public final String component1() {
            return this.oldText;
        }

        @NotNull
        public final ChangeType component2() {
            return this.type;
        }

        @NotNull
        public final RangeHighlighter component3() {
            return this.range;
        }

        @NotNull
        public final RevertChange copy(@NotNull String oldText, @NotNull ChangeType type, @NotNull RangeHighlighter range) {
            Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new RevertChange(oldText, type, range);
        }

        public static /* synthetic */ RevertChange copy$default(RevertChange revertChange, String string, ChangeType changeType, RangeHighlighter rangeHighlighter, int n, Object object) {
            if ((n & 1) != 0) {
                string = revertChange.oldText;
            }
            if ((n & 2) != 0) {
                changeType = revertChange.type;
            }
            if ((n & 4) != 0) {
                rangeHighlighter = revertChange.range;
            }
            return revertChange.copy(string, changeType, rangeHighlighter);
        }

        @NotNull
        public String toString() {
            return "RevertChange(oldText=" + this.oldText + ", type=" + this.type + ", range=" + this.range + ")";
        }

        public int hashCode() {
            int result = this.oldText.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.range.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RevertChange)) {
                return false;
            }
            RevertChange revertChange = (RevertChange)other;
            if (!Intrinsics.areEqual((Object)this.oldText, (Object)revertChange.oldText)) {
                return false;
            }
            if (this.type != revertChange.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)revertChange.range);
        }
    }
}

