/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.completion.PyStringFormatCompletionContributor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyLiteralPattern;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyExpectedTypeJudgement;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyFStringLikeCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final PsiElementPattern.Capture<PyPlainStringElement> APPLICABLE_STRING_ELEMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyPlainStringElement.class).withParent(PyStringLiteralExpression.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PyLiteralPattern.class))).andNot((ElementPattern)PlatformPatterns.psiElement().inside(PyStringFormatCompletionContributor.FORMAT_STRING_CAPTURE));

    public PyFStringLikeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)APPLICABLE_STRING_ELEMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean prefixCannotStartReference;
                boolean autoPopupAfterOpeningBrace;
                int stringElemStart;
                int offset;
                int relOffset;
                PyPlainStringElement stringElem;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((stringElem = PyUtil.as(parameters.getPosition(), PyPlainStringElement.class)) == null || stringElem.isBytes() || stringElem.isUnicode()) {
                    return;
                }
                if (LanguageLevel.forElement((PsiElement)stringElem).isOlderThan(LanguageLevel.PYTHON36)) {
                    return;
                }
                PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)stringElem.getParent();
                boolean templateStringExpected = PyFStringLikeCompletionContributor.isTemplateStringExpected(stringLiteral);
                if (templateStringExpected && LanguageLevel.forElement((PsiElement)stringElem).isOlderThan(LanguageLevel.PYTHON314)) {
                    return;
                }
                final String newPrefixChar = templateStringExpected ? "t" : "f";
                String stringElemText = stringElem.getText();
                int braceOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)stringElemText, (int)((relOffset = (offset = parameters.getOffset()) - (stringElemStart = stringElem.getTextRange().getStartOffset())) - 1), (String)"{");
                if (braceOffset < 0) {
                    return;
                }
                String completionPrefix = stringElemText.substring(braceOffset + 1, relOffset);
                boolean bl = autoPopupAfterOpeningBrace = completionPrefix.isEmpty() && parameters.isAutoPopup();
                if (autoPopupAfterOpeningBrace) {
                    return;
                }
                boolean bl2 = prefixCannotStartReference = !completionPrefix.isEmpty() && !PyNames.isIdentifier((String)completionPrefix);
                if (prefixCannotStartReference) {
                    return;
                }
                String fStringText = new StringBuilder().append(newPrefixChar).append(stringElemText).insert(relOffset + 1 + "IntellijIdeaRulezzz ".length(), "} ").toString();
                PyExpression fString = PyUtil.createExpressionFromFragment(fStringText, stringLiteral.getParent());
                assert (fString != null);
                PsiReference reference = fString.findReferenceAt(relOffset + 1);
                if (reference == null) {
                    return;
                }
                @NotNull List fStringVariants = ContainerUtil.mapNotNull((Object[])reference.getVariants(), v -> PyUtil.as(v, LookupElement.class));
                if (fStringVariants.isEmpty()) {
                    return;
                }
                CompletionResultSet prefixPatchedResultSet = result.withPrefixMatcher(completionPrefix);
                for (LookupElement variant : fStringVariants) {
                    prefixPatchedResultSet.addElement((LookupElement)new LookupElementDecorator<LookupElement>(variant){

                        public void handleInsert(@NotNull InsertionContext context) {
                            String stringElemPrefix;
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.handleInsert(context);
                            Document document = context.getDocument();
                            CharSequence docChars = document.getCharsSequence();
                            int tailOffset = context.getTailOffset();
                            if (tailOffset >= document.getTextLength() || docChars.charAt(tailOffset) != '}') {
                                document.insertString(tailOffset, (CharSequence)"}");
                            }
                            if (!StringUtil.containsIgnoreCase((String)(stringElemPrefix = PyStringLiteralCoreUtil.getPrefix((CharSequence)docChars, (int)stringElemStart)), (String)newPrefixChar)) {
                                document.insertString(stringElemStart, (CharSequence)newPrefixChar);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor$1$1", "handleInsert"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isTemplateStringExpected(@NotNull PyStringLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(0);
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)stringLiteral.getProject(), (PsiFile)stringLiteral.getContainingFile());
        PyPsiFacade psiFacade = PyPsiFacade.getInstance((Project)stringLiteral.getProject());
        PyClass templateClass = psiFacade.createClassByQName("string.templatelib.Template", (PsiElement)stringLiteral);
        if (templateClass == null) {
            return false;
        }
        PyClassType templateType = psiFacade.createClassType(templateClass, false);
        PyType expectedType = PyExpectedTypeJudgement.getExpectedType((PyExpression)stringLiteral, typeEvalContext);
        return templateType.equals((Object)expectedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringLiteral", "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor", "isTemplateStringExpected"));
    }
}

