/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeAssertionEvaluator
extends PyRecursiveElementVisitor {
    private final Stack<Assertion> myStack = new Stack();
    private boolean myPositive;

    public PyTypeAssertionEvaluator(boolean positive) {
        this.myPositive = positive;
    }

    List<Assertion> getDefinitions() {
        return this.myStack;
    }

    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        PyExpression[] args;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(0);
        }
        if (node.isCalleeText(new String[]{"isinstance", "assertIsInstance"})) {
            PyExpression[] args2 = node.getArguments();
            if (args2.length == 2) {
                PyExpression typeElement = args2[1];
                this.pushAssertion(args2[0], this.myPositive, context -> PyTypeAssertionEvaluator.transformTypeFromAssertion(context.getType((PyTypedElement)typeElement), false, context, typeElement));
            }
        } else if (node.isCalleeText(new String[]{"issubclass"}) && (args = node.getArguments()).length == 2) {
            PyExpression typeElement = args[1];
            this.pushAssertion(args[0], this.myPositive, context -> PyTypeAssertionEvaluator.transformTypeFromAssertion(context.getType((PyTypedElement)typeElement), true, context, typeElement));
        }
    }

    private void visitExpressionInCondition(@NotNull PyExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(1);
        }
        if (this.myPositive && PyTypeAssertionEvaluator.isReferenceInTruthyCondition(node)) {
            this.pushAssertion(node, !this.myPositive, context -> PyBuiltinCache.getInstance((PsiElement)node).getNoneType());
        }
    }

    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(2);
        }
        this.visitExpressionInCondition((PyExpression)node);
        super.visitPyReferenceExpression(node);
    }

    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(3);
        }
        this.visitExpressionInCondition((PyExpression)node);
        super.visitPyAssignmentExpression(node);
    }

    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        boolean isOrEqualsOperator;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(4);
        }
        PyExpression lhs = PyPsiUtils.flattenParens((PyExpression)node.getLeftExpression());
        PyExpression rhs = PyPsiUtils.flattenParens((PyExpression)node.getRightExpression());
        if (lhs == null || rhs == null) {
            return;
        }
        PyElementType operator = node.getOperator();
        boolean bl = isOrEqualsOperator = node.isOperator("is") || PyTokenTypes.EQEQ.equals(operator);
        if (isOrEqualsOperator || node.isOperator("isnot") || PyTokenTypes.NE.equals(operator) || PyTokenTypes.NE_OLD.equals(operator)) {
            this.setPositive(isOrEqualsOperator, () -> this.processIsOrEquals(lhs, rhs));
        }
        if (PyTokenTypes.IN_KEYWORD.equals(operator) || node.isOperator("notin")) {
            this.setPositive(PyTokenTypes.IN_KEYWORD.equals(operator), () -> this.processIn(lhs, rhs));
        }
    }

    private void processIsOrEquals(@NotNull PyExpression lhs, @NotNull PyExpression rhs) {
        Boolean leftBoolean;
        if (lhs == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(5);
        }
        if (rhs == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(6);
        }
        if ((leftBoolean = PyEvaluator.evaluateNoResolve(lhs, Boolean.class)) != null) {
            this.setPositive(leftBoolean, () -> rhs.accept((PsiElementVisitor)this));
            return;
        }
        Boolean rightBoolean = PyEvaluator.evaluateNoResolve(rhs, Boolean.class);
        if (rightBoolean != null) {
            this.setPositive(rightBoolean, () -> lhs.accept((PsiElementVisitor)this));
            return;
        }
        if (PyLiteralType.isNone(lhs)) {
            this.pushAssertion(rhs, this.myPositive, context -> PyBuiltinCache.getInstance((PsiElement)rhs).getNoneType());
            return;
        }
        if (PyLiteralType.isNone(rhs)) {
            this.pushAssertion(lhs, this.myPositive, context -> PyBuiltinCache.getInstance((PsiElement)lhs).getNoneType());
            return;
        }
        this.pushAssertion(lhs, this.myPositive, context -> PyTypeAssertionEvaluator.getLiteralType(rhs, context));
    }

    private void processIn(@NotNull PyExpression lhs, @NotNull PyExpression rhs) {
        if (lhs == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(7);
        }
        if (rhs == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(8);
        }
        if (rhs instanceof PyTupleExpression || rhs instanceof PyListLiteralExpression || rhs instanceof PySetLiteralExpression) {
            this.pushAssertion(lhs, this.myPositive, context -> {
                PyExpression[] elements = ((PySequenceExpression)rhs).getElements();
                ArrayList<PyType> types = new ArrayList<PyType>(elements.length);
                for (PyExpression element : elements) {
                    PyClassType type;
                    Object object = type = PyLiteralType.isNone(element) ? PyBuiltinCache.getInstance((PsiElement)element).getNoneType() : PyTypeAssertionEvaluator.getLiteralType(element, context);
                    if (type == null) {
                        return null;
                    }
                    types.add((PyType)type);
                }
                return PyUnionType.union(types);
            });
        }
    }

    @Nullable
    private static PyType getLiteralType(@NotNull PyExpression element, @NotNull TypeEvalContext context) {
        PyType type;
        if (element == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(10);
        }
        if ((type = PyLiteralType.getLiteralType(element, context)) == null) {
            type = context.getType((PyTypedElement)element);
        }
        return PyTypeUtil.toStream(type).allMatch(subtype -> subtype instanceof PyLiteralType) ? type : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPositive(boolean positive, @NotNull Runnable runnable) {
        if (runnable == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(11);
        }
        boolean oldPositive = this.myPositive;
        if (!positive) {
            this.myPositive = !this.myPositive;
        }
        try {
            runnable.run();
        }
        finally {
            this.myPositive = oldPositive;
        }
    }

    public void visitPyCaseClause(@NotNull PyCaseClause node) {
        PyPattern pattern;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(12);
        }
        if ((pattern = node.getPattern()) == null) {
            return;
        }
        PsiElement psiElement = node.getParent();
        if (psiElement instanceof PyMatchStatement) {
            PyMatchStatement matchStatement = (PyMatchStatement)psiElement;
            this.pushAssertion(matchStatement.getSubject(), this.myPositive, context -> context.getType((PyTypedElement)pattern));
        }
    }

    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        if (matchStatement == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(13);
        }
        assert (!this.myPositive);
        PyExpression subject = matchStatement.getSubject();
        if (subject == null) {
            return;
        }
        this.pushAssertion(subject, true, true, true, context -> {
            PyType subjectType = context.getType((PyTypedElement)subject);
            for (PyCaseClause cs : matchStatement.getCaseClauses()) {
                if (cs.getPattern() == null || cs.getGuardCondition() != null) continue;
                if (cs.getPattern().isIrrefutable()) {
                    subjectType = PyNeverType.NEVER;
                    break;
                }
                subjectType = (PyType)Ref.deref(PyTypeAssertionEvaluator.createAssertionType(subjectType, context.getType((PyTypedElement)cs.getPattern()), false, true, context));
            }
            return subjectType;
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    @Nullable
    public static Ref<PyType> createAssertionType(@Nullable PyType initial, @Nullable PyType suggested, boolean positive, boolean forceStrictNarrow, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(14);
        }
        if (suggested == null) {
            return null;
        }
        if (positive) {
            List initialSubtypes = ((StreamEx)PyTypeUtil.toStream(initial).filter(initialSubtype -> PyTypeAssertionEvaluator.match(suggested, initialSubtype, context))).toList();
            StreamEx suggestedSubtypes = (StreamEx)((StreamEx)PyTypeUtil.toStream(suggested).filter(suggestedSubtype -> PyTypeAssertionEvaluator.match(initial, suggestedSubtype, context))).filter(suggestedSubtype -> !ContainerUtil.exists((Iterable)initialSubtypes, initialSubtype -> PyTypeAssertionEvaluator.match(initialSubtype, suggestedSubtype, context)));
            List types = ((StreamEx)StreamEx.of((Collection)initialSubtypes).append((Stream)suggestedSubtypes)).toList();
            return Ref.create((Object)(types.isEmpty() ? PyTypeAssertionEvaluator.intersect(initial, suggested) : PyUnionType.union(types)));
        }
        if (initial instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)initial;
            return Ref.create((Object)PyTypeAssertionEvaluator.excludeFromUnion(unionType, suggested, context, forceStrictNarrow));
        }
        if (PyTypeAssertionEvaluator.match(suggested, initial, context)) {
            return forceStrictNarrow || PyTypeAssertionEvaluator.isStrictNarrowingAllowed() ? Ref.create((Object)PyNeverType.NEVER) : null;
        }
        @Nullable Ref diff = PyTypeAssertionEvaluator.trySubtract(initial, suggested, context);
        return diff != null ? diff : Ref.create((Object)initial);
    }

    @Nullable
    private static PyType excludeFromUnion(@NotNull PyUnionType unionType, @Nullable PyType type, @NotNull TypeEvalContext context, boolean forceStrictNarrow) {
        if (unionType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(16);
        }
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PyType m : unionType.getMembers()) {
            Ref<@Nullable PyType> diff = PyTypeAssertionEvaluator.trySubtract(m, type, context);
            if (diff != null) {
                members.add((PyType)diff.get());
                continue;
            }
            if (PyTypeAssertionEvaluator.match(type, m, context)) continue;
            members.add(m);
        }
        if ((forceStrictNarrow || PyTypeAssertionEvaluator.isStrictNarrowingAllowed()) && members.isEmpty()) {
            return PyNeverType.NEVER;
        }
        return PyUnionType.union(members);
    }

    public static boolean isStrictNarrowingAllowed() {
        return Registry.is((String)"python.strict.type.narrow");
    }

    @Nullable
    private static @Nullable Ref<@Nullable PyType> trySubtract(@Nullable PyType type1, @Nullable PyType type2, @NotNull TypeEvalContext context) {
        PyClassType classType1;
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(17);
        }
        assert (!(type1 instanceof PyUnionType));
        if (!(type1 instanceof PyLiteralType) && type1 instanceof PyClassType && PyStdlibTypeProvider.isCustomEnum((classType1 = (PyClassType)type1).getPyClass(), context)) {
            if (ContainerUtil.exists((Iterable)classType1.getPyClass().getAncestorClasses(context), cls -> "enum.Flag".equals(cls.getQualifiedName()))) {
                return null;
            }
            List<PyLiteralType> enumMembers = PyStdlibTypeProvider.getEnumMembers(classType1.getPyClass(), context).toList();
            List filteredEnumMembers = ContainerUtil.filter(enumMembers, m -> !PyTypeChecker.match(type2, m, context));
            if (filteredEnumMembers.isEmpty()) {
                return Ref.create((Object)PyNeverType.NEVER);
            }
            PyType type = enumMembers.size() == filteredEnumMembers.size() ? type1 : PyUnionType.union(filteredEnumMembers);
            return Ref.create((Object)type);
        }
        return null;
    }

    @Nullable
    private static PyType intersect(@Nullable PyType initial, @Nullable PyType suggested) {
        if (initial instanceof PyNeverType) {
            return initial;
        }
        return suggested;
    }

    private static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(18);
        }
        return !(actual instanceof PyStructuralType) && !PyTypeChecker.isUnknown(actual, context) && !PyTypeUtil.inheritsAny(actual, context) && PyTypeChecker.match(expected, actual, context);
    }

    @Nullable
    private static PyType transformTypeFromAssertion(@Nullable PyType type, boolean transformToDefinition, @NotNull TypeEvalContext context, @Nullable PyExpression typeElement) {
        PyBinaryExpression binary;
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(19);
        }
        PyExpression typeElementNoParens = PyPsiUtils.flattenParens((PyExpression)typeElement);
        if (type instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)type;
            ArrayList<PyType> members = new ArrayList<PyType>();
            int count = tupleType.getElementCount();
            PyTupleExpression tupleExpression = PyUtil.as(typeElementNoParens, PyTupleExpression.class);
            if (tupleExpression != null && tupleExpression.getElements().length == count) {
                PyExpression[] elements = tupleExpression.getElements();
                for (int i = 0; i < count; ++i) {
                    members.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i), transformToDefinition, context, elements[i]));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    members.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i), transformToDefinition, context, null));
                }
            }
            return PyUnionType.union(members);
        }
        if (typeElementNoParens instanceof PyBinaryExpression && (binary = (PyBinaryExpression)typeElementNoParens).getOperator() == PyTokenTypes.OR) {
            Ref<PyType> typeFromTypingProvider = PyTypingTypeProvider.getType((PyExpression)binary, context);
            if (typeFromTypingProvider != null) {
                return PyTypeAssertionEvaluator.transformTypeFromAssertion((PyType)typeFromTypingProvider.get(), transformToDefinition, context, null);
            }
        } else {
            if (type instanceof PyUnionType) {
                return ((PyUnionType)type).map(member -> PyTypeAssertionEvaluator.transformTypeFromAssertion(member, transformToDefinition, context, null));
            }
            if (type instanceof PyInstantiableType) {
                PyInstantiableType instantiableType = (PyInstantiableType)type;
                return transformToDefinition ? instantiableType.toClass() : instantiableType.toInstance();
            }
        }
        return type;
    }

    private void pushAssertion(@Nullable PyExpression expr, boolean positive, @NotNull Function<TypeEvalContext, PyType> suggestedType) {
        if (suggestedType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(20);
        }
        this.pushAssertion(expr, positive, false, PyTypeAssertionEvaluator.isStrictNarrowingAllowed(), suggestedType);
    }

    private void pushAssertion(@Nullable PyExpression expr, final boolean positive, boolean allowAnyExpr, final boolean forceStrictNarrow, final @NotNull Function<TypeEvalContext, PyType> suggestedType) {
        if (suggestedType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(21);
        }
        if ((expr = PyPsiUtils.flattenParens((PyExpression)expr)) instanceof PySequenceExpression) {
            PySequenceExpression seqExpr = (PySequenceExpression)expr;
            PyExpression[] elements = seqExpr.getElements();
            for (int i = 0; i < elements.length; ++i) {
                this.pushAssertion(elements[i], positive, allowAnyExpr, forceStrictNarrow, PyTypeAssertionEvaluator.getIteratedType(suggestedType, i));
            }
        } else if (expr instanceof PyAssignmentExpression) {
            PyAssignmentExpression walrus = (PyAssignmentExpression)expr;
            this.pushAssertion((PyExpression)walrus.getTarget(), positive, allowAnyExpr, forceStrictNarrow, suggestedType);
        } else if (expr != null) {
            final PyExpression target = expr;
            InstructionTypeCallback typeCallback = new InstructionTypeCallback(){

                @Override
                public Ref<PyType> getType(TypeEvalContext context) {
                    return PyTypeAssertionEvaluator.createAssertionType(context.getType((PyTypedElement)target), (PyType)suggestedType.apply(context), positive, forceStrictNarrow, context);
                }
            };
            if (expr instanceof PyReferenceExpression || expr instanceof PyTargetExpression) {
                this.myStack.push((Object)new Assertion((PyQualifiedExpression)target, typeCallback));
            } else if (allowAnyExpr) {
                this.myStack.push((Object)new Assertion(null, typeCallback));
            }
        }
    }

    @NotNull
    private static Function<TypeEvalContext, PyType> getIteratedType(@NotNull Function<TypeEvalContext, PyType> sequenceType, int index) {
        if (sequenceType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(22);
        }
        Function<TypeEvalContext, PyType> function = context -> {
            PyType computedSuggestedType = (PyType)sequenceType.apply((TypeEvalContext)context);
            if (computedSuggestedType instanceof PyNeverType) {
                return computedSuggestedType;
            }
            if (computedSuggestedType instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)computedSuggestedType;
                return tupleType.getElementType(index);
            }
            return null;
        };
        if (function == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(23);
        }
        return function;
    }

    @Nullable
    private static PsiElement skipNotAndParens(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            PyPrefixExpression prefixExpr;
            if (e instanceof PyParenthesizedExpression || e instanceof PyPrefixExpression && (prefixExpr = (PyPrefixExpression)e).getOperator() == PyTokenTypes.NOT_KEYWORD) continue;
            return e;
        }
        return null;
    }

    private static boolean isReferenceInTruthyCondition(@NotNull PyExpression node) {
        PyGeneratorExpression gen;
        PyBinaryExpression binExpr;
        PyConditionalExpression cond;
        PsiElement parent;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(24);
        }
        if ((parent = PyTypeAssertionEvaluator.skipNotAndParens((PsiElement)node)) instanceof PyConditionalStatementPart) {
            return true;
        }
        if (parent instanceof PyConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)(cond = (PyConditionalExpression)parent).getCondition(), (PsiElement)node, (boolean)false)) {
            return true;
        }
        if (parent instanceof PyBinaryExpression && ((binExpr = (PyBinaryExpression)parent).isOperator("and") || binExpr.isOperator("or"))) {
            return true;
        }
        if (parent instanceof PyAssertStatement) {
            return true;
        }
        return parent instanceof PyGeneratorExpression && ContainerUtil.or((Iterable)(gen = (PyGeneratorExpression)parent).getIfComponents(), it -> PsiTreeUtil.isAncestor((PsiElement)it.getTest(), (PsiElement)node, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequenceType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionInCondition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReferenceExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBinaryExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processIsOrEquals";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIn";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPositive";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCaseClause";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAssertionType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "excludeFromUnion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "trySubtract";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeFromAssertion";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pushAssertion";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIteratedType";
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceInTruthyCondition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23 -> new IllegalStateException(string);
        };
    }

    static class Assertion {
        @Nullable
        private final PyQualifiedExpression element;
        @NotNull
        private final InstructionTypeCallback myFunction;

        Assertion(@Nullable PyQualifiedExpression element, @NotNull InstructionTypeCallback getType) {
            if (getType == null) {
                Assertion.$$$reportNull$$$0(0);
            }
            this.element = element;
            this.myFunction = getType;
        }

        @Nullable
        public PyQualifiedExpression getElement() {
            return this.element;
        }

        @NotNull
        public InstructionTypeCallback getTypeEvalFunction() {
            InstructionTypeCallback instructionTypeCallback = this.myFunction;
            if (instructionTypeCallback == null) {
                Assertion.$$$reportNull$$$0(1);
            }
            return instructionTypeCallback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator$Assertion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator$Assertion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeEvalFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

