/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.google.common.collect.Streams;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.stubs.PyEnumAttributeStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyEnumAttributeStub;
import com.jetbrains.python.psi.stubs.PyLiteralKind;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStdlibTypeProvider
extends PyTypeProviderBase {
    @Nullable
    public static PyStdlibTypeProvider getInstance() {
        for (PyTypeProvider typeProvider : EP_NAME.getExtensionList()) {
            if (!(typeProvider instanceof PyStdlibTypeProvider)) continue;
            return (PyStdlibTypeProvider)typeProvider;
        }
        return null;
    }

    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyType type;
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(1);
        }
        if ((type = PyStdlibTypeProvider.getBaseStringType(referenceTarget)) != null) {
            return Ref.create((Object)type);
        }
        Ref<PyType> enumType = PyStdlibTypeProvider.getEnumType(referenceTarget, context, anchor);
        if (enumType != null) {
            return enumType;
        }
        return null;
    }

    @Nullable
    public PyType getCallableType(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(3);
        }
        return (PyType)Ref.deref(PyStdlibTypeProvider.getTransformedEnumAttributeType((PsiElement)callable, context));
    }

    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(5);
        }
        if (!referenceExpression.isQualified()) {
            String name = referenceExpression.getReferencedName();
            if ("None".equals(name)) {
                return PyBuiltinCache.getInstance((PsiElement)referenceExpression).getNoneType();
            }
            if ("False".equals(name) || "True".equals(name)) {
                return PyBuiltinCache.getInstance((PsiElement)referenceExpression).getBoolType();
            }
        }
        return null;
    }

    @Nullable
    private static PyType getBaseStringType(@NotNull PsiElement referenceTarget) {
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(6);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(referenceTarget);
        if (referenceTarget instanceof PyElement && builtinCache.isBuiltin(referenceTarget) && "basestring".equals(((PyElement)referenceTarget).getName())) {
            return builtinCache.getStrOrUnicodeType(true);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyLiteralType getEnumMemberType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(8);
        }
        return (PyLiteralType)((Object)ObjectUtils.tryCast((Object)Ref.deref(PyStdlibTypeProvider.getTransformedEnumAttributeType(element, context)), PyLiteralType.class));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static Ref<PyType> getEnumType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        block12: {
            if (referenceTarget == null) {
                PyStdlibTypeProvider.$$$reportNull$$$0(9);
            }
            if (context == null) {
                PyStdlibTypeProvider.$$$reportNull$$$0(10);
            }
            if ((enumAttributeType = PyStdlibTypeProvider.getTransformedEnumAttributeType(referenceTarget, context)) != null) {
                return enumAttributeType;
            }
            if (!(referenceTarget instanceof PyQualifiedNameOwner)) break block12;
            qualifiedNameOwner = (PyQualifiedNameOwner)referenceTarget;
            name = qualifiedNameOwner.getQualifiedName();
            if ("enum.Enum.name".equals(name) || "enum.Flag.name".equals(name)) {
                return Ref.create((Object)PyBuiltinCache.getInstance(referenceTarget).getStrType());
            }
            if ("enum.IntEnum.value".equals(name) && anchor instanceof PyReferenceExpression) {
                return Ref.create((Object)PyBuiltinCache.getInstance(referenceTarget).getIntType());
            }
            if ("enum.StrEnum.value".equals(name) && anchor instanceof PyReferenceExpression) {
                return Ref.create((Object)PyBuiltinCache.getInstance(referenceTarget).getStrType());
            }
            if ("enum.Flag.value".equals(name) && anchor instanceof PyReferenceExpression) {
                return Ref.create((Object)PyBuiltinCache.getInstance(referenceTarget).getIntType());
            }
            if (!"enum.Enum.value".equals(name) || !(anchor instanceof PyReferenceExpression)) ** GOTO lbl-1000
            anchorExpr = (PyReferenceExpression)anchor;
            if (context.maySwitchToAST(anchor)) {
                qualifier = anchorExpr.getQualifier();
                if (qualifier != null && (enumType = PyUtil.as(context.getType((PyTypedElement)qualifier), PyClassType.class)) != null && PyStdlibTypeProvider.isCustomEnum(enumClass = enumType.getPyClass(), context)) {
                    return Ref.create((Object)PyStdlibTypeProvider.getEnumValueType(enumClass, context));
                }
            } else if ("enum.EnumMeta.__members__".equals(name)) {
                return Ref.create((Object)PyTypeParser.getTypeByName(referenceTarget, "dict[str, unknown]", context));
            }
        }
        if ((enumAutoType = PyStdlibTypeProvider.getEnumAutoConstructorType(referenceTarget, context, anchor)) != null) {
            return Ref.create((Object)enumAutoType);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTransformedEnumAttributeType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(12);
        }
        return (Ref)RecursionManager.doPreventingRecursion((Object)element, (boolean)false, () -> PyStdlibTypeProvider.getTransformedEnumAttributeTypeImpl(element, context));
    }

    @Nullable
    private static Ref<PyType> getTransformedEnumAttributeTypeImpl(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PyQualifiedNameOwner qualifiedNameOwner;
        String name;
        PyClass cls;
        if (element == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(14);
        }
        if (!(element instanceof PyTargetExpression) && !(element instanceof PyDecoratable)) {
            return null;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(element);
        if (!(scopeOwner instanceof PyClass) || !PyStdlibTypeProvider.isCustomEnum(cls = (PyClass)scopeOwner, context)) {
            return null;
        }
        if (element instanceof PyTargetExpression) {
            PyTargetExpression targetExpression = (PyTargetExpression)element;
            EnumAttributeInfo info = PyStdlibTypeProvider.getEnumAttributeInfo(cls, targetExpression, context);
            if (info != null) {
                Object type = info.attributeKind == EnumAttributeKind.MEMBER ? PyLiteralType.enumMember(cls, Objects.requireNonNull(targetExpression.getName())) : info.assignedValueType;
                return Ref.create((Object)type);
            }
        } else if (PyStdlibTypeProvider.isEnumMember((PyDecoratable)element, context) && element instanceof PyQualifiedNameOwner && (name = (qualifiedNameOwner = (PyQualifiedNameOwner)element).getName()) != null) {
            return Ref.create((Object)((Object)PyLiteralType.enumMember(cls, name)));
        }
        return null;
    }

    @ApiStatus.Internal
    public static boolean isCustomEnum(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(16);
        }
        return PyStdlibTypeProvider.isEnum(cls, context) && !"enum.Enum".equals(cls.getQualifiedName());
    }

    @ApiStatus.Internal
    public static boolean isEnum(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyClassType metaClassType;
        PyClassLikeType pyClassLikeType;
        if (cls == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(18);
        }
        return (pyClassLikeType = cls.getMetaClassType(true, context)) instanceof PyClassType && (metaClassType = (PyClassType)pyClassLikeType).getPyClass().isSubclass("enum.EnumMeta", context);
    }

    @ApiStatus.Internal
    public static Stream<PyLiteralType> getEnumMembers(@NotNull PyClass enumClass, @NotNull TypeEvalContext context) {
        if (enumClass == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(20);
        }
        assert (PyStdlibTypeProvider.isCustomEnum(enumClass, context));
        return Streams.concat((Stream[])new Stream[]{enumClass.getClassAttributes().stream().filter(targetExpr -> {
            EnumAttributeInfo info = PyStdlibTypeProvider.getEnumAttributeInfo(enumClass, targetExpr, context);
            return info != null && info.attributeKind == EnumAttributeKind.MEMBER;
        }), Stream.of(enumClass.getNestedClasses()).filter(cls -> PyStdlibTypeProvider.isEnumMember((PyDecoratable)cls, context)), Stream.of(enumClass.getMethods()).filter(method -> PyStdlibTypeProvider.isEnumMember((PyDecoratable)method, context))}).map(element -> {
            String name = element.getName();
            return name != null ? PyLiteralType.enumMember(enumClass, name) : null;
        });
    }

    @ApiStatus.Internal
    @Nullable
    public static EnumAttributeInfo getEnumAttributeInfo(@NotNull PyClass enumClass, @NotNull PyTargetExpression targetExpression, @NotNull TypeEvalContext context) {
        PyType resolvedType;
        PsiElement resolved;
        PyEnumAttributeStub attributeStub;
        if (enumClass == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(21);
        }
        if (targetExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(23);
        }
        assert (PyStdlibTypeProvider.isCustomEnum(enumClass, context));
        String name = targetExpression.getName();
        if (name == null || PyUtil.isClassPrivateName(name)) {
            return null;
        }
        if (context.maySwitchToAST((PsiElement)targetExpression)) {
            PyExpression value = targetExpression.findAssignedValue();
            if (value == null) {
                return null;
            }
            PyType type = context.getType((PyTypedElement)value);
            return PyStdlibTypeProvider.getEnumAttributeInfo(enumClass, type, context);
        }
        if (!targetExpression.hasAssignedValue()) {
            return null;
        }
        PyTargetExpressionStub stub = (PyTargetExpressionStub)targetExpression.getStub();
        PyEnumAttributeStub pyEnumAttributeStub = attributeStub = stub != null ? (PyEnumAttributeStub)stub.getCustomStub(PyEnumAttributeStub.class) : new PyEnumAttributeStubType().createStub(targetExpression);
        if (attributeStub != null) {
            PyLiteralKind literalKind = attributeStub.getLiteralKind();
            PyType type = literalKind != null ? PyUtil.convertToType(literalKind, PyBuiltinCache.getInstance((PsiElement)targetExpression)) : null;
            return new EnumAttributeInfo(type, attributeStub.isMember() ? EnumAttributeKind.MEMBER : EnumAttributeKind.NONMEMBER);
        }
        QualifiedName calleeName = targetExpression.getCalleeName();
        if (calleeName != null && (resolved = (PsiElement)ContainerUtil.getFirstItem(PyResolveUtil.resolveQualifiedNameInScope(calleeName, (ScopeOwner)enumClass, context))) instanceof PyTypedElement && (resolvedType = context.getType((PyTypedElement)resolved)) instanceof PyClassType && "enum.auto".equals(((PyClassType)resolvedType).getClassQName())) {
            return PyStdlibTypeProvider.getEnumAttributeInfo(enumClass, resolvedType, context);
        }
        QualifiedName assignedQName = targetExpression.getAssignedQName();
        if (assignedQName != null) {
            PsiElement resolved2 = (PsiElement)ContainerUtil.getFirstItem(PyResolveUtil.resolveQualifiedNameInScope(assignedQName, (ScopeOwner)enumClass, context));
            PyType type = resolved2 instanceof PyTypedElement ? context.getType((PyTypedElement)resolved2) : null;
            return PyStdlibTypeProvider.getEnumAttributeInfo(enumClass, type, context);
        }
        PyLiteralKind literalKind = stub != null ? stub.getAssignedLiteralKind() : PyLiteralKind.fromExpression((PyExpression)targetExpression.findAssignedValue());
        PyType type = literalKind != null ? PyUtil.convertToType(literalKind, PyBuiltinCache.getInstance((PsiElement)targetExpression)) : null;
        return new EnumAttributeInfo(type, EnumAttributeKind.MEMBER);
    }

    @NotNull
    private static EnumAttributeInfo getEnumAttributeInfo(@NotNull PyClass enumClass, @Nullable PyType type, @NotNull TypeEvalContext context) {
        PyLiteralType literalType;
        PyClassType classType;
        if (enumClass == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(25);
        }
        Boolean isMember = null;
        if (type instanceof PyCollectionType) {
            PyCollectionType genericType = (PyCollectionType)type;
            if ("enum.member".equals(genericType.getClassQName())) {
                type = (PyType)ContainerUtil.getOnlyItem(genericType.getElementTypes());
                isMember = true;
            }
            if ("enum.nonmember".equals(genericType.getClassQName())) {
                type = (PyType)ContainerUtil.getOnlyItem(genericType.getElementTypes());
                isMember = false;
            }
        }
        if (type instanceof PyClassType && "enum.auto".equals((classType = (PyClassType)type).getClassQName())) {
            type = PyStdlibTypeProvider.getEnumAutoValueType(enumClass, context);
        }
        if (isMember == null) {
            isMember = true;
            if (type != null) {
                if (type.getDeclarationElement() instanceof PyCallable) {
                    isMember = false;
                } else {
                    boolean isDescriptor;
                    boolean bl = isDescriptor = !ContainerUtil.isEmpty((Collection)type.resolveMember("__get__", null, AccessDirection.READ, PyResolveContext.defaultContext((TypeEvalContext)context)));
                    if (isDescriptor) {
                        isMember = false;
                    }
                }
            }
        }
        EnumAttributeKind attributeKind = isMember != false ? (type instanceof PyLiteralType && (literalType = (PyLiteralType)type).getPyClass().equals((Object)enumClass) ? EnumAttributeKind.MEMBER_ALIAS : EnumAttributeKind.MEMBER) : EnumAttributeKind.NONMEMBER;
        return new EnumAttributeInfo(type, attributeKind);
    }

    @Nullable
    private static PyType getEnumAutoValueType(@NotNull PyClass enumClass, @NotNull TypeEvalContext context) {
        PyClass containingClass;
        PyFunction generateNextValueMethod;
        if (enumClass == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(27);
        }
        if ((generateNextValueMethod = enumClass.findMethodByName("_generate_next_value_", true, context)) != null && (containingClass = generateNextValueMethod.getContainingClass()) != null && !"enum.Enum".equals(containingClass.getQualifiedName())) {
            return context.getReturnType((PyCallable)generateNextValueMethod);
        }
        return PyBuiltinCache.getInstance((PsiElement)enumClass).getIntType();
    }

    private static boolean isEnumMember(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        if (decoratable == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(29);
        }
        return PyKnownDecoratorUtil.getKnownDecorators(decoratable, context).contains(PyKnownDecorator.ENUM_MEMBER);
    }

    @Nullable
    private static PyType getEnumAutoConstructorType(@NotNull PsiElement target, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyClassLikeType classType;
        if (target == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(30);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(31);
        }
        if (target instanceof PyClass && "enum.auto".equals(((PyClass)target).getQualifiedName()) && anchor instanceof PyCallExpression && (classType = PyUtil.as(context.getType((PyTypedElement)target), PyClassLikeType.class)) != null) {
            return new PyCallableTypeImpl(Collections.emptyList(), (PyType)classType.toInstance());
        }
        return null;
    }

    @Nullable
    private static PyType getEnumValueType(@NotNull PyClass enumClass, @NotNull TypeEvalContext context) {
        if (enumClass == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(32);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(33);
        }
        PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)enumClass);
        if (enumClass.isSubclass("enum.IntEnum", context) || enumClass.isSubclass("enum.IntFlag", context) || enumClass.isSubclass("enum.Flag", context)) {
            return cache.getIntType();
        }
        if (enumClass.isSubclass("enum.StrEnum", context)) {
            return cache.getStrType();
        }
        if (enumClass.isSubclass("builtins.str", context) || enumClass.isSubclass("str", context)) {
            return cache.getStrType();
        }
        if (enumClass.isSubclass("builtins.int", context) || enumClass.isSubclass("int", context)) {
            return cache.getIntType();
        }
        if (enumClass.isSubclass("builtins.bytes", context) || enumClass.isSubclass("bytes", context)) {
            return cache.getBytesType(LanguageLevel.forElement((PsiElement)enumClass));
        }
        if (enumClass.isSubclass("builtins.float", context) || enumClass.isSubclass("float", context)) {
            return cache.getFloatType();
        }
        if (enumClass.isSubclass("builtins.bool", context) || enumClass.isSubclass("bool", context)) {
            return cache.getBoolType();
        }
        for (PyTargetExpression targetExpr : enumClass.getClassAttributes()) {
            EnumAttributeInfo attributeInfo = PyStdlibTypeProvider.getEnumAttributeInfo(enumClass, targetExpr, context);
            if (attributeInfo == null || attributeInfo.attributeKind != EnumAttributeKind.MEMBER) continue;
            return attributeInfo.assignedValueType;
        }
        return null;
    }

    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String qname;
        if (function == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(34);
        }
        if (callSite == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(36);
        }
        if ((qname = function.getQualifiedName()) != null) {
            if ("tuple.__new__".equals(qname) && callSite instanceof PyCallExpression) {
                return PyStdlibTypeProvider.getTupleInitializationType((PyCallExpression)callSite, context);
            }
            if ("tuple.__add__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleConcatenationResultType((PyBinaryExpression)callSite, context);
            }
            if ("tuple.__mul__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleMultiplicationResultType((PyBinaryExpression)callSite, context);
            }
            if ("object.__new__".equals(qname) && callSite instanceof PyCallExpression) {
                PyExpression firstArgument = (PyExpression)((PyCallExpression)callSite).getArgument(0, PyExpression.class);
                PyClassLikeType classLikeType = PyUtil.as(firstArgument != null ? context.getType((PyTypedElement)firstArgument) : null, PyClassLikeType.class);
                return classLikeType != null ? Ref.create((Object)classLikeType.toInstance()) : null;
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleMultiplicationResultType(@NotNull PyBinaryExpression multiplication, @NotNull TypeEvalContext context) {
        PsiElement target;
        PyTupleType leftTupleType;
        if (multiplication == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(37);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(38);
        }
        if ((leftTupleType = PyUtil.as(context.getType((PyTypedElement)multiplication.getLeftExpression()), PyTupleType.class)) == null) {
            return null;
        }
        PyExpression rightExpression = multiplication.getRightExpression();
        if (rightExpression instanceof PyReferenceExpression && (target = ((PyReferenceExpression)rightExpression).getReference().resolve()) instanceof PyTargetExpression) {
            rightExpression = ((PyTargetExpression)target).findAssignedValue();
        }
        if (rightExpression instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)rightExpression).isIntegerLiteral()) {
            if (leftTupleType.isHomogeneous()) {
                return Ref.create((Object)leftTupleType);
            }
            int multiplier = ((PyNumericLiteralExpression)rightExpression).getBigIntegerValue().intValue();
            int originalSize = leftTupleType.getElementCount();
            if (originalSize * multiplier <= 20) {
                PyType[] elementTypes = new PyType[leftTupleType.getElementCount() * multiplier];
                for (int i = 0; i < multiplier; ++i) {
                    for (int j = 0; j < originalSize; ++j) {
                        elementTypes[i * originalSize + j] = leftTupleType.getElementType(j);
                    }
                }
                return Ref.create((Object)PyTupleType.create((PsiElement)multiplication, Arrays.asList(elementTypes)));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleConcatenationResultType(@NotNull PyBinaryExpression addition, @NotNull TypeEvalContext context) {
        if (addition == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(40);
        }
        if (addition.getRightExpression() != null) {
            PyTupleType leftTupleType = PyUtil.as(context.getType((PyTypedElement)addition.getLeftExpression()), PyTupleType.class);
            PyTupleType rightTupleType = PyUtil.as(context.getType((PyTypedElement)addition.getRightExpression()), PyTupleType.class);
            if (leftTupleType != null && rightTupleType != null) {
                if (leftTupleType.isHomogeneous() || rightTupleType.isHomogeneous()) {
                    return null;
                }
                List newElementTypes = ContainerUtil.concat(leftTupleType.getElementTypes(), rightTupleType.getElementTypes());
                return Ref.create((Object)PyTupleType.create((PsiElement)addition, newElementTypes));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleInitializationType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyExpression[] arguments;
        if (call == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(42);
        }
        if ((arguments = call.getArguments()).length != 1) {
            return null;
        }
        PyExpression argument = arguments[0];
        PyType argumentType = context.getType((PyTypedElement)argument);
        if (argumentType instanceof PyTupleType) {
            return Ref.create((Object)argumentType);
        }
        if (argumentType instanceof PyCollectionType) {
            PyType iteratedItemType = ((PyCollectionType)argumentType).getIteratedItemType();
            return Ref.create((Object)PyTupleType.createHomogeneous((PsiElement)call, iteratedItemType));
        }
        return null;
    }

    @Nullable
    public PyType getContextManagerVariableType(@NotNull PyClass contextManager, @NotNull PyExpression withExpression, @NotNull TypeEvalContext context) {
        PyExpression closee;
        if (contextManager == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(43);
        }
        if (withExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(44);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(45);
        }
        if ("contextlib.closing".equals(contextManager.getQualifiedName()) && withExpression instanceof PyCallExpression && (closee = (PyExpression)((PyCallExpression)withExpression).getArgument(0, PyExpression.class)) != null) {
            return context.getType((PyTypedElement)closee);
        }
        String name = contextManager.getName();
        if ("FileIO".equals(name) || "TextIOWrapper".equals(name) || "IOBase".equals(name) || "_IOBase".equals(name)) {
            return context.getType((PyTypedElement)withExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiplication";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addition";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextManager";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallableType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseStringType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumMemberType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransformedEnumAttributeType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransformedEnumAttributeTypeImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomEnum";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnum";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumMembers";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumAttributeInfo";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumAutoValueType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnumMember";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumAutoConstructorType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumValueType";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleMultiplicationResultType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleConcatenationResultType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleInitializationType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextManagerVariableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public record EnumAttributeInfo(@Nullable PyType assignedValueType, @NotNull EnumAttributeKind attributeKind) {
        @NotNull
        private final EnumAttributeKind attributeKind;

        public EnumAttributeInfo(@Nullable PyType assignedValueType, @NotNull EnumAttributeKind attributeKind) {
            if (attributeKind == null) {
                EnumAttributeInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public EnumAttributeKind attributeKind() {
            EnumAttributeKind enumAttributeKind = this.attributeKind;
            if (enumAttributeKind == null) {
                EnumAttributeInfo.$$$reportNull$$$0(1);
            }
            return enumAttributeKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider$EnumAttributeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider$EnumAttributeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "attributeKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static enum EnumAttributeKind {
        MEMBER,
        MEMBER_ALIAS,
        NONMEMBER;

    }
}

