/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintFile;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyClassVarInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010!\u001a\u00020\u000f*\u00020\u000bH\u0002J\u001f\u0010\"\u001a\u00020\u000f\"\f\b\u0000\u0010#*\u00020$*\u00020%*\u0002H#H\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002\u00a8\u0006*"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyTargetExpression", "", "node", "Lcom/jetbrains/python/psi/PyTargetExpression;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "isWrappedWithTypingAnnotated", "", "tupleExpression", "Lcom/jetbrains/python/psi/PyTupleExpression;", "checkClassVarParameterization", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "checkAssignedValue", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyFunction", "Lcom/jetbrains/python/psi/PyFunction;", "checkClassVarDeclaration", "target", "checkClassVarReassignment", "checkInheritedClassClassVarReassignmentOnClassLevel", "cls", "Lcom/jetbrains/python/psi/PyClass;", "checkInstanceClassVarReassignment", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "hasExplicitType", "isClassVar", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "resolvesToClassVar", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyClassVarInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyClassVarInspection.kt\ncom/jetbrains/python/inspections/PyClassVarInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1807#2,3:197\n1915#2,2:200\n1807#2,3:203\n1#3:202\n*S KotlinDebug\n*F\n+ 1 PyClassVarInspection.kt\ncom/jetbrains/python/inspections/PyClassVarInspection$Visitor\n*L\n69#1:197,3\n86#1:200,2\n192#1:203,3\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkClassVarReassignment(node);
            this.checkClassVarDeclaration(node);
            this.checkAssignedValue(node);
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            boolean reportNestedClassVar;
            PsiElement parent;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!PyTypingTypeProvider.isInsideTypeHint((PsiElement)node, this.myTypeEvalContext)) {
                return;
            }
            if (!this.resolvesToClassVar((PyExpression)node)) {
                return;
            }
            PyExpression classVar = (PyExpression)node;
            PsiElement classVarParent = classVar.getParent();
            if (classVarParent instanceof PySubscriptionExpression && Intrinsics.areEqual((Object)((PySubscriptionExpression)classVarParent).getOperand(), (Object)classVar)) {
                classVar = (PyExpression)classVarParent;
                this.checkClassVarParameterization((PySubscriptionExpression)classVar);
            }
            if ((parent = classVar.getParent()) instanceof PyAssignmentStatement) {
                this.registerProblem((PsiElement)classVar, PyPsiBundle.message("INSP.class.var.is.not.allowed.here", new Object[0]));
                return;
            }
            PsiElement psiElement = parent;
            boolean bl = psiElement instanceof PyAnnotation ? false : (psiElement instanceof PyExpressionStatement ? !(((PyExpressionStatement)parent).getParent() instanceof PyTypeHintFile) : (psiElement instanceof PyTupleExpression ? !this.isWrappedWithTypingAnnotated((PyTupleExpression)parent) : (reportNestedClassVar = true)));
            if (reportNestedClassVar) {
                this.registerProblem((PsiElement)classVar, PyPsiBundle.message("INSP.class.var.can.not.be.nested", new Object[0]));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrappedWithTypingAnnotated(PyTupleExpression tupleExpression) {
            boolean bl;
            PsiElement parentOfTuple = tupleExpression.getParent();
            if (!(parentOfTuple instanceof PySubscriptionExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(((PySubscriptionExpression)parentOfTuple).getOperand(), this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it, (Object)"typing.Annotated")) return true;
                if (Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Annotated")) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final void checkClassVarParameterization(PySubscriptionExpression node) {
            PyExpression indexExpression;
            PyExpression pyExpression = node.getOperand();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getOperand(...)");
            PyExpression operand = pyExpression;
            if (this.resolvesToClassVar(operand) && (indexExpression = node.getIndexExpression()) != null) {
                if (indexExpression instanceof PyTupleExpression && ((PyTupleExpression)indexExpression).getElements().length > 1) {
                    this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.class.var.can.only.be.parameterized.with.one.type", new Object[0]));
                } else {
                    Ref<PyType> typeRef = PyTypingTypeProvider.getType(indexExpression, this.myTypeEvalContext);
                    if (typeRef == null) {
                        this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.class.var.not.a.valid.type", new Object[0]));
                    }
                    Class[] classArray = new Class[]{PyReferenceExpression.class};
                    Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)indexExpression), (boolean)false, (Class[])classArray);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
                    Collection references2 = collection;
                    Iterable $this$forEach$iv = references2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PyReferenceExpression reference = (PyReferenceExpression)element$iv;
                        boolean bl = false;
                        PyType referenceType = (PyType)Ref.deref(PyTypingTypeProvider.getType((PyExpression)reference, this.myTypeEvalContext));
                        if (!(referenceType instanceof PyTypeParameterType) || referenceType instanceof PySelfType) continue;
                        this.registerProblem((PsiElement)reference, PyPsiBundle.message("INSP.class.var.can.not.include.type.variables", new Object[0]));
                    }
                }
            }
        }

        private final void checkAssignedValue(PyTargetExpression node) {
            block6: {
                if (!node.hasAssignedValue()) {
                    return;
                }
                PyAnnotation pyAnnotation = node.getAnnotation();
                if (pyAnnotation == null || (pyAnnotation = pyAnnotation.getValue()) == null) break block6;
                PyAnnotation annotationValue = pyAnnotation;
                boolean bl = false;
                if (annotationValue instanceof PySubscriptionExpression) {
                    PyExpression pyExpression = ((PySubscriptionExpression)annotationValue).getOperand();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getOperand(...)");
                    if (this.resolvesToClassVar(pyExpression)) {
                        PyType actualType;
                        PyType expectedType = this.myTypeEvalContext.getType((PyTypedElement)node);
                        PyExpression pyExpression2 = node.findAssignedValue();
                        if (pyExpression2 != null) {
                            PyExpression it = pyExpression2;
                            boolean bl2 = false;
                            v3 = this.myTypeEvalContext.getType((PyTypedElement)it);
                        } else {
                            v3 = actualType = null;
                        }
                        if (expectedType != null && actualType != null && !PyTypeChecker.match(expectedType, actualType, this.myTypeEvalContext)) {
                            String string = PythonDocumentationProvider.getTypeName(expectedType, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                            String expectedName = string;
                            String string2 = PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeName(...)");
                            String actualName = string2;
                            Object[] objectArray = new Object[]{expectedName, actualName};
                            this.registerProblem((PsiElement)node.findAssignedValue(), PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray));
                        }
                    }
                }
            }
        }

        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isClassVar((PyAnnotationOwner)node)) {
                PyAnnotation pyAnnotation = (PyAnnotation)node.getAnnotation();
                this.registerProblem(pyAnnotation != null && (pyAnnotation = pyAnnotation.getValue()) != null ? (PsiElement)pyAnnotation : (PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotations.for.function.parameters", new Object[0]));
            }
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyExpression pyExpression = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression == null) break block3;
                PyExpression it = pyExpression;
                boolean bl = false;
                PyExpression pyExpression2 = it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it;
                Intrinsics.checkNotNull((Object)pyExpression2);
                if (this.resolvesToClassVar(pyExpression2)) {
                    PsiElement psiElement;
                    PsiComment psiComment = node.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = (PyAnnotation)node.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotation.for.function.return.value", new Object[0]));
                }
            }
        }

        private final void checkClassVarDeclaration(PyTargetExpression target) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
            if (scopeOwner instanceof PyClass) {
                this.checkInheritedClassClassVarReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            } else if (this.isClassVar((PyAnnotationOwner)target)) {
                PsiElement psiElement;
                PsiComment psiComment = target.getTypeComment();
                if (psiComment != null) {
                    psiElement = (PsiElement)psiComment;
                } else {
                    PyAnnotation pyAnnotation = target.getAnnotation();
                    psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                }
                this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.be.used.only.in.class.body", new Object[0]));
            }
        }

        private final void checkClassVarReassignment(PyTargetExpression target) {
            PyType qualifierType;
            PyExpression pyExpression = target.getQualifier();
            if (pyExpression != null) {
                PyExpression it = pyExpression;
                boolean bl = false;
                v1 = this.myTypeEvalContext.getType((PyTypedElement)it);
            } else {
                v1 = qualifierType = null;
            }
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                PyQualifiedExpression pyQualifiedExpression = (PyQualifiedExpression)target;
                PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                this.checkInstanceClassVarReassignment(pyQualifiedExpression, pyClass);
            }
        }

        private final void checkInheritedClassClassVarReassignmentOnClassLevel(PyTargetExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name = string;
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !this.hasExplicitType(ancestorClassAttribute) || !this.hasExplicitType(target)) continue;
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) && !this.isClassVar((PyAnnotationOwner)target)) {
                    Object[] objectArray = new Object[]{name, ancestor.getName()};
                    this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.class.var.can.not.override.class.variable", objectArray));
                    break;
                }
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) || !this.isClassVar((PyAnnotationOwner)target)) continue;
                Object[] objectArray = new Object[]{name, ancestor.getName()};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.class.var.can.not.override.instance.variable", objectArray));
                break;
            }
        }

        private final void checkInstanceClassVarReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name = string;
            Collection collection = CollectionsKt.listOf((Object)cls);
            List list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAncestorClasses(...)");
            for (PyClass ancestor : CollectionsKt.plus((Collection)collection, (Iterable)list)) {
                PyTargetExpression inheritedClassAttribute = ancestor.findClassAttribute(name, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || !this.isClassVar((PyAnnotationOwner)inheritedClassAttribute)) continue;
                Object[] objectArray = new Object[]{name};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.class.var.can.not.be.assigned.to.instance", objectArray));
                return;
            }
        }

        private final boolean hasExplicitType(PyTargetExpression $this$hasExplicitType) {
            return $this$hasExplicitType.getAnnotationValue() != null || $this$hasExplicitType.getTypeCommentAnnotation() != null;
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(T $this$isClassVar) {
            return PyTypingTypeProvider.isClassVar($this$isClassVar, this.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToClassVar(PyExpression expression) {
            String it;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it, (Object)"typing.ClassVar"));
            return true;
        }
    }
}

