/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.inspections.PyDunderSlotsInspection$Visitor$visitPyClass$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "RemoveSlotsKwargQuickFix", "intellij.python.psi.impl"})
public final class PyDunderSlotsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection$RemoveSlotsKwargQuickFix;", "Lcom/intellij/modcommand/ModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "perform", "Lcom/intellij/modcommand/ModCommand;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDunderSlotsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$RemoveSlotsKwargQuickFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n66#2,2:143\n1#3:145\n*S KotlinDebug\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$RemoveSlotsKwargQuickFix\n*L\n109#1:143,2\n*E\n"})
    private static final class RemoveSlotsKwargQuickFix
    extends ModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.dunder.slots.enabled.twice", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement element = descriptor.getPsiElement();
            Intrinsics.checkNotNull((Object)element);
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PyKeywordArgument pyKeywordArgument = (PyKeywordArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyKeywordArgument.class, (boolean)true);
            if (pyKeywordArgument == null && (pyKeywordArgument = element instanceof PyKeywordArgument ? (PyKeywordArgument)element : null) == null) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            PyKeywordArgument kwArg = pyKeywordArgument;
            if (!Intrinsics.areEqual((Object)kwArg.getKeyword(), (Object)"slots")) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            if (!(kwArg.getParent() instanceof PyArgumentList)) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)kwArg), RemoveSlotsKwargQuickFix::perform$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }

        private static final void perform$lambda$0(PyKeywordArgument kwArgCopy) {
            PsiElement commaBefore;
            Object object;
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)kwArgCopy, (String)"kwArgCopy");
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)kwArgCopy));
            if (psiElement2 != null) {
                PsiElement it = psiElement = psiElement2;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)PyTokenTypes.COMMA) ? psiElement : null;
            } else {
                object = null;
            }
            PsiElement commaAfter = object;
            psiElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)((PsiElement)kwArgCopy));
            if (psiElement != null) {
                PsiElement psiElement3;
                PsiElement it = psiElement3 = psiElement;
                boolean bl = false;
                v1 = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)PyTokenTypes.COMMA) ? psiElement3 : null;
            } else {
                v1 = commaBefore = null;
            }
            if (commaAfter != null) {
                commaAfter.delete();
                kwArgCopy.delete();
            } else if (commaBefore != null) {
                kwArgCopy.delete();
                commaBefore.delete();
            } else {
                kwArgCopy.delete();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "findSlotsValue", "Lcom/jetbrains/python/psi/PyExpression;", "pyClass", "processSlot", "slot", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "checkAttributeExpression", "target", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDunderSlotsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,142:1\n479#2:143\n1342#2,2:144\n*S KotlinDebug\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor\n*L\n56#1:143\n57#1:144,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        /*
         * WARNING - void declaration
         */
        public void visitPyClass(@NotNull PyClass node) {
            PsiElement anchor;
            PyTargetExpression explicitSlotsAttr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters params = PyDataclassesKt.parseDataclassParameters(node, typeEvalContext);
            if (params != null && params.getSlots() && (explicitSlotsAttr = node.findClassAttribute("__slots__", false, this.myTypeEvalContext)) != null) {
                PsiElement psiElement;
                PyExpression pyExpression = params.getSlotsArgument();
                if (pyExpression != null) {
                    psiElement = (PsiElement)pyExpression;
                } else {
                    psiElement = node.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)node;
                    }
                }
                anchor = psiElement;
                String string = PyPsiBundle.message("INSP.dunder.slots.enabled.twice", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                if (params.getSlotsArgument() != null) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveSlotsKwargQuickFix()};
                    this.registerProblem(anchor, message, localQuickFixArray);
                } else {
                    this.registerProblem(anchor, message);
                }
            }
            if (!LanguageLevel.forElement((PsiElement)((PsiElement)node)).isPython2()) {
                PyExpression slots = this.findSlotsValue(node);
                if (slots instanceof PySequenceExpression) {
                    void $this$forEach$iv;
                    Sequence $this$filterIsInstance$iv;
                    anchor = ((PySequenceExpression)slots).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)anchor, (String)"getElements(...)");
                    anchor = ArraysKt.asSequence((Object[])((Object[])anchor));
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyClass$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    $this$filterIsInstance$iv = sequence;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv;
                        boolean bl = false;
                        this.processSlot(node, it);
                    }
                } else if (slots instanceof PyStringLiteralExpression) {
                    this.processSlot(node, (PyStringLiteralExpression)slots);
                }
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            this.checkAttributeExpression(node);
        }

        private final PyExpression findSlotsValue(PyClass pyClass) {
            PyTargetExpression target;
            PyTargetExpression pyTargetExpression = target = pyClass.findClassAttribute("__slots__", false, this.myTypeEvalContext);
            PyExpression value = pyTargetExpression != null ? pyTargetExpression.findAssignedValue() : null;
            return PyPsiUtils.flattenParens((PyExpression)value);
        }

        private final void processSlot(PyClass pyClass, PyStringLiteralExpression slot) {
            String string = slot.getStringValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
            String name = string;
            PyTargetExpression classAttribute = pyClass.findClassAttribute(name, false, this.myTypeEvalContext);
            if (classAttribute != null && classAttribute.hasAssignedValue()) {
                Object[] objectArray = new Object[]{name};
                String string2 = PyPsiBundle.message("INSP.dunder.slots.name.in.slots.conflicts.with.class.variable", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                this.registerProblem((PsiElement)slot, message);
            }
        }

        private final void checkAttributeExpression(PyTargetExpression target) {
            String targetName = target.getName();
            PyExpression qualifier = target.getQualifier();
            if (targetName == null || qualifier == null) {
                return;
            }
            PyType qualifierType = this.myTypeEvalContext.getType((PyTypedElement)qualifier);
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isAttributeWritable(targetName, this.myTypeEvalContext)) {
                Object[] objectArray = new Object[]{((PyClassType)qualifierType).getName(), targetName};
                String string = PyPsiBundle.message("INSP.dunder.slots.class.object.missing.attribute", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.registerProblem((PsiElement)target, message);
            }
        }
    }
}

