/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyProtocolInspection$Visitor$checkCompatibility$;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeMember;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyProtocolInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J.\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClassPattern", "Lcom/jetbrains/python/psi/PyClassPattern;", "checkCompatibility", "type", "Lcom/jetbrains/python/psi/types/PyClassType;", "superClassTypes", "", "Lcom/jetbrains/python/psi/types/PyClassLikeType;", "checkProtocolBases", "checkRuntimeProtocol", "base", "Lcom/jetbrains/python/psi/PyExpression;", "checkNewTypeWithProtocols", "checkMemberCompatibility", "expectedMember", "Lcom/jetbrains/python/psi/types/PyTypeMember;", "subclassMembers", "protocol", "checkProtocolInstantiation", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyProtocolInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyProtocolInspection.kt\ncom/jetbrains/python/inspections/PyProtocolInspection$Visitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n479#2:162\n1342#2:163\n1343#2:166\n1276#2,2:170\n1342#2,2:172\n1915#3,2:164\n1786#3,3:167\n*S KotlinDebug\n*F\n+ 1 PyProtocolInspection.kt\ncom/jetbrains/python/inspections/PyProtocolInspection$Visitor\n*L\n59#1:162\n61#1:163\n61#1:166\n93#1:170,2\n133#1:172,2\n62#1:164,2\n85#1:167,3\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyClass(@NotNull PyClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            PyType pyType = this.myTypeEvalContext.getType((PyTypedElement)node);
            PyClassType pyClassType = pyType instanceof PyClassType ? (PyClassType)pyType : null;
            if (pyClassType == null) {
                return;
            }
            PyClassType type = pyClassType;
            List list = type.getSuperClassTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuperClassTypes(...)");
            List superClassTypes = list;
            this.checkCompatibility(type, superClassTypes);
            this.checkProtocolBases(type, superClassTypes);
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyCallExpression(node);
            String[] stringArray = new String[]{"isinstance", "issubclass"};
            if (node.isCalleeText(stringArray)) {
                PyExpression[] pyExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                PyExpression pyExpression = (PyExpression)ArraysKt.getOrNull((Object[])pyExpressionArray, (int)1);
                if (pyExpression != null) {
                    PyExpression it = pyExpression;
                    boolean bl = false;
                    this.checkRuntimeProtocol(it);
                }
            }
            this.checkNewTypeWithProtocols(node);
            this.checkProtocolInstantiation(node);
        }

        public void visitPyClassPattern(@NotNull PyClassPattern node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyReferenceExpression pyReferenceExpression = node.getClassNameReference();
            Intrinsics.checkNotNullExpressionValue((Object)pyReferenceExpression, (String)"getClassNameReference(...)");
            this.checkRuntimeProtocol((PyExpression)pyReferenceExpression);
        }

        private final void checkCompatibility(PyClassType type, List<? extends PyClassLikeType> superClassTypes) {
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)superClassTypes);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$checkCompatibility$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence, arg_0 -> Visitor.checkCompatibility$lambda$0(this, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyClassType protocol = (PyClassType)element$iv;
                boolean bl = false;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                Iterable $this$forEach$iv2 = PyProtocolsKt.inspectProtocolSubclass(protocol, type, typeEvalContext);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair it = (Pair)element$iv2;
                    boolean bl2 = false;
                    List subclassElements = (List)it.getSecond();
                    if (!(!((Collection)subclassElements).isEmpty())) continue;
                    this.checkMemberCompatibility((PyTypeMember)it.getFirst(), subclassElements, type, protocol);
                }
            }
        }

        private final void checkProtocolBases(PyClassType type, List<? extends PyClassLikeType> superClassTypes) {
            boolean bl;
            block5: {
                PyClassLikeType pyClassLikeType = (PyClassLikeType)type;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (!PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                    return;
                }
                Function1 correctBase = arg_0 -> Visitor.checkProtocolBases$lambda$0(this, arg_0);
                Iterable $this$all$iv = superClassTypes;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        if (((Boolean)correctBase.invoke(element$iv)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                this.registerProblem(type.getPyClass().getNameIdentifier(), PyPsiBundle.message("INSP.protocol.all.bases.protocol.must.be.protocols", new Object[0]));
            }
        }

        private final void checkRuntimeProtocol(PyExpression base) {
            PyType type;
            if (base instanceof PyReferenceExpression) {
                boolean bl;
                block6: {
                    Sequence qNames;
                    List<QualifiedName> list = PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)base);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"resolveImportedElementQNameLocally(...)");
                    Sequence $this$any$iv = qNames = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), Visitor::checkRuntimeProtocol$lambda$0);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it, (Object)"typing.Protocol") || Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Protocol"))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.only.runtime.checkable.protocols.can.be.used.with.instance.class.checks", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                    return;
                }
            }
            if ((type = this.myTypeEvalContext.getType((PyTypedElement)base)) instanceof PyClassType) {
                PyClassLikeType pyClassLikeType = (PyClassLikeType)type;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                    PyClassType pyClassType = (PyClassType)type;
                    TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                    if (!PyProtocolsKt.isRuntimeCheckable(pyClassType, typeEvalContext2)) {
                        this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.only.runtime.checkable.protocols.can.be.used.with.instance.class.checks", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                    }
                }
            }
        }

        private final void checkNewTypeWithProtocols(PyCallExpression node) {
            boolean isNewTypeCall;
            PyExpression pyExpression = node.getCallee();
            PyReferenceExpression pyReferenceExpression = pyExpression instanceof PyReferenceExpression ? (PyReferenceExpression)pyExpression : null;
            if (pyReferenceExpression == null) {
                return;
            }
            PyReferenceExpression callee = pyReferenceExpression;
            PsiElement psiElement = callee.followAssignmentsChain(this.getResolveContext()).getElement();
            if (psiElement == null) {
                return;
            }
            PsiElement resolved = psiElement;
            boolean bl = isNewTypeCall = resolved instanceof PyQualifiedNameOwner && Intrinsics.areEqual((Object)((PyQualifiedNameOwner)resolved).getQualifiedName(), (Object)"typing.NewType");
            if (isNewTypeCall) {
                PyType type;
                PyExpression[] pyExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                PyExpression base = (PyExpression)ArraysKt.getOrNull((Object[])pyExpressionArray, (int)1);
                if (base != null && (type = this.myTypeEvalContext.getType((PyTypedElement)base)) instanceof PyClassLikeType) {
                    PyClassLikeType pyClassLikeType = (PyClassLikeType)type;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                        this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.newtype.cannot.be.used.with.protocol.classes", new Object[0]));
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkMemberCompatibility(PyTypeMember expectedMember, List<PyTypeMember> subclassMembers, PyClassType type, PyClassType protocol) {
            void $this$forEach$iv;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)subclassMembers), arg_0 -> Visitor.checkMemberCompatibility$lambda$0(type, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object[] objectArray;
                PsiElement psiElement;
                PyTypeMember it = (PyTypeMember)element$iv;
                boolean bl = false;
                PsiElement element = it.getElement();
                if (element instanceof PsiNameIdentifierOwner) {
                    psiElement = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                } else {
                    psiElement = element;
                    if (psiElement == null) continue;
                }
                PsiElement place = psiElement;
                if (!(element instanceof PsiNameIdentifierOwner)) continue;
                String elementName = ((PsiNameIdentifierOwner)element).getName();
                if (!PyTypeChecker.match(expectedMember.getType(), it.getType(), this.myTypeEvalContext)) {
                    objectArray = new Object[]{elementName, protocol.getName()};
                    this.registerProblem(place, PyPsiBundle.message("INSP.protocol.element.type.incompatible.with.protocol", objectArray));
                    continue;
                }
                if ((!expectedMember.isWritable() || it.isWritable()) && (!expectedMember.isDeletable() || it.isDeletable())) continue;
                objectArray = new Object[]{elementName, protocol.getName()};
                this.registerProblem(place, PyPsiBundle.message("INSP.protocol.element.type.not.writable", objectArray));
            }
        }

        private final void checkProtocolInstantiation(PyCallExpression node) {
            PyExpression calleeReferenceExpression = node.getCallee();
            if (calleeReferenceExpression instanceof PyReferenceExpression) {
                QualifiedResolveResult qualifiedResolveResult = ((PyReferenceExpression)calleeReferenceExpression).followAssignmentsChain(this.getResolveContext());
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedResolveResult, (String)"followAssignmentsChain(...)");
                QualifiedResolveResult resolveResult = qualifiedResolveResult;
                PsiElement cls = resolveResult.getElement();
                if (cls instanceof PyClass) {
                    PyClass pyClass = (PyClass)cls;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClass, typeEvalContext)) {
                        Object[] objectArray = new Object[]{((PyClass)cls).getName()};
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.protocol.cannot.instantiate.protocol.class", objectArray));
                    }
                }
            }
        }

        private static final boolean checkCompatibility$lambda$0(Visitor this$0, PyClassType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PyClassLikeType pyClassLikeType = (PyClassLikeType)it;
            TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            return PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean checkProtocolBases$lambda$0(Visitor this$0, PyClassLikeType it) {
            if (it == null) {
                return true;
            }
            String classQName = it.getClassQName();
            if (Intrinsics.areEqual((Object)classQName, (Object)"typing.Protocol")) return true;
            if (Intrinsics.areEqual((Object)classQName, (Object)"typing_extensions.Protocol")) return true;
            if (!(it instanceof PyClassType)) return false;
            TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyProtocolsKt.isProtocol(it, typeEvalContext)) return false;
            return true;
        }

        private static final String checkRuntimeProtocol$lambda$0(QualifiedName it) {
            return it.toString();
        }

        private static final boolean checkMemberCompatibility$lambda$0(PyClassType $type, PyTypeMember it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PsiElement psiElement = it.getElement();
            return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)$type.getPyClass().getContainingFile());
        }
    }
}

