/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyReachableElementVisitor;
import com.jetbrains.python.inspections.PyTypeCheckerInspectionProblemRegistrar;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionReturnTypeQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.ArgumentMappingResults;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PySubscriptionExpressionImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterListType;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyDescriptorTypeUtil;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyPositionalVariadicType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeCheckerInspection
extends PyInspection {
    private static final Logger LOG = Logger.getInstance((String)PyTypeCheckerInspection.class.getName());
    private static final Key<Long> TIME_KEY = Key.create((String)"PyTypeCheckerInspection.StartTime");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            session.putUserData(TIME_KEY, (Object)System.nanoTime());
        }
        TypeEvalContext context = PyInspectionVisitor.getContext(session);
        return new PyReachableElementVisitor(new Visitor(holder, context), context);
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Long startTime;
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled() && (startTime = (Long)session.getUserData(TIME_KEY)) != null) {
            LOG.debug(String.format("[%d] elapsed time: %d ms\n", Thread.currentThread().getId(), (System.nanoTime() - startTime) / 1000000L));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectionFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
        }

        @Override
        @NotNull
        protected ProblemsHolder getHolder() {
            ProblemsHolder holder = super.getHolder();
            assert (holder != null);
            ProblemsHolder problemsHolder = holder;
            if (problemsHolder == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return problemsHolder;
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.checkCallSite((PyCallSiteExpression)node);
        }

        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.checkCallSite((PyCallSiteExpression)node);
        }

        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            PyTupleType tupleType;
            PyType operandType;
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if ((operandType = this.myTypeEvalContext.getType((PyTypedElement)node.getOperand())) instanceof PyTupleType && !(tupleType = (PyTupleType)operandType).isHomogeneous()) {
                PyExpression indexExpression = node.getIndexExpression();
                for (int index : PySubscriptionExpressionImpl.getIndexExpressionPossibleValues(indexExpression, this.myTypeEvalContext, Integer.class)) {
                    int count;
                    if (index >= -(count = tupleType.getElementCount()) && index < count) continue;
                    this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.type.checker.tuple.index.out.of.range", new Object[0]));
                }
            }
            if (operandType instanceof PyTypedDictType) {
                return;
            }
            if (PyTypingTypeProvider.isInsideTypeHint((PsiElement)node, this.myTypeEvalContext)) {
                return;
            }
            this.checkCallSite((PyCallSiteExpression)node);
        }

        public void visitPyForStatement(@NotNull PyForStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            this.checkIteratedValue(node.getForPart().getSource(), node.isAsync());
        }

        public void visitPyWithStatement(@NotNull PyWithStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            for (PyWithItem withItem : node.getWithItems()) {
                this.checkContextManagerValue(withItem.getExpression(), node.isAsync());
            }
        }

        public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
            ScopeOwner owner;
            if (node == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyFunction) {
                PyFunction function = (PyFunction)owner;
                PyAnnotation annotation = function.getAnnotation();
                String typeCommentAnnotation = function.getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyClassType actual;
                    PyType expected = Visitor.getExpectedReturnStatementType(function, this.myTypeEvalContext);
                    if (expected == null) {
                        return;
                    }
                    PyExpression returnExpr = node.getExpression();
                    if (expected instanceof PyTypedDictType) {
                        PyTypedDictType expectedTypedDictType = (PyTypedDictType)expected;
                        if (returnExpr != null && PyTypedDictType.isDictExpression(returnExpr, this.myTypeEvalContext)) {
                            this.reportTypedDictProblems(expectedTypedDictType, returnExpr);
                            return;
                        }
                    }
                    Object object = actual = returnExpr != null ? this.tryPromotingType(returnExpr, expected) : PyBuiltinCache.getInstance((PsiElement)node).getNoneType();
                    if (!PyTypeChecker.match(expected, (PyType)actual, this.myTypeEvalContext)) {
                        String expectedName = PythonDocumentationProvider.getVerboseTypeName(expected, this.myTypeEvalContext);
                        String actualName = PythonDocumentationProvider.getTypeName((PyType)actual, this.myTypeEvalContext);
                        this.getHolder().problem((PsiElement)(returnExpr != null ? returnExpr : node), PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName)).fix((ModCommandAction)new PyMakeFunctionReturnTypeQuickFix(function, this.myTypeEvalContext)).register();
                    }
                }
            }
        }

        public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
            ScopeOwner owner;
            if (node == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if (!((owner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyFunction)) {
                return;
            }
            PyFunction function = (PyFunction)owner;
            if (node.isDelegating()) {
                this.visitDelegatingYieldExpression(node, function);
                return;
            }
            PyTypingTypeProvider.GeneratorTypeDescriptor annotatedGeneratorDesc = this.getGeneratorDescriptorFromAnnotation(function, node);
            if (annotatedGeneratorDesc == null) {
                return;
            }
            this.checkYieldType(annotatedGeneratorDesc.yieldType(), node, function);
        }

        private void visitDelegatingYieldExpression(@NotNull PyYieldExpression node, @NotNull PyFunction function) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (function == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            assert (node.isDelegating());
            PyExpression yieldExpr = node.getExpression();
            if (yieldExpr == null) {
                return;
            }
            PyType delegateType = this.myTypeEvalContext.getType((PyTypedElement)yieldExpr);
            if (delegateType == null) {
                return;
            }
            PyTypingTypeProvider.GeneratorTypeDescriptor delegateDesc = PyTypingTypeProvider.GeneratorTypeDescriptor.fromGeneratorOrProtocol(delegateType, this.myTypeEvalContext);
            if (delegateDesc != null && delegateDesc.isAsync()) {
                String delegateName = PythonDocumentationProvider.getTypeName(delegateType, this.myTypeEvalContext);
                this.registerProblem((PsiElement)yieldExpr, PyPsiBundle.message("INSP.type.checker.yield.from.async.generator", delegateName));
                return;
            }
            if (this.checkIteratedValue(yieldExpr, false)) {
                return;
            }
            PyTypingTypeProvider.GeneratorTypeDescriptor annotatedGeneratorDesc = this.getGeneratorDescriptorFromAnnotation(function, node);
            if (annotatedGeneratorDesc == null) {
                return;
            }
            if (this.checkYieldType(annotatedGeneratorDesc.yieldType(), node, function)) {
                return;
            }
            PyType expectedSendType = annotatedGeneratorDesc.sendType();
            if (delegateDesc != null && !PyTypeChecker.match(delegateDesc.sendType(), expectedSendType, this.myTypeEvalContext)) {
                String expectedName = PythonDocumentationProvider.getVerboseTypeName(expectedSendType, this.myTypeEvalContext);
                String actualName = PythonDocumentationProvider.getTypeName(delegateDesc.sendType(), this.myTypeEvalContext);
                this.registerProblem((PsiElement)yieldExpr, PyPsiBundle.message("INSP.type.checker.yield.from.send.type.mismatch", expectedName, actualName));
            }
        }

        @Nullable
        private PyTypingTypeProvider.GeneratorTypeDescriptor getGeneratorDescriptorFromAnnotation(@NotNull PyFunction function, @NotNull PyYieldExpression yieldExpr) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if (yieldExpr == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            PyAnnotation annotation = function.getAnnotation();
            String typeCommentAnnotation = function.getTypeCommentAnnotation();
            if (annotation == null && typeCommentAnnotation == null) {
                return null;
            }
            PyType annotatedReturnType = this.myTypeEvalContext.getReturnType((PyCallable)function);
            if (annotatedReturnType == null) {
                return null;
            }
            PyTypingTypeProvider.GeneratorTypeDescriptor annotatedGeneratorDesc = PyTypingTypeProvider.GeneratorTypeDescriptor.fromGeneratorOrProtocol(annotatedReturnType, this.myTypeEvalContext);
            if (annotatedGeneratorDesc == null) {
                PyType inferredReturnType = function.getInferredReturnType(this.myTypeEvalContext);
                if (!PyTypeChecker.match(annotatedReturnType, inferredReturnType, this.myTypeEvalContext)) {
                    String expectedName = PythonDocumentationProvider.getVerboseTypeName(annotatedReturnType, this.myTypeEvalContext);
                    String actualName = PythonDocumentationProvider.getTypeName(inferredReturnType, this.myTypeEvalContext);
                    this.getHolder().problem((PsiElement)yieldExpr, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName)).fix((ModCommandAction)new PyMakeFunctionReturnTypeQuickFix(function, this.myTypeEvalContext)).register();
                }
                return null;
            }
            return annotatedGeneratorDesc;
        }

        private boolean checkYieldType(@Nullable PyType expectedYieldType, @NotNull PyYieldExpression node, @NotNull PyFunction function) {
            PyType thisYieldType;
            if (node == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            if (function == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            if (!PyTypeChecker.match(expectedYieldType, thisYieldType = node.getYieldType(this.myTypeEvalContext), this.myTypeEvalContext)) {
                PyExpression yieldExpr = node.getExpression();
                String expectedName = PythonDocumentationProvider.getVerboseTypeName(expectedYieldType, this.myTypeEvalContext);
                String actualName = PythonDocumentationProvider.getTypeName(thisYieldType, this.myTypeEvalContext);
                this.getHolder().problem((PsiElement)(yieldExpr != null ? yieldExpr : node), PyPsiBundle.message("INSP.type.checker.yield.type.mismatch", expectedName, actualName)).fix((ModCommandAction)new PyMakeFunctionReturnTypeQuickFix(function, this.myTypeEvalContext)).register();
                return true;
            }
            return false;
        }

        @Nullable
        public static PyType getExpectedReturnStatementType(@NotNull PyFunction function, @NotNull TypeEvalContext typeEvalContext) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            if (typeEvalContext == null) {
                Visitor.$$$reportNull$$$0(17);
            }
            PyType returnType = typeEvalContext.getReturnType((PyCallable)function);
            if (function.isGenerator()) {
                PyTypingTypeProvider.GeneratorTypeDescriptor generatorDesc = PyTypingTypeProvider.GeneratorTypeDescriptor.fromGeneratorOrProtocol(returnType, typeEvalContext);
                if (generatorDesc != null) {
                    return generatorDesc.returnType();
                }
                return null;
            }
            if (function.isAsync()) {
                return (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(returnType));
            }
            return returnType;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(18);
            }
            this.checkClassAttributeAccess(node);
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            PyType actual;
            Ref<PyType> dunderSetValueType;
            if (node == null) {
                Visitor.$$$reportNull$$$0(19);
            }
            this.checkClassAttributeAccess(node);
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (owner instanceof PyClass) {
                return;
            }
            PyExpression value = node.findAssignedValue();
            if (value == null) {
                return;
            }
            boolean descriptor = false;
            PyType expected = this.myTypeEvalContext.getType((PyTypedElement)node);
            Ref<PyType> classAttrType = this.getClassAttributeType(node);
            if (classAttrType != null && (dunderSetValueType = PyDescriptorTypeUtil.getExpectedValueTypeForDunderSet(node, (PyType)classAttrType.get(), this.myTypeEvalContext)) != null) {
                expected = (PyType)dunderSetValueType.get();
                descriptor = true;
            }
            if (expected instanceof PyTypedDictType) {
                PyTypedDictType expectedTypedDictType = (PyTypedDictType)expected;
                if (PyTypedDictType.isDictExpression(value, this.myTypeEvalContext)) {
                    this.reportTypedDictProblems(expectedTypedDictType, value);
                    return;
                }
            }
            if (!PyTypeChecker.match(expected, actual = this.tryPromotingType(value, expected), this.myTypeEvalContext)) {
                String expectedName = PythonDocumentationProvider.getVerboseTypeName(expected, this.myTypeEvalContext);
                String actualName = PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext);
                this.registerProblem((PsiElement)value, descriptor ? PyPsiBundle.message("INSP.type.checker.expected.type.from.dunder.set.got.type.instead", expectedName, actualName) : PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName));
            }
        }

        private <T extends PyQualifiedExpression & PyReferenceOwner> void checkClassAttributeAccess(@NotNull T expression) {
            PyType targetType;
            PyTargetExpression target;
            PsiElement resolved;
            PyClassType classType;
            PyType qualifierType;
            PyExpression qualifier;
            if (expression == null) {
                Visitor.$$$reportNull$$$0(20);
            }
            if ((qualifier = expression.getQualifier()) != null && (qualifierType = this.myTypeEvalContext.getType((PyTypedElement)qualifier)) instanceof PyClassType && (classType = (PyClassType)qualifierType).isDefinition() && (resolved = ((PyReferenceOwner)expression).getReference(PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext)).resolve()) instanceof PyTargetExpression && PyUtil.isClassAttribute((PsiElement)(target = (PyTargetExpression)resolved)) && Visitor.requiresTypeSpecialization(targetType = this.myTypeEvalContext.getType((PyTypedElement)target))) {
                ASTNode nameElement = expression.getNameElement();
                this.registerProblem(nameElement == null ? null : nameElement.getPsi(), PyPsiBundle.message("INSP.type.checker.access.to.generic.instance.variables.via.class.is.ambiguous", new Object[0]));
            }
        }

        private static boolean requiresTypeSpecialization(@Nullable PyType type) {
            PyCollectionType collectionType;
            PyTypeParameterType typeParameterType;
            if (type instanceof PyTypeParameterType && (typeParameterType = (PyTypeParameterType)type).getDefaultType() == null && !(type instanceof PySelfType)) {
                return true;
            }
            return type instanceof PyCollectionType && ContainerUtil.exists((collectionType = (PyCollectionType)type).getElementTypes(), Visitor::requiresTypeSpecialization);
        }

        @Nullable
        private Ref<PyType> getClassAttributeType(@NotNull PyTargetExpression attribute) {
            PyTargetExpression attrDefinition;
            if (attribute == null) {
                Visitor.$$$reportNull$$$0(21);
            }
            if (!attribute.isQualified()) {
                return null;
            }
            PsiElement definition = attribute.getReference(PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext)).resolve();
            if (!(definition instanceof PyTargetExpression) || !PyUtil.isAttribute(attrDefinition = (PyTargetExpression)definition)) {
                return null;
            }
            return Ref.create((Object)this.myTypeEvalContext.getType((PyTypedElement)attrDefinition));
        }

        private void reportTypedDictProblems(@NotNull PyTypedDictType expectedType, @NotNull PyExpression expression) {
            if (expectedType == null) {
                Visitor.$$$reportNull$$$0(22);
            }
            if (expression == null) {
                Visitor.$$$reportNull$$$0(23);
            }
            @NotNull PyTypedDictType.TypeCheckingResult result = new PyTypedDictType.TypeCheckingResult();
            PyTypedDictType.checkExpression(expectedType, expression, this.myTypeEvalContext, result);
            result.getValueTypeErrors().forEach(error -> this.registerProblem((PsiElement)error.getActualExpression(), PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", PythonDocumentationProvider.getTypeName(error.getExpectedType(), this.myTypeEvalContext), PythonDocumentationProvider.getTypeName(error.getActualType(), this.myTypeEvalContext))));
            result.getExtraKeys().forEach(error -> this.registerProblem((PsiElement)Objects.requireNonNullElse(error.getActualExpression(), expression), PyPsiBundle.message("INSP.type.checker.typed.dict.extra.key", error.getKey(), error.getExpectedTypedDictName())));
            result.getMissingKeys().forEach(error -> this.registerProblem((PsiElement)(error.getActualExpression() != null ? error.getActualExpression() : expression), PyPsiBundle.message("INSP.type.checker.typed.dict.missing.keys", error.getExpectedTypedDictName(), error.getMissingKeys().size(), StringUtil.join(error.getMissingKeys(), s -> String.format("'%s'", s), (String)", "))));
        }

        @Nullable
        private PyType tryPromotingType(@NotNull PyExpression value, @Nullable PyType expected) {
            PyType promotedToLiteral;
            if (value == null) {
                Visitor.$$$reportNull$$$0(24);
            }
            if ((promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(value, expected, this.myTypeEvalContext, null)) != null) {
                return promotedToLiteral;
            }
            return this.myTypeEvalContext.getType((PyTypedElement)value);
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(25);
            }
            PyAnnotation annotation = node.getAnnotation();
            String typeCommentAnnotation = node.getTypeCommentAnnotation();
            if (annotation != null || typeCommentAnnotation != null) {
                List returnPoints;
                boolean hasImplicitReturns;
                PyType expected = Visitor.getExpectedReturnStatementType(node, this.myTypeEvalContext);
                PyClassType noneType = PyBuiltinCache.getInstance((PsiElement)node).getNoneType();
                boolean returnsNone = PyNoneTypeKt.isNoneType(expected);
                boolean returnsOptional = PyTypeChecker.match(expected, (PyType)noneType, this.myTypeEvalContext);
                if (expected != null && !returnsOptional && !PyUtil.isEmptyFunction(node) && (hasImplicitReturns = ContainerUtil.exists((Iterable)(returnPoints = node.getReturnPoints(this.myTypeEvalContext)), it -> !(it instanceof PyReturnStatement)))) {
                    PyExpression annotationValue;
                    String expectedName = PythonDocumentationProvider.getVerboseTypeName(expected, this.myTypeEvalContext);
                    String actualName = PythonDocumentationProvider.getTypeName(node.getReturnStatementType(this.myTypeEvalContext), this.myTypeEvalContext);
                    Object object = annotationValue = annotation != null ? annotation.getValue() : node.getTypeComment();
                    if (annotationValue != null) {
                        this.getHolder().problem((PsiElement)annotationValue, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName)).fix((ModCommandAction)new PyMakeFunctionReturnTypeQuickFix(node, this.myTypeEvalContext)).register();
                    }
                }
                PyType annotatedType = this.myTypeEvalContext.getReturnType((PyCallable)node);
                if (PyUtil.isInitMethod((PsiElement)node) && !returnsNone && !(annotatedType instanceof PyNeverType)) {
                    this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), PyPsiBundle.message("INSP.type.checker.init.should.return.none", new Object[0]));
                }
                if (node.isGenerator()) {
                    PyTypingTypeProvider.GeneratorTypeDescriptor generatorDesc = PyTypingTypeProvider.GeneratorTypeDescriptor.fromGeneratorOrProtocol(annotatedType, this.myTypeEvalContext);
                    boolean shouldBeAsync = node.isAsync() && node.isAsyncAllowed();
                    boolean wrongSyncAsync = generatorDesc != null && generatorDesc.isAsync() != shouldBeAsync;
                    PyType inferredType = node.getInferredReturnType(this.myTypeEvalContext);
                    if (wrongSyncAsync || generatorDesc == null && !PyTypeChecker.match(annotatedType, inferredType, this.myTypeEvalContext)) {
                        PyExpression annotationValue;
                        String expectedName = PythonDocumentationProvider.getVerboseTypeName(inferredType, this.myTypeEvalContext);
                        String actualName = PythonDocumentationProvider.getTypeName(annotatedType, this.myTypeEvalContext);
                        Object object = annotationValue = annotation != null ? annotation.getValue() : node.getTypeComment();
                        if (annotationValue != null) {
                            this.getHolder().problem((PsiElement)annotationValue, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName)).fix((ModCommandAction)new PyMakeFunctionReturnTypeQuickFix(node, this.myTypeEvalContext)).register();
                        }
                    }
                }
            }
        }

        public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(26);
            }
            super.visitPyComprehensionElement(node);
            for (PyComprehensionForComponent forComponent : node.getForComponents()) {
                this.checkIteratedValue((PyExpression)forComponent.getIteratedList(), forComponent.isAsync());
            }
        }

        private void checkCallSite(@NotNull PyCallSiteExpression callSite) {
            List calleesResults;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(27);
            }
            if (!ContainerUtil.exists((Iterable)(calleesResults = ((StreamEx)StreamEx.of(PyCallExpressionHelper.mapArguments(callSite, this.getResolveContext())).filter(mapping -> mapping.isComplete())).map(mapping -> this.analyzeCallee(callSite, (PyCallExpression.PyArgumentsMapping)mapping)).nonNull().toList()), calleeResults -> Visitor.isMatched(calleeResults))) {
                PyTypeCheckerInspectionProblemRegistrar.registerProblem(this, callSite, Visitor.getArgumentTypes(calleesResults), calleesResults, this.myTypeEvalContext);
            }
        }

        private boolean checkIteratedValue(@Nullable PyExpression iteratedValue, boolean isAsync) {
            if (iteratedValue != null) {
                String iterableClassName;
                PyType type = this.myTypeEvalContext.getType((PyTypedElement)iteratedValue);
                String string = iterableClassName = isAsync ? "AsyncIterable" : "Iterable";
                if (type != null && !PyTypeChecker.isUnknown(type, this.myTypeEvalContext) && !PyABCUtil.isSubtype(type, iterableClassName, this.myTypeEvalContext)) {
                    String typeName = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                    String qualifiedName = "collections." + iterableClassName;
                    this.registerProblem((PsiElement)iteratedValue, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", qualifiedName, typeName));
                    return true;
                }
            }
            return false;
        }

        private void checkContextManagerValue(@Nullable PyExpression iteratedValue, boolean isAsync) {
            if (iteratedValue != null) {
                String contextManagerClassName;
                PyType type = this.myTypeEvalContext.getType((PyTypedElement)iteratedValue);
                String string = contextManagerClassName = isAsync ? "AbstractAsyncContextManager" : "AbstractContextManager";
                if (type != null && !PyTypeChecker.isUnknown(type, this.myTypeEvalContext) && !PyABCUtil.isSubtype(type, contextManagerClassName, this.myTypeEvalContext)) {
                    String typeName = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                    String qualifiedName = "contextlib." + contextManagerClassName;
                    this.registerProblem((PsiElement)iteratedValue, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", qualifiedName, typeName));
                }
            }
        }

        @Nullable
        private AnalyzeCalleeResults analyzeCallee(@NotNull PyCallSiteExpression callSite, @NotNull PyCallExpression.PyArgumentsMapping mapping) {
            PyCallableParameter selfParameter;
            PyClassType receiverType;
            PyType pyType;
            PyCallableType callableType;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(28);
            }
            if (mapping == null) {
                Visitor.$$$reportNull$$$0(29);
            }
            if ((callableType = mapping.getCallableType()) == null) {
                return null;
            }
            ArrayList<AnalyzeArgumentResult> result = new ArrayList<AnalyzeArgumentResult>();
            ArrayList<UnexpectedArgumentForParamSpec> unexpectedArgumentForParamSpecs = new ArrayList<UnexpectedArgumentForParamSpec>();
            ArrayList<UnfilledParameterFromParamSpec> unfilledParameterFromParamSpecs = new ArrayList<UnfilledParameterFromParamSpec>();
            PyExpression receiver = callSite.getReceiver(callableType.getCallable());
            PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiver, this.myTypeEvalContext);
            if (PyUtil.isInitMethod((PsiElement)callableType.getCallable()) && receiver != null && (pyType = this.myTypeEvalContext.getType((PyTypedElement)receiver)) instanceof PyClassType && (receiverType = (PyClassType)pyType).isDefinition() && (selfParameter = (PyCallableParameter)ContainerUtil.getFirstItem((List)mapping.getImplicitParameters())) != null) {
                PyClassType actual = receiverType.toInstance();
                PyType expected = selfParameter.getArgumentType(this.myTypeEvalContext);
                boolean matched = this.matchParameterAndArgument(expected, (PyType)actual, receiver, substitutions);
                result.add(new AnalyzeArgumentResult(receiver, expected, this.substituteGenerics(expected, substitutions), (PyType)actual, matched));
            }
            Map mappedParameters = mapping.getMappedParameters();
            Map regularMappedParameters = PyCallExpressionHelper.getRegularMappedParameters(mappedParameters);
            for (Map.Entry entry : regularMappedParameters.entrySet()) {
                PyType actual;
                PyCallableParameter parameter;
                PyType expected;
                PyExpression argument = (PyExpression)entry.getKey();
                PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(argument, expected = (parameter = entry.getValue()).getArgumentType(this.myTypeEvalContext), this.myTypeEvalContext, substitutions);
                PyType pyType2 = actual = promotedToLiteral != null ? promotedToLiteral : this.myTypeEvalContext.getType((PyTypedElement)argument);
                if (expected instanceof PyParamSpecType) {
                    List allArguments = callSite.getArguments(callableType.getCallable());
                    this.analyzeParamSpec((PyParamSpecType)expected, allArguments, substitutions, result, unexpectedArgumentForParamSpecs, unfilledParameterFromParamSpecs);
                    break;
                }
                if (expected instanceof PyConcatenateType) {
                    PyConcatenateType concatenateType = (PyConcatenateType)expected;
                    List allArguments = callSite.getArguments(callableType.getCallable());
                    if (allArguments.isEmpty()) break;
                    List<PyType> firstExpectedTypes = concatenateType.getFirstTypes();
                    int argumentRightBound = Math.min(firstExpectedTypes.size(), allArguments.size());
                    List<PyExpression> firstArguments = allArguments.subList(0, argumentRightBound);
                    this.matchArgumentsAndTypes(firstArguments, firstExpectedTypes, substitutions, result);
                    if (argumentRightBound >= allArguments.size()) break;
                    PyParamSpecType paramSpec = concatenateType.getParamSpec();
                    List<PyExpression> restArguments = allArguments.subList(argumentRightBound, allArguments.size());
                    if (paramSpec == null) break;
                    this.analyzeParamSpec(paramSpec, restArguments, substitutions, result, unexpectedArgumentForParamSpecs, unfilledParameterFromParamSpecs);
                    break;
                }
                boolean matched = this.matchParameterAndArgument(expected, actual, argument, substitutions);
                result.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
            PyCallableParameter positionalContainer = PyCallExpressionHelper.getMappedPositionalContainer(mappedParameters);
            List<PyExpression> positionalArguments = PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(mappedParameters);
            PyCallableParameter keywordContainer = PyCallExpressionHelper.getMappedKeywordContainer(mappedParameters);
            List<PyExpression> keywordArguments = PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(mappedParameters);
            List allArguments = ContainerUtil.concat(positionalArguments, keywordArguments);
            PyParamSpecType paramSpecType = this.getParamSpecTypeFromContainerParameters(keywordContainer, positionalContainer);
            if (paramSpecType != null) {
                this.analyzeParamSpec(paramSpecType, allArguments, substitutions, result, unexpectedArgumentForParamSpecs, unfilledParameterFromParamSpecs);
            } else {
                if (positionalContainer != null) {
                    result.addAll(this.analyzeContainerMapping(positionalContainer, positionalArguments, substitutions));
                }
                if (keywordContainer != null) {
                    result.addAll(this.analyzeContainerMapping(keywordContainer, keywordArguments, substitutions));
                }
            }
            ArrayList<UnfilledPositionalVararg> unfilledPositionalVarargs = new ArrayList<UnfilledPositionalVararg>();
            for (PyCallableParameter unmappedContainer : mapping.getUnmappedContainerParameters()) {
                PyUnpackedTupleType unpackedTuple;
                PyType expandedVararg;
                PyType containerType = unmappedContainer.getArgumentType(this.myTypeEvalContext);
                if (unmappedContainer.getName() == null || !(containerType instanceof PyPositionalVariadicType) || !((expandedVararg = PyTypeChecker.substitute(containerType, substitutions, this.myTypeEvalContext)) instanceof PyUnpackedTupleType) || (unpackedTuple = (PyUnpackedTupleType)expandedVararg).isUnbound()) continue;
                unfilledPositionalVarargs.add(new UnfilledPositionalVararg(unmappedContainer.getName(), PythonDocumentationProvider.getTypeName(expandedVararg, this.myTypeEvalContext)));
            }
            return new AnalyzeCalleeResults(callableType, callableType.getCallable(), result, unexpectedArgumentForParamSpecs, unfilledParameterFromParamSpecs, unfilledPositionalVarargs);
        }

        private void analyzeParamSpec(@NotNull PyParamSpecType paramSpec, @NotNull List<PyExpression> arguments, @NotNull PyTypeChecker.GenericSubstitutions substitutions, @NotNull List<AnalyzeArgumentResult> result, @NotNull List<UnexpectedArgumentForParamSpec> unexpectedArgumentForParamSpecs, @NotNull List<UnfilledParameterFromParamSpec> unfilledParameterFromParamSpecs) {
            List<PyCallableParameter> unmappedParameters;
            PyCallableParameterListType paramSpecSubst;
            if (paramSpec == null) {
                Visitor.$$$reportNull$$$0(30);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(31);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(32);
            }
            if (result == null) {
                Visitor.$$$reportNull$$$0(33);
            }
            if (unexpectedArgumentForParamSpecs == null) {
                Visitor.$$$reportNull$$$0(34);
            }
            if (unfilledParameterFromParamSpecs == null) {
                Visitor.$$$reportNull$$$0(35);
            }
            if ((paramSpecSubst = PyUtil.as(substitutions.getParamSpecs().get(paramSpec), PyCallableParameterListType.class)) == null) {
                return;
            }
            ArgumentMappingResults mapping = PyCallExpressionHelper.analyzeArguments(arguments, paramSpecSubst.getParameters(), this.myTypeEvalContext);
            for (Map.Entry<PyExpression, PyCallableParameter> item : mapping.getMappedParameters().entrySet()) {
                PyExpression argument = item.getKey();
                PyCallableParameter parameter = item.getValue();
                PyType argType = this.myTypeEvalContext.getType((PyTypedElement)argument);
                PyType paramType = parameter.getType(this.myTypeEvalContext);
                boolean matched = this.matchParameterAndArgument(paramType, argType, argument, substitutions);
                result.add(new AnalyzeArgumentResult(argument, paramType, this.substituteGenerics(paramType, substitutions), argType, matched));
            }
            if (!mapping.getUnmappedArguments().isEmpty()) {
                for (PyExpression argument : mapping.getUnmappedArguments()) {
                    unexpectedArgumentForParamSpecs.add(new UnexpectedArgumentForParamSpec(argument, paramSpec));
                }
            }
            if (!(unmappedParameters = mapping.getUnmappedParameters()).isEmpty()) {
                unfilledParameterFromParamSpecs.add(new UnfilledParameterFromParamSpec(unmappedParameters.get(0), paramSpec));
            }
        }

        private void matchArgumentsAndTypes(@NotNull List<PyExpression> arguments, @NotNull List<PyType> types, @NotNull PyTypeChecker.GenericSubstitutions substitutions, @NotNull List<AnalyzeArgumentResult> result) {
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(36);
            }
            if (types == null) {
                Visitor.$$$reportNull$$$0(37);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(38);
            }
            if (result == null) {
                Visitor.$$$reportNull$$$0(39);
            }
            int size = Math.min(arguments.size(), types.size());
            for (int i = 0; i < size; ++i) {
                PyType expected = types.get(i);
                PyExpression argument = arguments.get(i);
                PyType actual = this.myTypeEvalContext.getType((PyTypedElement)argument);
                boolean matched = this.matchParameterAndArgument(expected, actual, argument, substitutions);
                result.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
        }

        @NotNull
        private List<AnalyzeArgumentResult> analyzeContainerMapping(@NotNull PyCallableParameter container, @NotNull List<PyExpression> arguments, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (container == null) {
                Visitor.$$$reportNull$$$0(40);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(41);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(42);
            }
            PyType expected = container.getArgumentType(this.myTypeEvalContext);
            if (container.isPositionalContainer() && expected instanceof PyPositionalVariadicType) {
                PyUnpackedTupleType argumentTypes = PyUnpackedTupleTypeImpl.create(ContainerUtil.map(arguments, arg_0 -> ((TypeEvalContext)this.myTypeEvalContext).getType(arg_0)));
                boolean matched = this.matchParameterAndArgument(expected, (PyType)argumentTypes, null, substitutions);
                List list = ContainerUtil.map(arguments, argument -> {
                    PyType expectedWithSubstitutions = this.substituteGenerics(expected, substitutions);
                    return new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, (PyType)argumentTypes, matched);
                });
                if (list == null) {
                    Visitor.$$$reportNull$$$0(43);
                }
                return list;
            }
            if (PyTypeChecker.hasGenerics(expected, this.myTypeEvalContext)) {
                if (container.isKeywordContainer()) {
                    PyType actualJoin = PyUnionType.union(ContainerUtil.map(arguments, arg_0 -> ((TypeEvalContext)this.myTypeEvalContext).getType(arg_0)));
                    this.matchParameterAndArgument(expected, actualJoin, null, substitutions);
                }
                List list = ContainerUtil.map(arguments, argument -> {
                    PyType actual = this.myTypeEvalContext.getType((PyTypedElement)argument);
                    boolean matched = this.matchParameterAndArgument(expected, actual, (PyExpression)argument, substitutions);
                    return new AnalyzeArgumentResult((PyExpression)argument, expected, this.substituteGenerics(expected, substitutions), actual, matched);
                });
                if (list == null) {
                    Visitor.$$$reportNull$$$0(44);
                }
                return list;
            }
            List list = ContainerUtil.map(arguments, argument -> {
                PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral((PyExpression)argument, expected, this.myTypeEvalContext, substitutions);
                PyType actual = promotedToLiteral != null ? promotedToLiteral : this.myTypeEvalContext.getType((PyTypedElement)argument);
                boolean matched = this.matchParameterAndArgument(expected, actual, (PyExpression)argument, substitutions);
                PyType expectedWithSubstitutions = this.substituteGenerics(expected, substitutions);
                return new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched);
            });
            if (list == null) {
                Visitor.$$$reportNull$$$0(45);
            }
            return list;
        }

        @Nullable
        private PyParamSpecType getParamSpecTypeFromContainerParameters(@Nullable PyCallableParameter positionalContainer, @Nullable PyCallableParameter keywordContainer) {
            if (positionalContainer == null && keywordContainer == null) {
                return null;
            }
            PyCallableParameter container = Objects.requireNonNullElse(positionalContainer, keywordContainer);
            return PyUtil.as(container.getType(this.myTypeEvalContext), PyParamSpecType.class);
        }

        private boolean matchParameterAndArgument(@Nullable PyType parameterType, @Nullable PyType argumentType, @Nullable PyExpression argument, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(46);
            }
            argument = PyUtil.peelArgument(argument);
            if (parameterType instanceof PyTypedDictType) {
                PyTypedDictType expectedTypedDictType = (PyTypedDictType)parameterType;
                if (argument != null && PyTypedDictType.isDictExpression(argument, this.myTypeEvalContext)) {
                    this.reportTypedDictProblems(expectedTypedDictType, argument);
                    return true;
                }
            }
            return PyTypeChecker.match(parameterType, argumentType, this.myTypeEvalContext, substitutions) && !PyProtocolsKt.matchingProtocolDefinitions(parameterType, argumentType, this.myTypeEvalContext);
        }

        @Nullable
        private PyType substituteGenerics(@Nullable PyType expectedArgumentType, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(47);
            }
            return PyTypeChecker.hasGenerics(expectedArgumentType, this.myTypeEvalContext) ? PyTypeChecker.substitute(expectedArgumentType, substitutions, this.myTypeEvalContext) : null;
        }

        private static boolean isMatched(@NotNull AnalyzeCalleeResults calleeResults) {
            if (calleeResults == null) {
                Visitor.$$$reportNull$$$0(48);
            }
            return ContainerUtil.all(calleeResults.getResults(), AnalyzeArgumentResult::isMatched) && calleeResults.getUnmatchedArguments().isEmpty() && calleeResults.getUnmatchedParameters().isEmpty() && calleeResults.getUnfilledPositionalVarargs().isEmpty();
        }

        @NotNull
        private static List<PyType> getArgumentTypes(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(49);
            }
            List list = ContainerUtil.map((Collection)calleesResults.stream().map(AnalyzeCalleeResults::getResults).max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList()), AnalyzeArgumentResult::getActualType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(50);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 43, 44, 45, 50 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 43: 
                case 44: 
                case 45: 
                case 50: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 11: 
                case 12: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldExpr";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 20: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedType";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSite";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpec";
                    break;
                }
                case 31: 
                case 36: 
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 32: 
                case 38: 
                case 42: 
                case 46: 
                case 47: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 33: 
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unexpectedArgumentForParamSpecs";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unfilledParameterFromParamSpecs";
                    break;
                }
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 40: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 48: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleeResults";
                    break;
                }
                case 49: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleesResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHolder";
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    objectArray = objectArray2;
                    objectArray2[1] = "analyzeContainerMapping";
                    break;
                }
                case 50: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 43: 
                case 44: 
                case 45: 
                case 50: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyBinaryExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPySubscriptionExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyForStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyWithStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyReturnStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyYieldExpression";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDelegatingYieldExpression";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getGeneratorDescriptorFromAnnotation";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "checkYieldType";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedReturnStatementType";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyReferenceExpression";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyTargetExpression";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "checkClassAttributeAccess";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassAttributeType";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "reportTypedDictProblems";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "tryPromotingType";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFunction";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyComprehensionElement";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCallSite";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeCallee";
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeParamSpec";
                    break;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "matchArgumentsAndTypes";
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeContainerMapping";
                    break;
                }
                case 46: {
                    objectArray = objectArray;
                    objectArray[2] = "matchParameterAndArgument";
                    break;
                }
                case 47: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteGenerics";
                    break;
                }
                case 48: {
                    objectArray = objectArray;
                    objectArray[2] = "isMatched";
                    break;
                }
                case 49: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgumentTypes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 43, 44, 45, 50 -> new IllegalStateException(string);
            };
        }
    }

    record UnfilledPositionalVararg(@NotNull String varargName, @NotNull String expectedTypes) {
        @NotNull
        private final String varargName;
        @NotNull
        private final String expectedTypes;

        UnfilledPositionalVararg(@NotNull String varargName, @NotNull String expectedTypes) {
            if (varargName == null) {
                UnfilledPositionalVararg.$$$reportNull$$$0(0);
            }
            if (expectedTypes == null) {
                UnfilledPositionalVararg.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String varargName() {
            String string = this.varargName;
            if (string == null) {
                UnfilledPositionalVararg.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String expectedTypes() {
            String string = this.expectedTypes;
            if (string == null) {
                UnfilledPositionalVararg.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varargName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnfilledPositionalVararg";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnfilledPositionalVararg";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "varargName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expectedTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class UnexpectedArgumentForParamSpec {
        private final PyExpression myArgument;
        private final PyParamSpecType myParamSpecType;

        UnexpectedArgumentForParamSpec(@NotNull PyExpression argument, @NotNull PyParamSpecType paramSpecType) {
            if (argument == null) {
                UnexpectedArgumentForParamSpec.$$$reportNull$$$0(0);
            }
            if (paramSpecType == null) {
                UnexpectedArgumentForParamSpec.$$$reportNull$$$0(1);
            }
            this.myArgument = argument;
            this.myParamSpecType = paramSpecType;
        }

        @NotNull
        PyExpression getArgument() {
            PyExpression pyExpression = this.myArgument;
            if (pyExpression == null) {
                UnexpectedArgumentForParamSpec.$$$reportNull$$$0(2);
            }
            return pyExpression;
        }

        @NotNull
        PyParamSpecType getParamSpecType() {
            PyParamSpecType pyParamSpecType = this.myParamSpecType;
            if (pyParamSpecType == null) {
                UnexpectedArgumentForParamSpec.$$$reportNull$$$0(3);
            }
            return pyParamSpecType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnexpectedArgumentForParamSpec";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnexpectedArgumentForParamSpec";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgument";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class UnfilledParameterFromParamSpec {
        private final PyCallableParameter myParameter;
        private final PyParamSpecType myParamSpecType;

        UnfilledParameterFromParamSpec(@NotNull PyCallableParameter parameter, @NotNull PyParamSpecType paramSpecType) {
            if (parameter == null) {
                UnfilledParameterFromParamSpec.$$$reportNull$$$0(0);
            }
            if (paramSpecType == null) {
                UnfilledParameterFromParamSpec.$$$reportNull$$$0(1);
            }
            this.myParameter = parameter;
            this.myParamSpecType = paramSpecType;
        }

        @NotNull
        public PyCallableParameter getParameter() {
            PyCallableParameter pyCallableParameter = this.myParameter;
            if (pyCallableParameter == null) {
                UnfilledParameterFromParamSpec.$$$reportNull$$$0(2);
            }
            return pyCallableParameter;
        }

        @NotNull
        PyParamSpecType getParamSpecType() {
            PyParamSpecType pyParamSpecType = this.myParamSpecType;
            if (pyParamSpecType == null) {
                UnfilledParameterFromParamSpec.$$$reportNull$$$0(3);
            }
            return pyParamSpecType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnfilledParameterFromParamSpec";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$UnfilledParameterFromParamSpec";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class AnalyzeArgumentResult {
        @NotNull
        private final PyExpression myArgument;
        @Nullable
        private final PyType myExpectedType;
        @Nullable
        private final PyType myExpectedTypeAfterSubstitution;
        @Nullable
        private final PyType myActualType;
        private final boolean myIsMatched;

        AnalyzeArgumentResult(@NotNull PyExpression argument, @Nullable PyType expectedType, @Nullable PyType expectedTypeAfterSubstitution, @Nullable PyType actualType, boolean isMatched) {
            if (argument == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(0);
            }
            this.myArgument = argument;
            this.myExpectedType = expectedType;
            this.myExpectedTypeAfterSubstitution = expectedTypeAfterSubstitution;
            this.myActualType = actualType;
            this.myIsMatched = isMatched;
        }

        @NotNull
        public PyExpression getArgument() {
            PyExpression pyExpression = this.myArgument;
            if (pyExpression == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(1);
            }
            return pyExpression;
        }

        @Nullable
        public PyType getExpectedType() {
            return this.myExpectedType;
        }

        @Nullable
        public PyType getExpectedTypeAfterSubstitution() {
            return this.myExpectedTypeAfterSubstitution;
        }

        @Nullable
        public PyType getActualType() {
            return this.myActualType;
        }

        public boolean isMatched() {
            return this.myIsMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class AnalyzeCalleeResults {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyCallable myCallable;
        @NotNull
        private final List<AnalyzeArgumentResult> myResults;
        @NotNull
        private final List<UnexpectedArgumentForParamSpec> myUnexpectedArgumentForParamSpecs;
        @NotNull
        private final List<UnfilledParameterFromParamSpec> myUnfilledParameterFromParamSpecs;
        @NotNull
        private final List<UnfilledPositionalVararg> myUnfilledPositionalVarargs;

        AnalyzeCalleeResults(@NotNull PyCallableType callableType, @Nullable PyCallable callable, @NotNull List<AnalyzeArgumentResult> results, @NotNull List<UnexpectedArgumentForParamSpec> unexpectedArgumentForParamSpecs, @NotNull List<UnfilledParameterFromParamSpec> unfilledParameterFromParamSpecs, @NotNull List<UnfilledPositionalVararg> unfilledPositionalVarargs) {
            if (callableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(0);
            }
            if (results == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(1);
            }
            if (unexpectedArgumentForParamSpecs == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(2);
            }
            if (unfilledParameterFromParamSpecs == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(3);
            }
            if (unfilledPositionalVarargs == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(4);
            }
            this.myCallableType = callableType;
            this.myCallable = callable;
            this.myResults = results;
            this.myUnexpectedArgumentForParamSpecs = unexpectedArgumentForParamSpecs;
            this.myUnfilledParameterFromParamSpecs = unfilledParameterFromParamSpecs;
            this.myUnfilledPositionalVarargs = unfilledPositionalVarargs;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(5);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getCallable() {
            return this.myCallable;
        }

        @NotNull
        public List<AnalyzeArgumentResult> getResults() {
            List<AnalyzeArgumentResult> list = this.myResults;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        List<UnexpectedArgumentForParamSpec> getUnmatchedArguments() {
            List<UnexpectedArgumentForParamSpec> list = this.myUnexpectedArgumentForParamSpecs;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        List<UnfilledParameterFromParamSpec> getUnmatchedParameters() {
            List<UnfilledParameterFromParamSpec> list = this.myUnfilledParameterFromParamSpecs;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        List<UnfilledPositionalVararg> getUnfilledPositionalVarargs() {
            List<UnfilledPositionalVararg> list = this.myUnfilledPositionalVarargs;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unexpectedArgumentForParamSpecs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unfilledParameterFromParamSpecs";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unfilledPositionalVarargs";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmatchedArguments";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmatchedParameters";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnfilledPositionalVarargs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

