/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.PyDataFlowKt;
import com.jetbrains.python.codeInsight.controlflow.Reachability;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyUnreachableCodeInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyUnreachableCodeInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return (PsiElementVisitor)new PyInspectionVisitor(holder, typeEvalContext){

            public void visitPyStatementList(PyStatementList node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataFlowKt.getReachabilityForInspection(psiElement, typeEvalContext) == Reachability.UNREACHABLE) {
                    return;
                }
                PsiElement psiElement2 = (PsiElement)node;
                TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                if (PyDataFlowKt.getReachabilityForInspection(psiElement2, typeEvalContext2) == Reachability.UNREACHABLE) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unreachable.code", new Object[0]));
                }
            }

            public void visitPyStatement(PyStatement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataFlowKt.getReachabilityForInspection(psiElement, typeEvalContext) == Reachability.UNREACHABLE) {
                    return;
                }
                PsiElement psiElement2 = (PsiElement)node;
                TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                if (PyDataFlowKt.getReachabilityForInspection(psiElement2, typeEvalContext2) == Reachability.UNREACHABLE) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unreachable.code", new Object[0]));
                }
            }
        };
    }
}

