/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyConvertToRawStringQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "offsetInElement", "", "<init>", "(I)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyConvertToRawStringQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyConvertToRawStringQuickFix.kt\ncom/jetbrains/python/inspections/quickfix/PyConvertToRawStringQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class PyConvertToRawStringQuickFix
extends PsiUpdateModCommandQuickFix
implements LowPriorityAction {
    private final int offsetInElement;

    public PyConvertToRawStringQuickFix(int offsetInElement) {
        this.offsetInElement = offsetInElement;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.convert.to.raw.string", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Object v1;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            if (!(element instanceof PyStringLiteralExpression)) {
                return;
            }
            List list = ((PyStringLiteralExpression)element).getStringElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringElements(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                PyStringElement it = (PyStringElement)t;
                boolean bl = false;
                if (!it.getTextRangeInParent().contains(this.offsetInElement)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        PyStringElement pyStringElement = v1;
        if (pyStringElement == null) {
            return;
        }
        PyStringElement part = pyStringElement;
        String string = part.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        if (StringsKt.contains((CharSequence)string, (CharSequence)"r", (boolean)true)) {
            return;
        }
        String newText = "r" + part.getText();
        List list = PyElementGenerator.getInstance((Project)project).createStringLiteralAlreadyEscaped(newText).getStringElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringElements(...)");
        PyStringElement pyStringElement2 = (PyStringElement)CollectionsKt.firstOrNull((List)list);
        if (pyStringElement2 == null) {
            return;
        }
        PyStringElement newPart = pyStringElement2;
        part.replace((PsiElement)newPart);
    }
}

