/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.ast.impl.ValueHolder;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyImportElementStub;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportElementImpl
extends PyBaseElementImpl<PyImportElementStub>
implements PyImportElement {
    @Nullable
    private volatile @Nullable ValueHolder<@Nullable QualifiedName> myImportedQName;
    @Nullable
    private volatile @Nullable ValueHolder<@Nullable String> myAsName;
    @Nullable
    private volatile @Nullable ValueHolder<@Nullable String> myVisibleName;

    public PyImportElementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyImportElementImpl(PyImportElementStub stub) {
        this(stub, (IStubElementType)PyStubElementTypes.IMPORT_ELEMENT);
    }

    public PyImportElementImpl(PyImportElementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myImportedQName = null;
        this.myAsName = null;
        this.myVisibleName = null;
    }

    @Nullable
    public QualifiedName getImportedQName() {
        ValueHolder result = this.myImportedQName;
        if (result == null) {
            this.myImportedQName = result = new ValueHolder((Object)this.doGetImportedQName());
        }
        return (QualifiedName)result.value;
    }

    @Nullable
    private QualifiedName doGetImportedQName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            return stub.getImportedQName();
        }
        return super.getImportedQName();
    }

    public String getAsName() {
        ValueHolder result = this.myAsName;
        if (result == null) {
            this.myAsName = result = new ValueHolder((Object)this.doGetAsName());
        }
        return (String)result.value;
    }

    @Nullable
    private String doGetAsName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            return StringUtil.isEmpty((String)asName) ? null : asName;
        }
        return super.getAsName();
    }

    @Nullable
    public String getVisibleName() {
        ValueHolder result = this.myVisibleName;
        if (result == null) {
            this.myVisibleName = result = new ValueHolder((Object)this.doGetVisibleName());
        }
        return (String)result.value;
    }

    @Nullable
    private String doGetVisibleName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            if (!StringUtil.isEmpty((String)asName)) {
                return asName;
            }
            QualifiedName importedName = stub.getImportedQName();
            if (importedName != null && importedName.getComponentCount() > 0) {
                return (String)importedName.getComponents().get(0);
            }
            return null;
        }
        return super.getVisibleName();
    }

    @Nullable
    public PyStatement getContainingImportStatement() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            PsiElement parent = stub.getParentStub().getPsi();
            return parent instanceof PyStatement ? (PyStatement)parent : null;
        }
        return super.getContainingImportStatement();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            private String getRefName(String defaultName) {
                String refName;
                PyReferenceExpression ref = PyImportElementImpl.this.getImportReferenceExpression();
                if (ref != null && (refName = ref.getName()) != null) {
                    String string = refName;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = defaultName;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getPresentableText() {
                return this.getRefName("<none>");
            }

            public String getLocationString() {
                PyElement elt = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)PyImportElementImpl.this, (Class[])new Class[]{PyImportStatement.class, PyFromImportStatement.class});
                StringBuilder buf = new StringBuilder();
                if (elt != null) {
                    if (elt instanceof PyFromImportStatement) {
                        buf.append("from ");
                        PyReferenceExpression impSrc = ((PyFromImportStatement)elt).getImportSource();
                        if (impSrc != null) {
                            buf.append(PyPsiUtils.toPath((PyQualifiedExpression)impSrc));
                        } else {
                            buf.append("<?>");
                        }
                        buf.append(" import ");
                    } else {
                        buf.append("import ");
                    }
                    buf.append(this.getRefName("<?>"));
                } else {
                    buf.append("import?.. ");
                }
                PyTargetExpression asPart = PyImportElementImpl.this.getAsNameElement();
                if (asPart != null) {
                    buf.append(" as ").append(asPart.getName());
                }
                return buf.toString();
            }

            public Icon getIcon(boolean open) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl$1", "getRefName"));
            }
        };
    }

    public String getName() {
        return super.getName();
    }

    @NotNull
    public Iterable<PyElement> iterateNames() {
        String visibleName = this.getVisibleName();
        List<PyElement> list = visibleName != null ? Collections.singletonList(this) : Collections.emptyList();
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name) {
        if (name == null) {
            PyImportElementImpl.$$$reportNull$$$0(1);
        }
        return this.getElementsNamed(name, true);
    }

    @Nullable
    public PsiElement getElementNamed(String name, boolean resolveImportElement) {
        List<RatedResolveResult> results = this.getElementsNamed(name, resolveImportElement);
        return results.isEmpty() ? null : ((RatedResolveResult)RatedResolveResult.sorted(results).get(0)).getElement();
    }

    @NotNull
    private List<RatedResolveResult> getElementsNamed(@NotNull String name, boolean resolveImportElement) {
        String asName;
        if (name == null) {
            PyImportElementImpl.$$$reportNull$$$0(2);
        }
        if ((asName = this.getAsName()) != null) {
            if (!Objects.equals(name, asName)) {
                List<RatedResolveResult> list = Collections.emptyList();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (resolveImportElement) {
                List<RatedResolveResult> list = this.multiResolve();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<RatedResolveResult> list = ResolveResultList.to((PsiElement)this);
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        QualifiedName qName = this.getImportedQName();
        if (qName == null || qName.getComponentCount() == 0 || !((String)qName.getComponents().get(0)).equals(name)) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (qName.getComponentCount() == 1) {
            if (resolveImportElement) {
                List<RatedResolveResult> list = this.multiResolve();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(7);
                }
                return list;
            }
            List<RatedResolveResult> list = ResolveResultList.to((PsiElement)this);
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<RatedResolveResult> list = ResolveResultList.to(this.createImportedModule(name));
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public PsiElement resolve() {
        List<RatedResolveResult> results = this.multiResolve();
        return results.isEmpty() ? null : ((RatedResolveResult)RatedResolveResult.sorted(results).get(0)).getElement();
    }

    @NotNull
    public List<RatedResolveResult> multiResolve() {
        QualifiedName qName = this.getImportedQName();
        List<RatedResolveResult> list = qName == null ? Collections.emptyList() : ResolveImportUtil.multiResolveImportElement(this, qName);
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyImportElement((PyImportElement)this);
    }

    @Override
    public String toString() {
        QualifiedName qName = this.getImportedQName();
        return String.format("%s:%s", super.toString(), qName != null ? qName : "null");
    }

    @Nullable
    private PsiElement createImportedModule(String name) {
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            return new PyImportedModule(this, (PyFile)file, QualifiedName.fromComponents((String[])new String[]{name}));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyImportElementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyImportElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsNamed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementsNamed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

