/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.completion.OverwriteEqualsInsertHandler;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PyKeywordPatternReference
extends PsiReferenceBase.Poly<PyKeywordPattern> {
    public PyKeywordPatternReference(@NotNull PyKeywordPattern keywordPattern) {
        if (keywordPattern == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)keywordPattern, keywordPattern.getKeywordElement().getTextRangeInParent(), false);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PyClassPattern classPattern = ((PyKeywordPattern)this.getElement()).getContainingClassPattern();
        if (classPattern == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PyKeywordPatternReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PyKeywordPattern keywordPattern = (PyKeywordPattern)this.getElement();
        TypeEvalContext typeContext = TypeEvalContext.codeInsightFallback((Project)keywordPattern.getProject());
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeContext);
        ResolveResult[] resolveResultArray = PyKeywordPatternReference.resolveKeyword(classPattern, keywordPattern.getKeyword(), resolveContext);
        if (resolveResultArray == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    public static ResolveResult[] resolveKeyword(PyClassPattern classPattern, String keyword, PyResolveContext resolveContext) {
        return (ResolveResult[])StreamEx.of(PyKeywordPatternReference.resolveToClassTypes(classPattern, resolveContext)).flatMap(t -> StreamEx.of((Collection)ContainerUtil.notNullize((List)t.resolveMember(keyword, null, AccessDirection.READ, resolveContext)))).toArray((Object[])ResolveResult.EMPTY_ARRAY);
    }

    public Object @NotNull [] getVariants() {
        PyClassPattern classPattern = ((PyKeywordPattern)this.getElement()).getContainingClassPattern();
        if (classPattern == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                PyKeywordPatternReference.$$$reportNull$$$0(3);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        PyKeywordPattern keywordPattern = (PyKeywordPattern)this.getElement();
        TypeEvalContext typeContext = TypeEvalContext.codeCompletion((Project)keywordPattern.getProject(), (PsiFile)keywordPattern.getContainingFile());
        return PyKeywordPatternReference.collectClassAttributeVariants(this.getElement(), classPattern, typeContext);
    }

    static LookupElement @NotNull [] collectClassAttributeVariants(@NotNull PsiElement location, @NotNull PyClassPattern classPattern, @NotNull TypeEvalContext typeContext) {
        if (location == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(4);
        }
        if (classPattern == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(5);
        }
        if (typeContext == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(6);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeContext);
        LookupElement[] lookupElementArray = (LookupElement[])((StreamEx)StreamEx.of(PyKeywordPatternReference.resolveToClassTypes(classPattern, resolveContext)).flatMap(t -> StreamEx.of((Object[])t.getCompletionVariants("", location, new ProcessingContext()))).select(LookupElement.class).filter(e -> PyKeywordPatternReference.isMeaningfulClassPatternAttribute(e))).map(e -> new KeywordAttributeLookupDecorator((LookupElement)e, location)).toArray((Object[])LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(7);
        }
        return lookupElementArray;
    }

    private static boolean isMeaningfulClassPatternAttribute(@NotNull LookupElement lookupElement) {
        String lookupString2;
        if (lookupElement == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(8);
        }
        if ((lookupString2 = lookupElement.getLookupString()).contains(".") || PyUtilCore.isSpecialName((String)lookupString2)) {
            return false;
        }
        PsiElement elem = lookupElement.getPsiElement();
        if (elem instanceof PyClass) {
            return false;
        }
        return !(elem instanceof PyFunction) || ((PyFunction)elem).getProperty() != null;
    }

    @NotNull
    private static List<PyClassLikeType> resolveToClassTypes(@NotNull PyClassPattern classPattern, @NotNull PyResolveContext resolveContext) {
        if (classPattern == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(9);
        }
        if (resolveContext == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(10);
        }
        List<PsiElement> elements = PyUtil.multiResolveTopPriority((PsiElement)classPattern.getClassNameReference(), resolveContext);
        List list = StreamEx.of(elements).select(PyClass.class).map(e -> e.getType(resolveContext.getTypeEvalContext())).nonNull().map(PyInstantiableType::toInstance).toList();
        if (list == null) {
            PyKeywordPatternReference.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyKeywordPatternReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyKeywordPatternReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassAttributeVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToClassTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectClassAttributeVariants";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMeaningfulClassPatternAttribute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveToClassTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 11 -> new IllegalStateException(string);
        };
    }

    private static class KeywordAttributeLookupDecorator
    extends LookupElementDecorator<LookupElement> {
        private final boolean myAddSpacesAroundEq;

        private KeywordAttributeLookupDecorator(@NotNull LookupElement e, @NotNull PsiElement settingsAnchor) {
            if (e == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(0);
            }
            if (settingsAnchor == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(1);
            }
            super(e);
            this.myAddSpacesAroundEq = PythonCodeStyleService.getInstance().isSpaceAroundEqInKeywordArgument(settingsAnchor.getContainingFile());
        }

        @NotNull
        public String getLookupString() {
            String string = super.getLookupString() + (this.myAddSpacesAroundEq ? " = " : "=");
            if (string == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Set<String> getAllLookupStrings() {
            Set<String> set = Collections.singleton(this.getLookupString());
            if (set == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(3);
            }
            return set;
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            if (presentation == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(4);
            }
            super.renderElement(presentation);
            presentation.setItemText(this.getLookupString());
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                KeywordAttributeLookupDecorator.$$$reportNull$$$0(5);
            }
            OverwriteEqualsInsertHandler.INSTANCE.handleInsert(context, (LookupElement)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsAnchor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyKeywordPatternReference$KeywordAttributeLookupDecorator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyKeywordPatternReference$KeywordAttributeLookupDecorator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLookupStrings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "renderElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

