/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PythonModulePathCache
extends PythonPathCache
implements Disposable {
    public static PythonPathCache getInstance(Module module) {
        return (PythonPathCache)module.getService(PythonPathCache.class);
    }

    public PythonModulePathCache(final Module module) {
        MessageBusConnection connection = module.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.isCausedByWorkspaceModelChangesOnly()) {
                    return;
                }
                PythonModulePathCache.updateCacheForSdk(module);
                PythonModulePathCache.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonModulePathCache$1", "rootsChanged"));
            }
        });
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceListener(module));
        connection.subscribe(PyPackageManager.PACKAGE_MANAGER_TOPIC, sdk -> {
            Sdk moduleSdk = PythonSdkUtil.findPythonSdk((Module)module);
            if (sdk == moduleSdk) {
                PythonModulePathCache.updateCacheForSdk(module);
                this.clearCache();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileListener(this), (Disposable)this);
        PythonModulePathCache.updateCacheForSdk(module);
    }

    private static void updateCacheForSdk(Module module) {
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
        if (sdk != null) {
            PythonSdkPathCache.getInstance(module.getProject(), sdk);
        }
    }

    public void dispose() {
    }

    private final class WorkspaceListener
    implements WorkspaceModelChangeListener {
        private final Module myModule;

        WorkspaceListener(Module module) {
            this.myModule = module;
        }

        public void changed(@NotNull VersionedStorageChange event) {
            if (event == null) {
                WorkspaceListener.$$$reportNull$$$0(0);
            }
            if (!this.myModule.isDisposed()) {
                PythonModulePathCache.updateCacheForSdk(this.myModule);
            }
            List changes = event.getChanges(ModuleEntity.class);
            for (EntityChange change : changes) {
                ModuleBridge module;
                ModuleEntity entity = null;
                if (change instanceof EntityChange.Replaced) {
                    entity = (ModuleEntity)((EntityChange.Replaced)change).getOldEntity();
                } else if (change instanceof EntityChange.Removed) {
                    entity = (ModuleEntity)((EntityChange.Removed)change).getOldEntity();
                }
                if (entity == null || (module = ModuleEntityUtils.findModule((ModuleEntity)entity, (EntityStorage)event.getStorageBefore())) != this.myModule) continue;
                PythonModulePathCache.this.clearCache();
                return;
            }
            List sourceRootChanges = event.getChanges(SourceRootEntity.class);
            for (EntityChange change : sourceRootChanges) {
                ModuleEntity moduleEntity;
                ModuleBridge module;
                SourceRootEntity sourceRootEntity = null;
                if (change instanceof EntityChange.Added) {
                    sourceRootEntity = (SourceRootEntity)((EntityChange.Added)change).getNewEntity();
                } else if (change instanceof EntityChange.Removed) {
                    sourceRootEntity = (SourceRootEntity)((EntityChange.Removed)change).getOldEntity();
                }
                if (sourceRootEntity == null || (module = ModuleEntityUtils.findModule((ModuleEntity)(moduleEntity = sourceRootEntity.getContentRoot().getModule()), (EntityStorage)event.getStorageBefore())) != this.myModule) continue;
                PythonModulePathCache.this.clearCache();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonModulePathCache$WorkspaceListener", "changed"));
        }
    }
}

