/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/validation/PyLocalVariableAnnotatorVisitor;", "Lcom/jetbrains/python/psi/PyElementVisitor;", "holder", "Lcom/jetbrains/python/validation/PyAnnotationHolder;", "<init>", "(Lcom/jetbrains/python/validation/PyAnnotationHolder;)V", "visitPyTargetExpression", "", "node", "Lcom/jetbrains/python/psi/PyTargetExpression;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "isLocalVariable", "", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyLocalVariableHighlightingAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLocalVariableHighlightingAnnotator.kt\ncom/jetbrains/python/validation/PyLocalVariableAnnotatorVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1#2:42\n1807#3,3:43\n*S KotlinDebug\n*F\n+ 1 PyLocalVariableHighlightingAnnotator.kt\ncom/jetbrains/python/validation/PyLocalVariableAnnotatorVisitor\n*L\n27#1:43,3\n*E\n"})
final class PyLocalVariableAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder holder;

    public PyLocalVariableAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.isLocalVariable(node)) {
                return;
            }
            ASTNode aSTNode = node.getNameElement();
            if (aSTNode == null) break block1;
            ASTNode it = aSTNode;
            boolean bl = false;
            this.holder.addHighlightingAnnotation(it, PyHighlighter.PY_LOCAL_VARIABLE);
        }
    }

    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Collection<PsiElement> collection = PyResolveUtil.resolveLocally(node);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveLocally(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PyTargetExpression && this.isLocalVariable((PyTargetExpression)it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.holder.addHighlightingAnnotation(node.getNode(), PyHighlighter.PY_LOCAL_VARIABLE);
        }
    }

    private final boolean isLocalVariable(PyTargetExpression $this$isLocalVariable) {
        if ($this$isLocalVariable.isQualified()) {
            return false;
        }
        String string = $this$isLocalVariable.getReferencedName();
        if (string == null) {
            return false;
        }
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"_")) {
            return false;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)$this$isLocalVariable);
        if (!(scopeOwner instanceof PyFunction)) {
            return false;
        }
        Scope scope = ControlFlowCache.getScope(scopeOwner);
        Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"getScope(...)");
        Scope scope2 = scope;
        return !scope2.isNonlocal(name) && !scope2.isGlobal(name);
    }
}

