/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.legacy;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.sdk.CustomSdkHomePattern;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class PythonSdkUtil {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;
    static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    private static final Predicate<Sdk> REMOTE_SDK_PREDICATE = PythonSdkUtil::isRemote;

    public static boolean isPythonSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(0);
        }
        return PythonSdkUtil.isPythonSdk(sdk, false);
    }

    public static boolean isPythonSdk(@NotNull Sdk sdk, boolean allowRemoteInFreeTier) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(1);
        }
        if (!"Python SDK".equals(sdk.getSdkType().getName())) {
            return false;
        }
        if (PythonSdkUtil.isFreeTier()) {
            return allowRemoteInFreeTier || !PythonSdkUtil.isRemote(sdk);
        }
        return true;
    }

    public static boolean isFreeTier() {
        return PlatformUtils.isPyCharm() && !PlatformUtils.isDataSpell() && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull Sdk> getAllSdks() {
        return PythonSdkUtil.getAllSdks(false);
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull Sdk> getAllSdks(boolean allowRemoteInFreeTier) {
        List list = ContainerUtil.filter((Object[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> PythonSdkUtil.isPythonSdk(sdk, allowRemoteInFreeTier));
        if (list == null) {
            PythonSdkUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return null;
        }
        Sdk sdk = PyModuleService.getInstance().findPythonSdk(module);
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk)) {
            return sdk;
        }
        return null;
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataMarker;
    }

    @NlsSafe
    public static String getUserSite() {
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            return appdata + File.separator + "Python";
        }
        String userHome = SystemProperties.getUserHome();
        return userHome + File.separator + ".local";
    }

    public static boolean isFileInSkeletons(@NotNull VirtualFile virtualFile, @NotNull Sdk sdk) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(4);
        }
        return (skeletonsDir = PythonSdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        Sdk sdk;
        VirtualFile virtualFile;
        PsiFile file;
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(5);
        }
        return (file = element.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null && (sdk = PythonSdkUtil.findPythonSdk(element)) != null && PythonSdkUtil.isFileInSkeletons(virtualFile, sdk);
    }

    @NotNull
    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        String string = PythonSdkUtil.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static String getSkeletonsPath(@NotNull Sdk sdk) {
        String path;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(7);
        }
        return (path = sdk.getHomePath()) != null ? PythonSdkUtil.getSkeletonsPath(PathManager.getSystemPath(), path) : null;
    }

    @NotNull
    public static String getSkeletonsRootPath(String basePath) {
        String string = basePath + File.separator + SKELETON_DIR_NAME;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(9);
        }
        return PythonSdkUtil.findLibraryDir(sdk, SKELETON_DIR_NAME, BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(10);
        }
        return PythonSdkUtil.findLibraryDir(sdk, REMOTE_SOURCES_DIR_NAME, OrderRootType.CLASSES);
    }

    public static VirtualFile findLibraryDir(Sdk sdk, String dirName, OrderRootType rootType) {
        VirtualFile[] virtualFiles;
        for (VirtualFile virtualFile : virtualFiles = sdk.getRootProvider().getFiles(rootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(dirName)) continue;
            return virtualFile;
        }
        return null;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!PythonSdkUtil.isPythonSdk(sdk)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(11);
        }
        return sdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)sdk));
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkUtil.getAllSdks().stream().filter(REMOTE_SDK_PREDICATE.negate()).collect(Collectors.toList());
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        Path python;
        if (rootPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(12);
        }
        return (python = VirtualEnvReader.getInstance().findPythonInPythonRoot(Path.of(rootPath, new String[0]))) != null ? python.toString() : null;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        Path path;
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(13);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(14);
        }
        return (path = PythonSdkUtil.getExecutablePath(Path.of(homeDirectory, new String[0]), name)) != null ? path.toString() : null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static Path getExecutablePath(@NotNull Path homeDirectory, @NotNull String name) {
        String resolvedPath;
        String homeDirectoryAbsolutePath;
        Path binDir;
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(16);
        }
        if ((binDir = homeDirectory.getParent()) == null) {
            return null;
        }
        Path runner = binDir.resolve(name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        runner = binDir.resolve("Scripts").resolve(name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        if (binDir.getParent() != null) {
            runner = binDir.getParent().resolve("Scripts").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
            runner = binDir.getParent().resolve("local").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
            runner = binDir.getParent().resolve("local").resolve("bin").resolve(name);
            if (Files.exists(runner, new LinkOption[0])) {
                return runner;
            }
        }
        if (FileSystemUtil.isSymLink((String)(homeDirectoryAbsolutePath = homeDirectory.toAbsolutePath().toString())) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectoryAbsolutePath)) != null && !resolvedPath.equals(homeDirectoryAbsolutePath)) {
            return PythonSdkUtil.getExecutablePath(Path.of(resolvedPath, new String[0]), name);
        }
        runner = Path.of("/usr", "bin", name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        runner = Path.of("/usr", "local", "bin", name);
        if (Files.exists(runner, new LinkOption[0])) {
            return runner;
        }
        return null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        if (binaryPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(17);
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        File bin = new File(binaryPath).getParentFile();
        if (bin != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkUtil.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            if (new File(root, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file;
        if (SystemInfo.isWindows) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file2 = new File(parent, name + "." + suffix);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name)).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkUtil.$$$reportNull$$$0(18);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(19);
        }
        return PythonSdkUtil.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Deprecated
    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkUtil.findSdkByPath(PythonSdkUtil.getAllSdks(), path);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(20);
        }
        String path = sdk.getHomePath();
        return PythonSdkUtil.isVirtualEnv(path);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path) {
        return path != null && PythonSdkUtil.getVirtualEnvRoot(path) != null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static VirtualFile getCondaDirectory(@NotNull Sdk sdk) {
        VirtualFile homeDirectory;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(21);
        }
        if ((homeDirectory = sdk.getHomeDirectory()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return homeDirectory.getParent();
        }
        return homeDirectory.getParent().getParent();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(22);
        }
        return PythonSdkUtil.isCondaVirtualEnv(sdk.getHomePath());
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isCondaVirtualEnv(@Nullable String sdkPath) {
        SlowOperations.assertSlowOperationsAreAllowed();
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile envs = condaMeta.getParent().findChild("envs");
        return envs == null;
    }

    @Deprecated
    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(23);
        }
        return PythonSdkUtil.isConda(sdk.getHomePath());
    }

    @Deprecated
    public static boolean isConda(@Nullable String sdkPath) {
        return PythonSdkUtil.findCondaMeta(sdkPath) != null;
    }

    @Deprecated
    public static boolean isBaseConda(@Nullable String sdkPath) {
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile parent = condaMeta.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile condaBin = parent.findChild("condabin");
        if (condaBin != null) {
            return true;
        }
        return parent.findChild("envs") != null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static VirtualFile findCondaMeta(@Nullable String sdkPath) {
        SlowOperations.assertSlowOperationsAreAllowed();
        if (sdkPath == null || CustomSdkHomePattern.isCustomPythonSdkHomePath((String)sdkPath)) {
            return null;
        }
        VirtualFile homeDirectory = StandardFileSystems.local().findFileByPath(sdkPath);
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile parentDirectory = homeDirectory.getParent();
        if (parentDirectory == null) {
            return null;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? parentDirectory : parentDirectory.getParent();
        return condaParent != null ? condaParent.findChild("conda-meta") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/legacy/PythonSdkUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/legacy/PythonSdkUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSdks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPythonSdk";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileInSkeletons";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isElementInSkeletons";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAnyRemoteLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCondaDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 8 -> new IllegalStateException(string);
        };
    }
}

