/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.pom.Navigatable;
import com.intellij.util.OpenSourceUtil;
import git4idea.GitDisposable;
import git4idea.i18n.GitBundle;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageLineStatusTracker;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/index/actions/GitStageShowVersionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "showStaged", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "navigateToFile", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFile", "caret", "Lcom/intellij/openapi/editor/Caret;", "getTargetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.vcs.git"})
public abstract class GitStageShowVersionAction
extends DumbAwareAction {
    private final boolean showStaged;

    public GitStageShowVersionAction(boolean showStaged) {
        this.showStaged = showStaged;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file == null || file instanceof GitIndexVirtualFile == this.showStaged) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file);
        e.getPresentation().setVisible(status != null);
        GitFileStatus gitFileStatus = status;
        e.getPresentation().setEnabled(gitFileStatus != null ? GitFileStatusKt.has(gitFileStatus, this.showStaged ? ContentVersion.STAGED : ContentVersion.LOCAL) : false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile;
        VirtualFile virtualFile2 = GitStageTrackerKt.getRoot(project2, sourceFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile root = virtualFile2;
        Caret caret = (Caret)e.getData(CommonDataKeys.CARET);
        if (this.showStaged) {
            BuildersKt.async$default((CoroutineScope)GitDisposable.Companion.getInstance(project2).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sourceFile, project2, root, this, caret, null){
                Object L$0;
                int label;
                final /* synthetic */ VirtualFile $sourceFile;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $root;
                final /* synthetic */ GitStageShowVersionAction this$0;
                final /* synthetic */ Caret $caret;
                {
                    this.$sourceFile = $sourceFile;
                    this.$project = $project;
                    this.$root = $root;
                    this.this$0 = $receiver;
                    this.$caret = $caret;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            FilePath filePath = GitIndexVirtualFileKt.filePath(this.$sourceFile);
                            Object[] objectArray = new Object[]{filePath.getName()};
                            String string = GitBundle.message("stage.vfs.read.process", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)filePath);
                            this.label = 1;
                            Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$root, filePath, this.this$0, this.$sourceFile, this.$caret, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ VirtualFile $root;
                                final /* synthetic */ FilePath $filePath;
                                final /* synthetic */ GitStageShowVersionAction this$0;
                                final /* synthetic */ VirtualFile $sourceFile;
                                final /* synthetic */ Caret $caret;
                                {
                                    this.$project = $project;
                                    this.$root = $root;
                                    this.$filePath = $filePath;
                                    this.this$0 = $receiver;
                                    this.$sourceFile = $sourceFile;
                                    this.$caret = $caret;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            GitIndexVirtualFile gitIndexVirtualFile = GitIndexFileSystemRefresher.Companion.getInstance(this.$project).createFile(this.$root, this.$filePath);
                                            if (gitIndexVirtualFile == null) {
                                                return Unit.INSTANCE;
                                            }
                                            GitIndexVirtualFile targetFile = gitIndexVirtualFile;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)((Object)targetFile));
                                            this.label = 1;
                                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$project, targetFile, this.$sourceFile, this.$caret, null){
                                                int label;
                                                final /* synthetic */ GitStageShowVersionAction this$0;
                                                final /* synthetic */ Project $project;
                                                final /* synthetic */ GitIndexVirtualFile $targetFile;
                                                final /* synthetic */ VirtualFile $sourceFile;
                                                final /* synthetic */ Caret $caret;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$project = $project;
                                                    this.$targetFile = $targetFile;
                                                    this.$sourceFile = $sourceFile;
                                                    this.$caret = $caret;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            GitStageShowVersionAction.access$navigateToFile(this.this$0, this.$project, this.$targetFile, this.$sourceFile, this.$caret);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            GitIndexVirtualFile targetFile = (GitIndexVirtualFile)((Object)this.L$0);
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            FilePath filePath = (FilePath)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            VirtualFile virtualFile3 = GitIndexVirtualFileKt.filePath(sourceFile).getVirtualFile();
            if (virtualFile3 == null) {
                return;
            }
            VirtualFile targetFile = virtualFile3;
            this.navigateToFile(project2, targetFile, sourceFile, caret);
        }
    }

    private final void navigateToFile(Project project, VirtualFile targetFile, VirtualFile sourceFile, Caret caret) {
        if (caret == null) {
            Navigatable[] navigatableArray = new Navigatable[]{new OpenFileDescriptor(project, targetFile)};
            OpenSourceUtil.navigate((Navigatable[])navigatableArray);
        } else {
            LogicalPosition targetPosition = this.getTargetPosition(project, sourceFile, targetFile, caret);
            Navigatable[] navigatableArray = new Navigatable[]{new OpenFileDescriptor(project, targetFile, targetPosition.line, targetPosition.column)};
            OpenSourceUtil.navigate((Navigatable[])navigatableArray);
        }
    }

    private final LogicalPosition getTargetPosition(Project project, VirtualFile sourceFile, VirtualFile targetFile, Caret caret) {
        LineStatusTracker lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(this.showStaged ? sourceFile : targetFile);
        if (lineStatusTracker == null) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            return logicalPosition;
        }
        LineStatusTracker lst = lineStatusTracker;
        if (!(lst instanceof GitStageLineStatusTracker)) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            return logicalPosition;
        }
        int line = this.showStaged ? ((GitStageLineStatusTracker)lst).transferLineFromLocalToStaged(caret.getLogicalPosition().line, true) : ((GitStageLineStatusTracker)lst).transferLineFromStagedToLocal(caret.getLogicalPosition().line, true);
        return new LogicalPosition(line, caret.getLogicalPosition().column);
    }

    public static final /* synthetic */ void access$navigateToFile(GitStageShowVersionAction $this, Project project, VirtualFile targetFile, VirtualFile sourceFile, Caret caret) {
        $this.navigateToFile(project, targetFile, sourceFile, caret);
    }
}

